/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview.holder;

import android.support.annotation.ColorInt;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public abstract class AbstractViewHolder
extends RecyclerView.ViewHolder {
    private SelectionState m_eState = SelectionState.UNSELECTED;

    public AbstractViewHolder(View itemView) {
        super(itemView);
    }

    public void setSelected(SelectionState selectionState) {
        this.m_eState = selectionState;
        if (selectionState == SelectionState.SELECTED) {
            this.itemView.setSelected(true);
        } else if (selectionState == SelectionState.UNSELECTED) {
            this.itemView.setSelected(false);
        }
    }

    public boolean isSelected() {
        return this.m_eState == SelectionState.SELECTED;
    }

    public boolean isShadowed() {
        return this.m_eState == SelectionState.SHADOWED;
    }

    public void setBackgroundColor(@ColorInt int p_nColor) {
        this.itemView.setBackgroundColor(p_nColor);
    }

    public void onViewRecycled() {
    }

    public boolean onFailedToRecycleView() {
        return false;
    }

    public static enum SelectionState {
        SELECTED,
        UNSELECTED,
        SHADOWED;

    }
}

