/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.filter;

import android.text.TextUtils;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.filter.FilterItem;
import com.evrencoskun.tableview.filter.FilterType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Filter {
    private List<FilterItem> filterItems;
    private ITableView tableView;

    public Filter(ITableView tableView) {
        this.tableView = tableView;
        this.filterItems = new ArrayList<FilterItem>();
    }

    public void set(String filter) {
        this.set(-1, filter);
    }

    public void set(int column, String filter) {
        FilterItem filterItem = new FilterItem(column == -1 ? FilterType.ALL : FilterType.COLUMN, column, filter);
        if (this.isAlreadyFiltering(column, filterItem)) {
            if (TextUtils.isEmpty((CharSequence)filter)) {
                this.remove(column, filterItem);
            } else {
                this.update(column, filterItem);
            }
        } else if (!TextUtils.isEmpty((CharSequence)filter)) {
            this.add(filterItem);
        }
    }

    private void add(FilterItem filterItem) {
        this.filterItems.add(filterItem);
        this.tableView.filter(this);
    }

    private void remove(int column, FilterItem filterItem) {
        Iterator<FilterItem> filterItemIterator = this.filterItems.iterator();
        while (filterItemIterator.hasNext()) {
            FilterItem item = filterItemIterator.next();
            if (column == -1 && item.getFilterType().equals((Object)filterItem.getFilterType())) {
                filterItemIterator.remove();
                break;
            }
            if (item.getColumn() != filterItem.getColumn()) continue;
            filterItemIterator.remove();
            break;
        }
        this.tableView.filter(this);
    }

    private void update(int column, FilterItem filterItem) {
        for (FilterItem item : this.filterItems) {
            if (column == -1 && item.getFilterType().equals((Object)filterItem.getFilterType())) {
                this.filterItems.set(this.filterItems.indexOf(item), filterItem);
                break;
            }
            if (item.getColumn() != filterItem.getColumn()) continue;
            this.filterItems.set(this.filterItems.indexOf(item), filterItem);
            break;
        }
        this.tableView.filter(this);
    }

    private boolean isAlreadyFiltering(int column, FilterItem filterItem) {
        for (FilterItem item : this.filterItems) {
            if (column == -1 && item.getFilterType().equals((Object)filterItem.getFilterType())) {
                return true;
            }
            if (item.getColumn() != filterItem.getColumn()) continue;
            return true;
        }
        return false;
    }

    public List<FilterItem> getFilterItems() {
        return this.filterItems;
    }
}

