/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class CellRecyclerViewItemClickListener
extends AbstractItemClickListener {
    private static final String LOG_TAG = CellRecyclerViewItemClickListener.class.getSimpleName();
    private CellRecyclerView m_iCellRecyclerView;

    public CellRecyclerViewItemClickListener(CellRecyclerView p_jRecyclerView, ITableView p_iTableView) {
        super(p_jRecyclerView, p_iTableView);
        this.m_iCellRecyclerView = p_iTableView.getCellRecyclerView();
    }

    @Override
    protected boolean clickAction(RecyclerView view, MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null && this.m_jGestureDetector.onTouchEvent(e)) {
            AbstractViewHolder holder = (AbstractViewHolder)this.m_jRecyclerView.getChildViewHolder(childView);
            CellRowRecyclerViewAdapter adapter = (CellRowRecyclerViewAdapter)this.m_jRecyclerView.getAdapter();
            int nXPosition = holder.getAdapterPosition();
            int nYPosition = adapter.getYPosition();
            if (!this.m_iTableView.isIgnoreSelectionColors()) {
                this.m_iSelectionHandler.setSelectedCellPositions(holder, nXPosition, nYPosition);
            }
            if (this.getTableViewListener() != null) {
                this.getTableViewListener().onCellClicked(holder, nXPosition, nYPosition);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(MotionEvent e) {
    }
}

