/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;

public class SelectionHandler {
    public static final int UNSELECTED_POSITION = -1;
    private int m_nSelectedRowPosition = -1;
    private int m_nSelectedColumnPosition = -1;
    private ITableView m_iTableView;
    private AbstractViewHolder m_jPreviousSelectedViewHolder;
    private CellRecyclerView m_iColumnHeaderRecyclerView;
    private CellRecyclerView m_iRowHeaderRecyclerView;

    public SelectionHandler(ITableView p_iTableView) {
        this.m_iTableView = p_iTableView;
        this.m_iColumnHeaderRecyclerView = this.m_iTableView.getColumnHeaderRecyclerView();
        this.m_iRowHeaderRecyclerView = this.m_iTableView.getRowHeaderRecyclerView();
    }

    public void setSelectedCellPositions(AbstractViewHolder p_jSelectedViewHolder, int p_nXPosition, int p_nYPosition) {
        this.setPreviousSelectedView(p_jSelectedViewHolder);
        this.m_nSelectedColumnPosition = p_nXPosition;
        this.m_nSelectedRowPosition = p_nYPosition;
        this.selectedCellView();
    }

    public void setSelectedColumnPosition(AbstractViewHolder p_jSelectedViewHolder, int p_nXPosition) {
        this.setPreviousSelectedView(p_jSelectedViewHolder);
        this.m_nSelectedColumnPosition = p_nXPosition;
        this.selectedColumnHeader();
        this.m_nSelectedRowPosition = -1;
    }

    public int getSelectedColumnPosition() {
        return this.m_nSelectedColumnPosition;
    }

    public void setSelectedRowPosition(AbstractViewHolder p_jSelectedViewHolder, int p_nYPosition) {
        this.setPreviousSelectedView(p_jSelectedViewHolder);
        this.m_nSelectedRowPosition = p_nYPosition;
        this.selectedRowHeader();
        this.m_nSelectedColumnPosition = -1;
    }

    public int getSelectedRowPosition() {
        return this.m_nSelectedRowPosition;
    }

    public void setPreviousSelectedView(AbstractViewHolder p_jViewHolder) {
        AbstractViewHolder oldViewHolder;
        this.restorePreviousSelectedView();
        if (this.m_jPreviousSelectedViewHolder != null) {
            this.m_jPreviousSelectedViewHolder.setBackgroundColor(this.m_iTableView.getUnSelectedColor());
            this.m_jPreviousSelectedViewHolder.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        if ((oldViewHolder = this.m_iTableView.getCellLayoutManager().getCellViewHolder(this.getSelectedColumnPosition(), this.getSelectedRowPosition())) != null) {
            oldViewHolder.setBackgroundColor(this.m_iTableView.getUnSelectedColor());
            oldViewHolder.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        this.m_jPreviousSelectedViewHolder = p_jViewHolder;
        this.m_jPreviousSelectedViewHolder.setBackgroundColor(this.m_iTableView.getSelectedColor());
        this.m_jPreviousSelectedViewHolder.setSelected(AbstractViewHolder.SelectionState.SELECTED);
    }

    private void restorePreviousSelectedView() {
        if (this.m_nSelectedColumnPosition != -1 && this.m_nSelectedRowPosition != -1) {
            this.unselectedCellView();
        } else if (this.m_nSelectedColumnPosition != -1) {
            this.unselectedColumnHeader();
        } else if (this.m_nSelectedRowPosition != -1) {
            this.unselectedRowHeader();
        }
    }

    private void selectedRowHeader() {
        this.changeVisibleCellViewsBackgroundForRow(this.m_nSelectedRowPosition, true);
        this.m_iTableView.getColumnHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.SHADOWED, this.m_iTableView.getShadowColor(), false);
    }

    private void unselectedRowHeader() {
        this.changeVisibleCellViewsBackgroundForRow(this.m_nSelectedRowPosition, false);
        this.m_iTableView.getColumnHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.m_iTableView.getUnSelectedColor(), false);
    }

    private void selectedCellView() {
        AbstractViewHolder columnHeader;
        int nShadowColor = this.m_iTableView.getShadowColor();
        AbstractViewHolder rowHeader = (AbstractViewHolder)this.m_iRowHeaderRecyclerView.findViewHolderForAdapterPosition(this.m_nSelectedRowPosition);
        if (rowHeader != null) {
            rowHeader.setBackgroundColor(nShadowColor);
            rowHeader.setSelected(AbstractViewHolder.SelectionState.SHADOWED);
        }
        if ((columnHeader = (AbstractViewHolder)this.m_iColumnHeaderRecyclerView.findViewHolderForAdapterPosition(this.m_nSelectedColumnPosition)) != null) {
            columnHeader.setBackgroundColor(nShadowColor);
            columnHeader.setSelected(AbstractViewHolder.SelectionState.SHADOWED);
        }
    }

    private void unselectedCellView() {
        AbstractViewHolder columnHeader;
        int nUnSelectedColor = this.m_iTableView.getUnSelectedColor();
        AbstractViewHolder rowHeader = (AbstractViewHolder)this.m_iRowHeaderRecyclerView.findViewHolderForAdapterPosition(this.m_nSelectedRowPosition);
        if (rowHeader != null) {
            rowHeader.setBackgroundColor(nUnSelectedColor);
            rowHeader.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        if ((columnHeader = (AbstractViewHolder)this.m_iColumnHeaderRecyclerView.findViewHolderForAdapterPosition(this.m_nSelectedColumnPosition)) != null) {
            columnHeader.setBackgroundColor(nUnSelectedColor);
            columnHeader.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
    }

    private void selectedColumnHeader() {
        this.changeVisibleCellViewsBackgroundForColumn(this.m_nSelectedColumnPosition, true);
        this.m_iTableView.getRowHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.SHADOWED, this.m_iTableView.getShadowColor(), false);
    }

    private void unselectedColumnHeader() {
        this.changeVisibleCellViewsBackgroundForColumn(this.m_nSelectedColumnPosition, false);
        this.m_iTableView.getRowHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.m_iTableView.getUnSelectedColor(), false);
    }

    public boolean isCellSelected(int p_nXPosition, int p_nYPosition) {
        return this.getSelectedColumnPosition() == p_nXPosition && this.getSelectedRowPosition() == p_nYPosition || this.isColumnSelected(p_nXPosition) || this.isRowSelected(p_nYPosition);
    }

    public AbstractViewHolder.SelectionState getCellSelectionState(int p_nXPosition, int p_nYPosition) {
        if (this.isCellSelected(p_nXPosition, p_nYPosition)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    public boolean isColumnSelected(int p_nXPosition) {
        return this.getSelectedColumnPosition() == p_nXPosition && this.getSelectedRowPosition() == -1;
    }

    public boolean isColumnShadowed(int p_nXPosition) {
        return this.getSelectedColumnPosition() == p_nXPosition && this.getSelectedRowPosition() != -1 || this.getSelectedColumnPosition() == -1 && this.getSelectedRowPosition() != -1;
    }

    public boolean isAnyColumnSelected() {
        return this.getSelectedColumnPosition() != -1 && this.getSelectedRowPosition() == -1;
    }

    public AbstractViewHolder.SelectionState getColumnSelectionState(int p_nXPosition) {
        if (this.isColumnShadowed(p_nXPosition)) {
            return AbstractViewHolder.SelectionState.SHADOWED;
        }
        if (this.isColumnSelected(p_nXPosition)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    public boolean isRowSelected(int p_nYPosition) {
        return this.getSelectedRowPosition() == p_nYPosition && this.getSelectedColumnPosition() == -1;
    }

    public boolean isRowShadowed(int p_nYPosition) {
        return this.getSelectedRowPosition() == p_nYPosition && this.getSelectedColumnPosition() != -1 || this.getSelectedRowPosition() == -1 && this.getSelectedColumnPosition() != -1;
    }

    public AbstractViewHolder.SelectionState getRowSelectionState(int p_nYPosition) {
        if (this.isRowShadowed(p_nYPosition)) {
            return AbstractViewHolder.SelectionState.SHADOWED;
        }
        if (this.isRowSelected(p_nYPosition)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    private void changeVisibleCellViewsBackgroundForRow(int p_nYPosition, boolean p_bIsSelected) {
        int nSelectedColor = this.m_iTableView.getSelectedColor();
        int nUnSelectedColor = this.m_iTableView.getUnSelectedColor();
        CellRecyclerView recyclerView = (CellRecyclerView)this.m_iTableView.getCellLayoutManager().findViewByPosition(p_nYPosition);
        if (recyclerView == null) {
            return;
        }
        recyclerView.setSelected(p_bIsSelected ? AbstractViewHolder.SelectionState.SELECTED : AbstractViewHolder.SelectionState.UNSELECTED, p_bIsSelected ? nSelectedColor : nUnSelectedColor, false);
    }

    private void changeVisibleCellViewsBackgroundForColumn(int p_nXPosition, boolean p_bIsSelected) {
        int nSelectedColor = this.m_iTableView.getSelectedColor();
        int nUnSelectedColor = this.m_iTableView.getUnSelectedColor();
        AbstractViewHolder[] visibleCellViews = this.m_iTableView.getCellLayoutManager().getVisibleCellViewsByColumnPosition(p_nXPosition);
        if (visibleCellViews != null) {
            for (AbstractViewHolder viewHolder : visibleCellViews) {
                if (viewHolder == null) continue;
                viewHolder.setBackgroundColor(p_bIsSelected ? nSelectedColor : nUnSelectedColor);
                viewHolder.setSelected(p_bIsSelected ? AbstractViewHolder.SelectionState.SELECTED : AbstractViewHolder.SelectionState.UNSELECTED);
            }
        }
    }

    public void changeRowBackgroundColorBySelectionStatus(AbstractViewHolder p_iViewHolder, AbstractViewHolder.SelectionState p_iSelectionState) {
        if (p_iSelectionState == AbstractViewHolder.SelectionState.SHADOWED) {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getShadowColor());
        } else if (p_iSelectionState == AbstractViewHolder.SelectionState.SELECTED) {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getSelectedColor());
        } else {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getUnSelectedColor());
        }
    }

    public void changeColumnBackgroundColorBySelectionStatus(AbstractViewHolder p_iViewHolder, AbstractViewHolder.SelectionState p_jSelectionState) {
        if (p_jSelectionState == AbstractViewHolder.SelectionState.SHADOWED) {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getShadowColor());
        } else if (p_jSelectionState == AbstractViewHolder.SelectionState.SELECTED) {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getSelectedColor());
        } else {
            p_iViewHolder.setBackgroundColor(this.m_iTableView.getUnSelectedColor());
        }
    }
}

