/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRecyclerViewAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected List<T> mItemList;
    protected Context mContext;

    public AbstractRecyclerViewAdapter(Context context) {
        this(context, null);
    }

    public AbstractRecyclerViewAdapter(Context context, List<T> itemList) {
        this.mContext = context;
        if (itemList != null) {
            this.mItemList = new ArrayList<T>(itemList);
            this.notifyDataSetChanged();
        } else {
            this.mItemList = new ArrayList<T>();
        }
    }

    public int getItemCount() {
        return this.mItemList.size();
    }

    public List<T> getItems() {
        return this.mItemList;
    }

    public void setItems(List<T> itemList) {
        this.mItemList = new ArrayList<T>(itemList);
        this.notifyDataSetChanged();
    }

    public void setItems(List<T> itemList, boolean notifyDataSet) {
        this.mItemList = new ArrayList<T>(itemList);
        if (notifyDataSet) {
            this.notifyDataSetChanged();
        }
    }

    public T getItem(int position) {
        if (this.mItemList == null || this.mItemList.isEmpty() || position < 0 || position >= this.mItemList.size()) {
            return null;
        }
        return this.mItemList.get(position);
    }

    public void deleteItem(int position) {
        if (position != -1) {
            this.mItemList.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public void deleteItemRange(int positionStart, int itemCount) {
        for (int i = positionStart; i < positionStart + itemCount + 1; ++i) {
            if (i == -1) continue;
            this.mItemList.remove(i);
        }
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void addItem(int position, T item) {
        if (position != -1 && item != null) {
            this.mItemList.add(position, item);
            this.notifyItemInserted(position);
        }
    }

    public void addItemRange(int positionStart, List<T> items) {
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (i == -1) continue;
                this.mItemList.add(i + positionStart, items.get(i));
            }
            this.notifyItemRangeInserted(positionStart, items.size());
        }
    }

    public void changeItem(int position, T item) {
        if (position != -1 && item != null) {
            this.mItemList.set(position, item);
            this.notifyItemChanged(position);
        }
    }

    public void changeItemRange(int positionStart, List<T> items) {
        if (this.mItemList.size() > positionStart + items.size() && items != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (i == -1) continue;
                this.mItemList.set(i + positionStart, items.get(i));
            }
            this.notifyItemRangeChanged(positionStart, items.size());
        }
    }

    public int getItemViewType(int position) {
        return 1;
    }
}

