/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.scroll;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MotionEvent;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;

public class HorizontalRecyclerViewListener
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = HorizontalRecyclerViewListener.class.getSimpleName();
    private CellRecyclerView m_jColumnHeaderRecyclerView;
    private RecyclerView.LayoutManager m_jCellLayoutManager;
    private RecyclerView m_jLastTouchedRecyclerView;
    private boolean m_bMoved = false;
    private int m_nXPosition;
    private int m_nScrollPosition;
    private int m_nScrollPositionOffset = 0;
    private VerticalRecyclerViewListener m_iVerticalRecyclerViewListener;

    public HorizontalRecyclerViewListener(ITableView p_iTableView) {
        this.m_jColumnHeaderRecyclerView = p_iTableView.getColumnHeaderRecyclerView();
        this.m_jCellLayoutManager = p_iTableView.getCellRecyclerView().getLayoutManager();
        this.m_iVerticalRecyclerViewListener = p_iTableView.getVerticalRecyclerViewListener();
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (e.getAction() == 0) {
            if (rv.getScrollState() == 0) {
                if (this.m_jLastTouchedRecyclerView != null && rv != this.m_jLastTouchedRecyclerView) {
                    if (this.m_jLastTouchedRecyclerView == this.m_jColumnHeaderRecyclerView) {
                        this.m_jColumnHeaderRecyclerView.removeOnScrollListener(this);
                        this.m_jColumnHeaderRecyclerView.stopScroll();
                        Log.d((String)LOG_TAG, (String)"Scroll listener  has been removed to m_jColumnHeaderRecyclerView at last touch control");
                    } else {
                        int nLastTouchedIndex = this.getIndex(this.m_jLastTouchedRecyclerView);
                        if (nLastTouchedIndex >= 0 && nLastTouchedIndex < this.m_jCellLayoutManager.getChildCount() && !((CellRecyclerView)this.m_jLastTouchedRecyclerView).isHorizontalScrollListenerRemoved()) {
                            ((RecyclerView)this.m_jCellLayoutManager.getChildAt(nLastTouchedIndex)).removeOnScrollListener((RecyclerView.OnScrollListener)this);
                            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + this.m_jLastTouchedRecyclerView.getId() + " CellRecyclerView at last touch control"));
                            ((RecyclerView)this.m_jCellLayoutManager.getChildAt(nLastTouchedIndex)).stopScroll();
                        }
                    }
                }
                this.m_nXPosition = ((CellRecyclerView)rv).getScrolledX();
                rv.addOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been added to " + rv.getId() + " at action down"));
            }
        } else if (e.getAction() == 2) {
            this.m_bMoved = true;
        } else if (e.getAction() == 1) {
            int nScrollX = ((CellRecyclerView)rv).getScrolledX();
            if (this.m_nXPosition == nScrollX && !this.m_bMoved) {
                rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action up"));
            }
            this.m_jLastTouchedRecyclerView = rv;
        } else if (e.getAction() == 3) {
            this.renewScrollPosition(rv);
            rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action cancel"));
            this.m_bMoved = false;
            this.m_jLastTouchedRecyclerView = rv;
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (recyclerView == this.m_jColumnHeaderRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.m_jCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.m_jCellLayoutManager.getChildAt(i);
                child.scrollBy(dx, 0);
            }
        } else {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.m_jCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.m_jCellLayoutManager.getChildAt(i);
                if (child == recyclerView) continue;
                child.scrollBy(dx, 0);
            }
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 0) {
            this.renewScrollPosition(recyclerView);
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener has been removed to " + recyclerView.getId() + " at onScrollStateChanged"));
            this.m_bMoved = false;
            boolean bNeeded = this.m_jLastTouchedRecyclerView != this.m_jColumnHeaderRecyclerView;
            this.m_iVerticalRecyclerViewListener.removeLastTouchedRecyclerViewScrollListener(bNeeded);
        }
    }

    private int getIndex(RecyclerView rv) {
        for (int i = 0; i < this.m_jCellLayoutManager.getChildCount(); ++i) {
            RecyclerView child = (RecyclerView)this.m_jCellLayoutManager.getChildAt(i);
            if (child != rv) continue;
            return i;
        }
        return -1;
    }

    private void renewScrollPosition(RecyclerView p_jRecyclerView) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)p_jRecyclerView.getLayoutManager();
        this.m_nScrollPosition = layoutManager.findFirstCompletelyVisibleItemPosition();
        if (this.m_nScrollPosition == -1) {
            this.m_nScrollPosition = layoutManager.findFirstVisibleItemPosition();
            if (layoutManager.findFirstVisibleItemPosition() != layoutManager.findLastVisibleItemPosition()) {
                ++this.m_nScrollPosition;
            }
        }
        this.m_nScrollPositionOffset = p_jRecyclerView.getLayoutManager().findViewByPosition(this.m_nScrollPosition).getLeft();
    }

    public int getScrollPosition() {
        return this.m_nScrollPosition;
    }

    public int getScrollPositionOffset() {
        return this.m_nScrollPositionOffset;
    }

    public void setScrollPositionOffset(int p_nOffset) {
        this.m_nScrollPositionOffset = p_nOffset;
    }
}

