/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.TableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.ColumnHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import java.util.List;

public abstract class AbstractTableAdapter<CH, RH, C>
implements ITableAdapter {
    private int m_nRowHeaderWidth;
    private int m_nColumnHeaderHeight;
    protected Context m_jContext;
    private ColumnHeaderRecyclerViewAdapter m_iColumnHeaderRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter m_iRowHeaderRecyclerViewAdapter;
    private CellRecyclerViewAdapter m_iCellRecyclerViewAdapter;
    private View m_jCornerView;
    protected List<CH> m_jColumnHeaderItems;
    protected List<RH> m_jRowHeaderItems;
    protected List<List<C>> m_jCellItems;
    private ITableView m_iTableView;

    public AbstractTableAdapter(Context p_jContext) {
        this.m_jContext = p_jContext;
        this.initialize();
    }

    private void initialize() {
        this.m_iColumnHeaderRecyclerViewAdapter = new ColumnHeaderRecyclerViewAdapter<CH>(this.m_jContext, this.m_jColumnHeaderItems, this);
        this.m_iRowHeaderRecyclerViewAdapter = new RowHeaderRecyclerViewAdapter<RH>(this.m_jContext, this.m_jRowHeaderItems, this);
        this.m_iCellRecyclerViewAdapter = new CellRecyclerViewAdapter<List<C>>(this.m_jContext, this.m_jCellItems, this);
    }

    public void setColumnHeaderItems(List<CH> p_jColumnHeaderItems) {
        if (p_jColumnHeaderItems == null) {
            return;
        }
        this.m_jColumnHeaderItems = p_jColumnHeaderItems;
        this.m_iColumnHeaderRecyclerViewAdapter.setItems(this.m_jColumnHeaderItems);
    }

    public void setRowHeaderItems(List<RH> p_jRowHeaderItems) {
        if (p_jRowHeaderItems == null) {
            return;
        }
        this.m_jRowHeaderItems = p_jRowHeaderItems;
        this.m_iRowHeaderRecyclerViewAdapter.setItems(this.m_jRowHeaderItems);
    }

    public void setCellItems(List<List<C>> p_jCellItems) {
        if (p_jCellItems == null) {
            return;
        }
        this.m_jCellItems = p_jCellItems;
        this.m_iCellRecyclerViewAdapter.setItems(this.m_jCellItems);
    }

    public void setAllItems(List<CH> p_jColumnHeaderItems, List<RH> p_jRowHeaderItems, List<List<C>> p_jCellItems) {
        this.setColumnHeaderItems(p_jColumnHeaderItems);
        this.setRowHeaderItems(p_jRowHeaderItems);
        this.setCellItems(p_jCellItems);
        if (!(p_jColumnHeaderItems == null || p_jColumnHeaderItems.isEmpty() || p_jRowHeaderItems == null || p_jRowHeaderItems.isEmpty() || p_jCellItems == null || p_jCellItems.isEmpty() || this.m_iTableView == null || this.m_jCornerView != null)) {
            this.m_jCornerView = this.onCreateCornerView();
            this.m_iTableView.addView(this.m_jCornerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.m_nRowHeaderWidth, this.m_nColumnHeaderHeight));
        } else if (this.m_jCornerView != null) {
            if (p_jRowHeaderItems != null && !p_jRowHeaderItems.isEmpty()) {
                this.m_jCornerView.setVisibility(8);
            } else {
                this.m_jCornerView.setVisibility(0);
            }
        }
    }

    public ColumnHeaderRecyclerViewAdapter getColumnHeaderRecyclerViewAdapter() {
        return this.m_iColumnHeaderRecyclerViewAdapter;
    }

    public RowHeaderRecyclerViewAdapter getRowHeaderRecyclerViewAdapter() {
        return this.m_iRowHeaderRecyclerViewAdapter;
    }

    public CellRecyclerViewAdapter getCellRecyclerViewAdapter() {
        return this.m_iCellRecyclerViewAdapter;
    }

    public void setRowHeaderWidth(int p_nRowHeaderWidth) {
        this.m_nRowHeaderWidth = p_nRowHeaderWidth;
    }

    public void setColumnHeaderHeight(int p_nColumnHeaderHeight) {
        this.m_nColumnHeaderHeight = p_nColumnHeaderHeight;
    }

    public CH getColumnHeaderItem(int p_nPosition) {
        if (this.m_jColumnHeaderItems == null || this.m_jColumnHeaderItems.isEmpty() || p_nPosition < 0 || p_nPosition >= this.m_jColumnHeaderItems.size()) {
            return null;
        }
        return this.m_jColumnHeaderItems.get(p_nPosition);
    }

    public RH getRowHeaderItem(int p_nPosition) {
        if (this.m_jRowHeaderItems == null || this.m_jRowHeaderItems.isEmpty() || p_nPosition < 0 || p_nPosition >= this.m_jRowHeaderItems.size()) {
            return null;
        }
        return this.m_jRowHeaderItems.get(p_nPosition);
    }

    public C getCellItem(int p_nXPosition, int p_nYPosition) {
        if (this.m_jCellItems == null || this.m_jCellItems.isEmpty() || p_nXPosition < 0 || p_nYPosition >= this.m_jCellItems.size() || this.m_jCellItems.get(p_nYPosition) == null || p_nYPosition < 0 || p_nXPosition >= this.m_jCellItems.get(p_nYPosition).size()) {
            return null;
        }
        return this.m_jCellItems.get(p_nYPosition).get(p_nXPosition);
    }

    public final void notifyDataSetChanged() {
        this.m_iColumnHeaderRecyclerViewAdapter.notifyDataSetChanged();
        this.m_iRowHeaderRecyclerViewAdapter.notifyDataSetChanged();
        this.m_iCellRecyclerViewAdapter.notifyCellDataSetChanged();
    }

    public void setTableView(TableView p_iTableView) {
        this.m_iTableView = p_iTableView;
    }

    @Override
    public ITableView getTableView() {
        return this.m_iTableView;
    }
}

