/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.R;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;

public class CellRecyclerView
extends RecyclerView {
    private static final String LOG_TAG = CellRecyclerView.class.getSimpleName();
    private int mScrolledX = 0;
    private int mScrolledY = 0;
    private boolean mIsHorizontalScrollListenerRemoved = true;
    private boolean mIsVerticalScrollListenerRemoved = true;

    public CellRecyclerView(@NonNull Context context) {
        super(context);
        this.setHasFixedSize(false);
        this.setNestedScrollingEnabled(false);
        this.setItemViewCacheSize(context.getResources().getInteger(R.integer.default_item_cache_size));
        this.setDrawingCacheEnabled(true);
        this.setDrawingCacheQuality(0x100000);
    }

    public void onScrolled(int dx, int dy) {
        this.mScrolledX += dx;
        this.mScrolledY += dy;
        super.onScrolled(dx, dy);
    }

    public int getScrolledX() {
        return this.mScrolledX;
    }

    public void clearScrolledX() {
        this.mScrolledX = 0;
    }

    public int getScrolledY() {
        return this.mScrolledY;
    }

    public void addOnScrollListener(@NonNull RecyclerView.OnScrollListener listener) {
        if (listener instanceof HorizontalRecyclerViewListener) {
            if (this.mIsHorizontalScrollListenerRemoved) {
                this.mIsHorizontalScrollListenerRemoved = false;
                super.addOnScrollListener(listener);
            } else {
                Log.w((String)LOG_TAG, (String)"mIsHorizontalScrollListenerRemoved has been tried to add itself before remove the old one");
            }
        } else if (listener instanceof VerticalRecyclerViewListener) {
            if (this.mIsVerticalScrollListenerRemoved) {
                this.mIsVerticalScrollListenerRemoved = false;
                super.addOnScrollListener(listener);
            } else {
                Log.w((String)LOG_TAG, (String)"mIsVerticalScrollListenerRemoved has been tried to add itself before remove the old one");
            }
        } else {
            super.addOnScrollListener(listener);
        }
    }

    public void removeOnScrollListener(@NonNull RecyclerView.OnScrollListener listener) {
        if (listener instanceof HorizontalRecyclerViewListener) {
            if (this.mIsHorizontalScrollListenerRemoved) {
                Log.e((String)LOG_TAG, (String)"HorizontalRecyclerViewListener has been tried to remove itself before add new one");
            } else {
                this.mIsHorizontalScrollListenerRemoved = true;
                super.removeOnScrollListener(listener);
            }
        } else if (listener instanceof VerticalRecyclerViewListener) {
            if (this.mIsVerticalScrollListenerRemoved) {
                Log.e((String)LOG_TAG, (String)"mIsVerticalScrollListenerRemoved has been tried to remove itself before add new one");
            } else {
                this.mIsVerticalScrollListenerRemoved = true;
                super.removeOnScrollListener(listener);
            }
        } else {
            super.removeOnScrollListener(listener);
        }
    }

    public boolean isHorizontalScrollListenerRemoved() {
        return this.mIsHorizontalScrollListenerRemoved;
    }

    public boolean isScrollOthers() {
        return !this.mIsHorizontalScrollListenerRemoved;
    }

    public boolean fling(int velocityX, int velocityY) {
        return super.fling(velocityX, velocityY);
    }
}

