/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.pagination;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.AdapterDataSetChangedListener;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.filter.FilterChangedListener;
import com.evrencoskun.tableview.pagination.IPagination;
import com.evrencoskun.tableview.sort.ColumnForRowHeaderSortComparator;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ColumnSortStateChangedListener;
import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.RowHeaderForCellSortComparator;
import com.evrencoskun.tableview.sort.RowHeaderSortComparator;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Pagination
implements IPagination {
    private static final int DEFAULT_ITEMS_PER_PAGE = 10;
    private int itemsPerPage;
    private int currentPage;
    private int pageCount;
    @NonNull
    private List<List<ISortableModel>> originalCellData;
    @NonNull
    private List<ISortableModel> originalRowData;
    @Nullable
    private RowHeaderRecyclerViewAdapter<ISortableModel> mRowHeaderRecyclerViewAdapter;
    @Nullable
    private CellRecyclerViewAdapter<List<ISortableModel>> mCellRecyclerViewAdapter;
    @Nullable
    private OnTableViewPageTurnedListener onTableViewPageTurnedListener;
    @NonNull
    private final AdapterDataSetChangedListener adapterDataSetChangedListener = new AdapterDataSetChangedListener(){

        public void onRowHeaderItemsChanged(@NonNull List rowHeaderItems) {
            Pagination.this.originalRowData = new ArrayList(rowHeaderItems);
            Pagination.this.reloadPages();
        }

        public void onCellItemsChanged(@NonNull List cellItems) {
            Pagination.this.originalCellData = new ArrayList(cellItems);
            Pagination.this.reloadPages();
        }
    };
    @NonNull
    private final FilterChangedListener<ISortableModel> filterChangedListener = new FilterChangedListener<ISortableModel>(){

        @Override
        public void onFilterChanged(@NonNull List<List<ISortableModel>> filteredCellItems, @NonNull List<ISortableModel> filteredRowHeaderItems) {
            Pagination.this.originalCellData = new ArrayList<List<ISortableModel>>(filteredCellItems);
            Pagination.this.originalRowData = new ArrayList<ISortableModel>(filteredRowHeaderItems);
            Pagination.this.reloadPages();
        }

        @Override
        public void onFilterCleared(@NonNull List<List<ISortableModel>> originalCellItems, @NonNull List<ISortableModel> originalRowHeaderItems) {
            Pagination.this.originalCellData = new ArrayList<List<ISortableModel>>(originalCellItems);
            Pagination.this.originalRowData = new ArrayList<ISortableModel>(originalRowHeaderItems);
            Pagination.this.reloadPages();
        }
    };
    @NonNull
    private final ColumnSortStateChangedListener columnSortStateChangedListener = new ColumnSortStateChangedListener(){

        @Override
        public void onColumnSortStatusChanged(int column, @NonNull SortState sortState) {
            Pagination.this.paginateOnColumnSort(column, sortState);
        }

        @Override
        public void onRowHeaderSortStatusChanged(@NonNull SortState sortState) {
            Pagination.this.paginateOnColumnSort(-1, sortState);
        }
    };

    public Pagination(@NonNull ITableView tableView) {
        this(tableView, 10, null);
    }

    public Pagination(@NonNull ITableView tableView, int itemsPerPage) {
        this(tableView, itemsPerPage, null);
    }

    public Pagination(@NonNull ITableView tableView, int itemsPerPage, @Nullable OnTableViewPageTurnedListener listener) {
        this.initialize(tableView, itemsPerPage, listener);
    }

    private void initialize(@NonNull ITableView tableView, int itemsPerPage, @Nullable OnTableViewPageTurnedListener listener) {
        this.onTableViewPageTurnedListener = listener;
        this.itemsPerPage = itemsPerPage;
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)tableView.getRowHeaderRecyclerView().getAdapter();
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)tableView.getCellRecyclerView().getAdapter();
        tableView.getColumnSortHandler().addColumnSortStateChangedListener(this.columnSortStateChangedListener);
        tableView.getAdapter().addAdapterDataSetChangedListener(this.adapterDataSetChangedListener);
        tableView.getFilterHandler().addFilterChangedListener(this.filterChangedListener);
        this.originalCellData = tableView.getAdapter().getCellRecyclerViewAdapter().getItems();
        this.originalRowData = tableView.getAdapter().getRowHeaderRecyclerViewAdapter().getItems();
        this.currentPage = 1;
        this.reloadPages();
    }

    private void reloadPages() {
        this.paginateData();
        this.goToPage(this.currentPage);
    }

    private void paginateData() {
        int end;
        int start;
        ArrayList<List<ISortableModel>> currentPageCellData = new ArrayList<List<ISortableModel>>();
        ArrayList<ISortableModel> currentPageRowData = new ArrayList<ISortableModel>();
        if (this.itemsPerPage == 0) {
            currentPageCellData.addAll(this.originalCellData);
            currentPageRowData.addAll(this.originalRowData);
            this.pageCount = 1;
            start = 0;
            end = currentPageCellData.size();
        } else {
            start = this.currentPage * this.itemsPerPage - this.itemsPerPage;
            end = this.currentPage * this.itemsPerPage > this.originalCellData.size() ? this.originalCellData.size() : this.currentPage * this.itemsPerPage;
            for (int x = start; x < end; ++x) {
                currentPageCellData.add(this.originalCellData.get(x));
                currentPageRowData.add(this.originalRowData.get(x));
            }
            this.pageCount = (int)Math.ceil((double)this.originalCellData.size() / (double)this.itemsPerPage);
        }
        this.mRowHeaderRecyclerViewAdapter.setItems(currentPageRowData, true);
        this.mCellRecyclerViewAdapter.setItems(currentPageCellData, true);
        if (this.onTableViewPageTurnedListener != null) {
            this.onTableViewPageTurnedListener.onPageTurned(currentPageCellData.size(), start, end - 1);
        }
    }

    @Override
    public void nextPage() {
        this.currentPage = this.currentPage + 1 > this.pageCount ? this.currentPage : (this.currentPage = this.currentPage + 1);
        this.paginateData();
    }

    @Override
    public void previousPage() {
        this.currentPage = this.currentPage - 1 == 0 ? this.currentPage : (this.currentPage = this.currentPage - 1);
        this.paginateData();
    }

    @Override
    public void goToPage(int page) {
        this.currentPage = page > this.pageCount || page < 1 ? (page > this.pageCount && this.pageCount > 0 ? this.pageCount : this.currentPage) : page;
        this.paginateData();
    }

    @Override
    public void setItemsPerPage(int numItems) {
        this.itemsPerPage = numItems;
        this.currentPage = 1;
        this.paginateData();
    }

    @Override
    public void setOnTableViewPageTurnedListener(@Nullable OnTableViewPageTurnedListener onTableViewPageTurnedListener) {
        this.onTableViewPageTurnedListener = onTableViewPageTurnedListener;
    }

    @Override
    public void removeOnTableViewPageTurnedListener() {
        this.onTableViewPageTurnedListener = null;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public boolean isPaginated() {
        return this.itemsPerPage > 0;
    }

    private void paginateOnColumnSort(int column, @NonNull SortState sortState) {
        ArrayList<ISortableModel> sortedRowHeaderList = new ArrayList<ISortableModel>(this.originalRowData);
        ArrayList<List<ISortableModel>> sortedList = new ArrayList<List<ISortableModel>>(this.originalCellData);
        if (sortState != SortState.UNSORTED) {
            if (column == -1) {
                Collections.sort(sortedRowHeaderList, new RowHeaderSortComparator(sortState));
                RowHeaderForCellSortComparator rowHeaderForCellSortComparator = new RowHeaderForCellSortComparator(this.originalRowData, this.originalCellData, sortState);
                Collections.sort(sortedList, rowHeaderForCellSortComparator);
            } else {
                Collections.sort(sortedList, new ColumnSortComparator(column, sortState));
                ColumnForRowHeaderSortComparator columnForRowHeaderSortComparator = new ColumnForRowHeaderSortComparator(this.originalRowData, this.originalCellData, column, sortState);
                Collections.sort(sortedRowHeaderList, columnForRowHeaderSortComparator);
            }
        }
        this.originalRowData = new ArrayList<ISortableModel>(sortedRowHeaderList);
        this.originalCellData = new ArrayList<List<ISortableModel>>(sortedList);
        this.reloadPages();
    }

    public static interface OnTableViewPageTurnedListener {
        public void onPageTurned(int var1, int var2, int var3);
    }
}

