/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.util.TableViewUtils;

public class ColumnHeaderLayoutManager
extends LinearLayoutManager {
    @NonNull
    private final SparseIntArray mCachedWidthList = new SparseIntArray();
    @NonNull
    private final ITableView mTableView;

    public ColumnHeaderLayoutManager(@NonNull Context context, @NonNull ITableView tableView) {
        super(context);
        this.mTableView = tableView;
        this.setOrientation(0);
    }

    public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.mTableView.hasFixedWidth()) {
            return;
        }
        this.measureChild(child, widthUsed, heightUsed);
    }

    public void measureChild(@NonNull View child, int widthUsed, int heightUsed) {
        if (this.mTableView.hasFixedWidth()) {
            super.measureChild(child, widthUsed, heightUsed);
            return;
        }
        int position = this.getPosition(child);
        int cacheWidth = this.getCacheWidth(position);
        if (cacheWidth != -1) {
            TableViewUtils.setWidth(child, cacheWidth);
        } else {
            super.measureChild(child, widthUsed, heightUsed);
        }
    }

    public void setCacheWidth(int position, int width) {
        this.mCachedWidthList.put(position, width);
    }

    public int getCacheWidth(int position) {
        return this.mCachedWidthList.get(position, -1);
    }

    public int getFirstItemLeft() {
        View firstColumnHeader = this.findViewByPosition(this.findFirstVisibleItemPosition());
        return firstColumnHeader.getLeft();
    }

    public void removeCachedWidth(int position) {
        this.mCachedWidthList.removeAt(position);
    }

    public void clearCachedWidths() {
        this.mCachedWidthList.clear();
    }

    public void customRequestLayout() {
        int left = this.getFirstItemLeft();
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            int right = left + this.getCacheWidth(i);
            View columnHeader = this.findViewByPosition(i);
            columnHeader.setLeft(left);
            columnHeader.setRight(right);
            this.layoutDecoratedWithMargins(columnHeader, columnHeader.getLeft(), columnHeader.getTop(), columnHeader.getRight(), columnHeader.getBottom());
            left = right + 1;
        }
    }

    @NonNull
    public AbstractViewHolder[] getVisibleViewHolders() {
        int visibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int index = 0;
        AbstractViewHolder[] views = new AbstractViewHolder[visibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            views[index] = (AbstractViewHolder)this.mTableView.getColumnHeaderRecyclerView().findViewHolderForAdapterPosition(i);
            ++index;
        }
        return views;
    }

    @Nullable
    public AbstractViewHolder getViewHolder(int xPosition) {
        return (AbstractViewHolder)this.mTableView.getColumnHeaderRecyclerView().findViewHolderForAdapterPosition(xPosition);
    }
}

