/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.util.TableViewUtils;

public class CellLayoutManager
extends LinearLayoutManager {
    private static final String LOG_TAG = CellLayoutManager.class.getSimpleName();
    private static final int IGNORE_LEFT = -99999;
    @NonNull
    private final ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    @NonNull
    private final CellRecyclerView mRowHeaderRecyclerView;
    private HorizontalRecyclerViewListener mHorizontalListener;
    @NonNull
    private final ITableView mTableView;
    @NonNull
    private final SparseArray<SparseIntArray> mCachedWidthList = new SparseArray();
    private int mLastDy = 0;
    private boolean mNeedSetLeft;
    private boolean mNeedFit;

    public CellLayoutManager(@NonNull Context context, @NonNull ITableView tableView) {
        super(context);
        this.mTableView = tableView;
        this.mColumnHeaderLayoutManager = tableView.getColumnHeaderLayoutManager();
        this.mRowHeaderRecyclerView = tableView.getRowHeaderRecyclerView();
        this.initialize();
    }

    private void initialize() {
        this.setOrientation(1);
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        if (this.mHorizontalListener == null) {
            this.mHorizontalListener = this.mTableView.getHorizontalRecyclerViewListener();
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mRowHeaderRecyclerView.getScrollState() == 0 && !this.mRowHeaderRecyclerView.isScrollOthers()) {
            this.mRowHeaderRecyclerView.scrollBy(0, dy);
        }
        int scroll = super.scrollVerticallyBy(dy, recycler, state);
        this.mLastDy = dy;
        return scroll;
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0) {
            this.mLastDy = 0;
        }
    }

    public void fitWidthSize(boolean scrollingUp) {
        int left = this.mColumnHeaderLayoutManager.getFirstItemLeft();
        for (int i = this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition(); i < this.mColumnHeaderLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            left = this.fitSize(i, left, scrollingUp);
        }
        this.mNeedSetLeft = false;
    }

    public void fitWidthSize(int position, boolean scrollingLeft) {
        this.fitSize(position, -99999, false);
        if (this.mNeedSetLeft & scrollingLeft) {
            Handler handler = new Handler();
            handler.post(() -> this.fitWidthSize2(true));
        }
    }

    private int fitSize(int position, int left, boolean scrollingUp) {
        int cellRight = -1;
        int columnCacheWidth = this.mColumnHeaderLayoutManager.getCacheWidth(position);
        View column = this.mColumnHeaderLayoutManager.findViewByPosition(position);
        if (column != null) {
            cellRight = column.getLeft() + columnCacheWidth + 1;
            if (scrollingUp) {
                for (int i = this.findLastVisibleItemPosition(); i >= this.findFirstVisibleItemPosition(); --i) {
                    cellRight = this.fit(position, i, left, cellRight, columnCacheWidth);
                }
            } else {
                for (int j = this.findFirstVisibleItemPosition(); j < this.findLastVisibleItemPosition() + 1; ++j) {
                    cellRight = this.fit(position, j, left, cellRight, columnCacheWidth);
                }
            }
        } else {
            Log.e((String)LOG_TAG, (String)("Warning: column couldn't found for " + position));
        }
        return cellRight;
    }

    private int fit(int xPosition, int yPosition, int left, int right, int columnCachedWidth) {
        CellRecyclerView child = (CellRecyclerView)this.findViewByPosition(yPosition);
        if (child != null) {
            ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)child.getLayoutManager();
            int cellCacheWidth = this.getCacheWidth(yPosition, xPosition);
            View cell = childLayoutManager.findViewByPosition(xPosition);
            if (cell != null && (cellCacheWidth != columnCachedWidth || this.mNeedSetLeft)) {
                if (cellCacheWidth != columnCachedWidth) {
                    cellCacheWidth = columnCachedWidth;
                    TableViewUtils.setWidth(cell, cellCacheWidth);
                    this.setCacheWidth(yPosition, xPosition, cellCacheWidth);
                }
                if (left != -99999 && cell.getLeft() != left) {
                    int scrollX = Math.max(cell.getLeft(), left) - Math.min(cell.getLeft(), left);
                    cell.setLeft(left);
                    int offset = this.mHorizontalListener.getScrollPositionOffset();
                    if (offset > 0 && xPosition == childLayoutManager.findFirstVisibleItemPosition() && this.getCellRecyclerViewScrollState() != 0) {
                        int scrollPosition = this.mHorizontalListener.getScrollPosition();
                        offset = this.mHorizontalListener.getScrollPositionOffset() + scrollX;
                        this.mHorizontalListener.setScrollPositionOffset(offset);
                        childLayoutManager.scrollToPositionWithOffset(scrollPosition, offset);
                    }
                }
                if (cell.getWidth() != cellCacheWidth) {
                    if (left != -99999) {
                        right = cell.getLeft() + cellCacheWidth + 1;
                        cell.setRight(right);
                        childLayoutManager.layoutDecoratedWithMargins(cell, cell.getLeft(), cell.getTop(), cell.getRight(), cell.getBottom());
                    }
                    this.mNeedSetLeft = true;
                }
            }
        }
        return right;
    }

    public void fitWidthSize2(boolean scrollingLeft) {
        this.mColumnHeaderLayoutManager.customRequestLayout();
        int columnHeaderScrollPosition = this.mTableView.getColumnHeaderRecyclerView().getScrolledX();
        int columnHeaderOffset = this.mColumnHeaderLayoutManager.getFirstItemLeft();
        int columnHeaderFirstItem = this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition();
        for (int i = this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition(); i < this.mColumnHeaderLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            this.fitSize2(i, scrollingLeft, columnHeaderScrollPosition, columnHeaderOffset, columnHeaderFirstItem);
        }
        this.mNeedSetLeft = false;
    }

    public void fitWidthSize2(int position, boolean scrollingLeft) {
        this.mColumnHeaderLayoutManager.customRequestLayout();
        int columnHeaderScrollPosition = this.mTableView.getColumnHeaderRecyclerView().getScrolledX();
        int columnHeaderOffset = this.mColumnHeaderLayoutManager.getFirstItemLeft();
        int columnHeaderFirstItem = this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition();
        this.fitSize2(position, scrollingLeft, columnHeaderScrollPosition, columnHeaderOffset, columnHeaderFirstItem);
        this.mNeedSetLeft = false;
    }

    private void fitSize2(int position, boolean scrollingLeft, int columnHeaderScrollPosition, int columnHeaderOffset, int columnHeaderFirstItem) {
        int columnCacheWidth = this.mColumnHeaderLayoutManager.getCacheWidth(position);
        View column = this.mColumnHeaderLayoutManager.findViewByPosition(position);
        if (column != null) {
            for (int j = this.findFirstVisibleItemPosition(); j < this.findLastVisibleItemPosition() + 1; ++j) {
                CellRecyclerView child = (CellRecyclerView)this.findViewByPosition(j);
                if (child == null) continue;
                ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)child.getLayoutManager();
                if (!scrollingLeft && columnHeaderScrollPosition != child.getScrolledX()) {
                    childLayoutManager.scrollToPositionWithOffset(columnHeaderFirstItem, columnHeaderOffset);
                }
                if (childLayoutManager == null) continue;
                this.fit2(position, j, columnCacheWidth, column, childLayoutManager);
            }
        }
    }

    private void fit2(int xPosition, int yPosition, int columnCachedWidth, @NonNull View column, @NonNull ColumnLayoutManager childLayoutManager) {
        int cellCacheWidth = this.getCacheWidth(yPosition, xPosition);
        View cell = childLayoutManager.findViewByPosition(xPosition);
        if (cell != null && (cellCacheWidth != columnCachedWidth || this.mNeedSetLeft)) {
            if (cellCacheWidth != columnCachedWidth) {
                cellCacheWidth = columnCachedWidth;
                TableViewUtils.setWidth(cell, cellCacheWidth);
                this.setCacheWidth(yPosition, xPosition, cellCacheWidth);
            }
            if (column.getLeft() != cell.getLeft() || column.getRight() != cell.getRight()) {
                cell.setLeft(column.getLeft());
                cell.setRight(column.getRight() + 1);
                childLayoutManager.layoutDecoratedWithMargins(cell, cell.getLeft(), cell.getTop(), cell.getRight(), cell.getBottom());
                this.mNeedSetLeft = true;
            }
        }
    }

    public boolean shouldFitColumns(int yPosition) {
        int lastVisiblePosition;
        CellRecyclerView lastCellRecyclerView;
        if (this.getCellRecyclerViewScrollState() == 0 && (lastCellRecyclerView = (CellRecyclerView)this.findViewByPosition(lastVisiblePosition = this.findLastVisibleItemPosition())) != null) {
            if (yPosition == lastVisiblePosition) {
                return true;
            }
            if (lastCellRecyclerView.isScrollOthers() && yPosition == lastVisiblePosition - 1) {
                return true;
            }
        }
        return false;
    }

    public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.mTableView.hasFixedWidth()) {
            return;
        }
        int position = this.getPosition(child);
        ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)((CellRecyclerView)child).getLayoutManager();
        if (this.getCellRecyclerViewScrollState() != 0) {
            if (childLayoutManager.isNeedFit()) {
                if (this.mLastDy < 0) {
                    Log.e((String)LOG_TAG, (String)(position + " fitWidthSize all vertically up"));
                    this.fitWidthSize(true);
                } else {
                    Log.e((String)LOG_TAG, (String)(position + " fitWidthSize all vertically down"));
                    this.fitWidthSize(false);
                }
                childLayoutManager.clearNeedFit();
            }
            childLayoutManager.setInitialPrefetchItemCount(childLayoutManager.getChildCount());
        } else if (childLayoutManager.getLastDx() == 0 && this.getCellRecyclerViewScrollState() == 0) {
            if (childLayoutManager.isNeedFit()) {
                this.mNeedFit = true;
                childLayoutManager.clearNeedFit();
            }
            if (this.mNeedFit && this.mTableView.getRowHeaderLayoutManager().findLastVisibleItemPosition() == position) {
                this.fitWidthSize2(false);
                Log.e((String)LOG_TAG, (String)(position + " fitWidthSize populating data for the first time"));
                this.mNeedFit = false;
            }
        }
    }

    @NonNull
    public AbstractViewHolder[] getVisibleCellViewsByColumnPosition(int xPosition) {
        int visibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int index = 0;
        AbstractViewHolder[] viewHolders = new AbstractViewHolder[visibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            AbstractViewHolder holder;
            CellRecyclerView cellRowRecyclerView = (CellRecyclerView)this.findViewByPosition(i);
            viewHolders[index] = holder = (AbstractViewHolder)cellRowRecyclerView.findViewHolderForAdapterPosition(xPosition);
            ++index;
        }
        return viewHolders;
    }

    @Nullable
    public AbstractViewHolder getCellViewHolder(int xPosition, int yPosition) {
        CellRecyclerView cellRowRecyclerView = (CellRecyclerView)this.findViewByPosition(yPosition);
        if (cellRowRecyclerView != null) {
            return (AbstractViewHolder)cellRowRecyclerView.findViewHolderForAdapterPosition(xPosition);
        }
        return null;
    }

    public void remeasureAllChild() {
        for (int j = 0; j < this.getChildCount(); ++j) {
            CellRecyclerView recyclerView = (CellRecyclerView)this.getChildAt(j);
            recyclerView.getLayoutParams().width = -2;
            recyclerView.requestLayout();
        }
    }

    public void setCacheWidth(int row, int column, int width) {
        SparseIntArray cellRowCache = (SparseIntArray)this.mCachedWidthList.get(row);
        if (cellRowCache == null) {
            cellRowCache = new SparseIntArray();
        }
        cellRowCache.put(column, width);
        this.mCachedWidthList.put(row, (Object)cellRowCache);
    }

    public void setCacheWidth(int column, int width) {
        for (int i = 0; i < this.mRowHeaderRecyclerView.getAdapter().getItemCount(); ++i) {
            this.setCacheWidth(i, column, width);
        }
    }

    public int getCacheWidth(int row, int column) {
        SparseIntArray cellRowCaches = (SparseIntArray)this.mCachedWidthList.get(row);
        if (cellRowCaches != null) {
            return cellRowCaches.get(column, -1);
        }
        return -1;
    }

    public void clearCachedWidths() {
        this.mCachedWidthList.clear();
    }

    @NonNull
    public CellRecyclerView[] getVisibleCellRowRecyclerViews() {
        int length = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        CellRecyclerView[] recyclerViews = new CellRecyclerView[length];
        int index = 0;
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            recyclerViews[index] = (CellRecyclerView)this.findViewByPosition(i);
            ++index;
        }
        return recyclerViews;
    }

    private int getCellRecyclerViewScrollState() {
        return this.mTableView.getCellRecyclerView().getScrollState();
    }
}

