/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.AdapterDataSetChangedListener;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.ColumnHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTableAdapter<CH, RH, C>
implements ITableAdapter<CH, RH, C> {
    private int mRowHeaderWidth;
    private int mColumnHeaderHeight;
    private ColumnHeaderRecyclerViewAdapter<CH> mColumnHeaderRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter<RH> mRowHeaderRecyclerViewAdapter;
    private CellRecyclerViewAdapter mCellRecyclerViewAdapter;
    private View mCornerView;
    protected List<CH> mColumnHeaderItems;
    protected List<RH> mRowHeaderItems;
    protected List<List<C>> mCellItems;
    private ITableView mTableView;
    private List<AdapterDataSetChangedListener<CH, RH, C>> dataSetChangedListeners;

    public void setTableView(@NonNull ITableView tableView) {
        this.mTableView = tableView;
        this.initialize();
    }

    private void initialize() {
        Context context = this.mTableView.getContext();
        this.mColumnHeaderRecyclerViewAdapter = new ColumnHeaderRecyclerViewAdapter<CH>(context, this.mColumnHeaderItems, this);
        this.mRowHeaderRecyclerViewAdapter = new RowHeaderRecyclerViewAdapter<RH>(context, this.mRowHeaderItems, this);
        this.mCellRecyclerViewAdapter = new CellRecyclerViewAdapter<List<C>>(context, this.mCellItems, this.mTableView);
    }

    public void setColumnHeaderItems(@Nullable List<CH> columnHeaderItems) {
        if (columnHeaderItems == null) {
            return;
        }
        this.mColumnHeaderItems = columnHeaderItems;
        this.mTableView.getColumnHeaderLayoutManager().clearCachedWidths();
        this.mColumnHeaderRecyclerViewAdapter.setItems(this.mColumnHeaderItems);
        this.dispatchColumnHeaderDataSetChangesToListeners(columnHeaderItems);
    }

    public void setRowHeaderItems(@Nullable List<RH> rowHeaderItems) {
        if (rowHeaderItems == null) {
            return;
        }
        this.mRowHeaderItems = rowHeaderItems;
        this.mRowHeaderRecyclerViewAdapter.setItems(this.mRowHeaderItems);
        this.dispatchRowHeaderDataSetChangesToListeners(this.mRowHeaderItems);
    }

    public void setCellItems(@Nullable List<List<C>> cellItems) {
        if (cellItems == null) {
            return;
        }
        this.mCellItems = cellItems;
        this.mTableView.getCellLayoutManager().clearCachedWidths();
        this.mCellRecyclerViewAdapter.setItems(this.mCellItems);
        this.dispatchCellDataSetChangesToListeners(this.mCellItems);
    }

    public void setAllItems(@Nullable List<CH> columnHeaderItems, @Nullable List<RH> rowHeaderItems, @Nullable List<List<C>> cellItems) {
        this.setColumnHeaderItems(columnHeaderItems);
        this.setRowHeaderItems(rowHeaderItems);
        this.setCellItems(cellItems);
        if (!(columnHeaderItems == null || columnHeaderItems.isEmpty() || rowHeaderItems == null || rowHeaderItems.isEmpty() || cellItems == null || cellItems.isEmpty() || this.mTableView == null || this.mCornerView != null)) {
            this.mCornerView = this.onCreateCornerView((ViewGroup)this.mTableView);
            this.mTableView.addView(this.mCornerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mRowHeaderWidth, this.mColumnHeaderHeight));
        } else if (this.mCornerView != null) {
            if (rowHeaderItems != null && !rowHeaderItems.isEmpty()) {
                this.mCornerView.setVisibility(0);
            } else {
                this.mCornerView.setVisibility(8);
            }
        }
    }

    @Override
    @Nullable
    public View getCornerView() {
        return this.mCornerView;
    }

    public ColumnHeaderRecyclerViewAdapter getColumnHeaderRecyclerViewAdapter() {
        return this.mColumnHeaderRecyclerViewAdapter;
    }

    public RowHeaderRecyclerViewAdapter getRowHeaderRecyclerViewAdapter() {
        return this.mRowHeaderRecyclerViewAdapter;
    }

    public CellRecyclerViewAdapter getCellRecyclerViewAdapter() {
        return this.mCellRecyclerViewAdapter;
    }

    public void setRowHeaderWidth(int rowHeaderWidth) {
        this.mRowHeaderWidth = rowHeaderWidth;
        if (this.mCornerView != null) {
            ViewGroup.LayoutParams layoutParams = this.mCornerView.getLayoutParams();
            layoutParams.width = rowHeaderWidth;
        }
    }

    public void setColumnHeaderHeight(int columnHeaderHeight) {
        this.mColumnHeaderHeight = columnHeaderHeight;
    }

    @Nullable
    public CH getColumnHeaderItem(int position) {
        if (this.mColumnHeaderItems == null || this.mColumnHeaderItems.isEmpty() || position < 0 || position >= this.mColumnHeaderItems.size()) {
            return null;
        }
        return this.mColumnHeaderItems.get(position);
    }

    @Nullable
    public RH getRowHeaderItem(int position) {
        if (this.mRowHeaderItems == null || this.mRowHeaderItems.isEmpty() || position < 0 || position >= this.mRowHeaderItems.size()) {
            return null;
        }
        return this.mRowHeaderItems.get(position);
    }

    @Nullable
    public C getCellItem(int columnPosition, int rowPosition) {
        if (this.mCellItems == null || this.mCellItems.isEmpty() || columnPosition < 0 || rowPosition >= this.mCellItems.size() || this.mCellItems.get(rowPosition) == null || rowPosition < 0 || columnPosition >= this.mCellItems.get(rowPosition).size()) {
            return null;
        }
        return this.mCellItems.get(rowPosition).get(columnPosition);
    }

    @Nullable
    public List<C> getCellRowItems(int rowPosition) {
        return (List)this.mCellRecyclerViewAdapter.getItem(rowPosition);
    }

    public void removeRow(int rowPosition) {
        this.mCellRecyclerViewAdapter.deleteItem(rowPosition);
        this.mRowHeaderRecyclerViewAdapter.deleteItem(rowPosition);
    }

    public void removeRow(int rowPosition, boolean updateRowHeader) {
        this.mCellRecyclerViewAdapter.deleteItem(rowPosition);
        if (updateRowHeader) {
            rowPosition = this.mRowHeaderRecyclerViewAdapter.getItemCount() - 1;
            this.mCellRecyclerViewAdapter.notifyDataSetChanged();
        }
        this.mRowHeaderRecyclerViewAdapter.deleteItem(rowPosition);
    }

    public void removeRowRange(int rowPositionStart, int itemCount) {
        this.mCellRecyclerViewAdapter.deleteItemRange(rowPositionStart, itemCount);
        this.mRowHeaderRecyclerViewAdapter.deleteItemRange(rowPositionStart, itemCount);
    }

    public void removeRowRange(int rowPositionStart, int itemCount, boolean updateRowHeader) {
        this.mCellRecyclerViewAdapter.deleteItemRange(rowPositionStart, itemCount);
        if (updateRowHeader) {
            rowPositionStart = this.mRowHeaderRecyclerViewAdapter.getItemCount() - 1 - itemCount;
            this.mCellRecyclerViewAdapter.notifyDataSetChanged();
        }
        this.mRowHeaderRecyclerViewAdapter.deleteItemRange(rowPositionStart, itemCount);
    }

    public void addRow(int rowPosition, @Nullable RH rowHeaderItem, @Nullable List<C> cellItems) {
        this.mCellRecyclerViewAdapter.addItem(rowPosition, cellItems);
        this.mRowHeaderRecyclerViewAdapter.addItem(rowPosition, rowHeaderItem);
    }

    public void addRowRange(int rowPositionStart, @Nullable List<RH> rowHeaderItem, @Nullable List<List<C>> cellItems) {
        this.mRowHeaderRecyclerViewAdapter.addItemRange(rowPositionStart, rowHeaderItem);
        this.mCellRecyclerViewAdapter.addItemRange(rowPositionStart, cellItems);
    }

    public void changeRowHeaderItem(int rowPosition, @Nullable RH rowHeaderModel) {
        this.mRowHeaderRecyclerViewAdapter.changeItem(rowPosition, rowHeaderModel);
    }

    public void changeRowHeaderItemRange(int rowPositionStart, @Nullable List<RH> rowHeaderModelList) {
        this.mRowHeaderRecyclerViewAdapter.changeItemRange(rowPositionStart, rowHeaderModelList);
    }

    public void changeCellItem(int columnPosition, int rowPosition, C cellModel) {
        List cellItems = (List)this.mCellRecyclerViewAdapter.getItem(rowPosition);
        if (cellItems != null && cellItems.size() > columnPosition) {
            cellItems.set(columnPosition, cellModel);
            this.mCellRecyclerViewAdapter.changeItem(rowPosition, cellItems);
        }
    }

    public void changeColumnHeader(int columnPosition, @Nullable CH columnHeaderModel) {
        this.mColumnHeaderRecyclerViewAdapter.changeItem(columnPosition, columnHeaderModel);
    }

    public void changeColumnHeaderRange(int columnPositionStart, @Nullable List<CH> columnHeaderModelList) {
        this.mColumnHeaderRecyclerViewAdapter.changeItemRange(columnPositionStart, columnHeaderModelList);
    }

    @NonNull
    public List<C> getCellColumnItems(int columnPosition) {
        return this.mCellRecyclerViewAdapter.getColumnItems(columnPosition);
    }

    public void removeColumn(int columnPosition) {
        this.mColumnHeaderRecyclerViewAdapter.deleteItem(columnPosition);
        this.mCellRecyclerViewAdapter.removeColumnItems(columnPosition);
    }

    public void addColumn(int columnPosition, @Nullable CH columnHeaderItem, @NonNull List<C> cellItems) {
        this.mColumnHeaderRecyclerViewAdapter.addItem(columnPosition, columnHeaderItem);
        this.mCellRecyclerViewAdapter.addColumnItems(columnPosition, cellItems);
    }

    public final void notifyDataSetChanged() {
        this.mColumnHeaderRecyclerViewAdapter.notifyDataSetChanged();
        this.mRowHeaderRecyclerViewAdapter.notifyDataSetChanged();
        this.mCellRecyclerViewAdapter.notifyCellDataSetChanged();
    }

    @Override
    public ITableView getTableView() {
        return this.mTableView;
    }

    private void dispatchColumnHeaderDataSetChangesToListeners(@NonNull List<CH> newColumnHeaderItems) {
        if (this.dataSetChangedListeners != null) {
            for (AdapterDataSetChangedListener<CH, RH, C> listener : this.dataSetChangedListeners) {
                listener.onColumnHeaderItemsChanged(newColumnHeaderItems);
            }
        }
    }

    private void dispatchRowHeaderDataSetChangesToListeners(@NonNull List<RH> newRowHeaderItems) {
        if (this.dataSetChangedListeners != null) {
            for (AdapterDataSetChangedListener<CH, RH, C> listener : this.dataSetChangedListeners) {
                listener.onRowHeaderItemsChanged(newRowHeaderItems);
            }
        }
    }

    private void dispatchCellDataSetChangesToListeners(@NonNull List<List<C>> newCellItems) {
        if (this.dataSetChangedListeners != null) {
            for (AdapterDataSetChangedListener<CH, RH, C> listener : this.dataSetChangedListeners) {
                listener.onCellItemsChanged(newCellItems);
            }
        }
    }

    @Override
    public void addAdapterDataSetChangedListener(@NonNull AdapterDataSetChangedListener<CH, RH, C> listener) {
        if (this.dataSetChangedListeners == null) {
            this.dataSetChangedListeners = new ArrayList<AdapterDataSetChangedListener<CH, RH, C>>();
        }
        this.dataSetChangedListeners.add(listener);
    }
}

