/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.evrencoskun.tableview.adapter.AbstractTableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.filter.Filter;
import com.evrencoskun.tableview.handler.ColumnSortHandler;
import com.evrencoskun.tableview.handler.FilterHandler;
import com.evrencoskun.tableview.handler.ScrollHandler;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.handler.VisibilityHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.listener.ITableViewListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;
import com.evrencoskun.tableview.sort.SortState;

public interface ITableView {
    public void addView(View var1, ViewGroup.LayoutParams var2);

    public boolean hasFixedWidth();

    public boolean isIgnoreSelectionColors();

    public boolean isShowHorizontalSeparators();

    public boolean isShowVerticalSeparators();

    public boolean isAllowClickInsideCell();

    public boolean isSortable();

    @NonNull
    public Context getContext();

    @NonNull
    public CellRecyclerView getCellRecyclerView();

    @NonNull
    public CellRecyclerView getColumnHeaderRecyclerView();

    @NonNull
    public CellRecyclerView getRowHeaderRecyclerView();

    @NonNull
    public ColumnHeaderLayoutManager getColumnHeaderLayoutManager();

    @NonNull
    public CellLayoutManager getCellLayoutManager();

    @NonNull
    public LinearLayoutManager getRowHeaderLayoutManager();

    @NonNull
    public HorizontalRecyclerViewListener getHorizontalRecyclerViewListener();

    @NonNull
    public VerticalRecyclerViewListener getVerticalRecyclerViewListener();

    @Nullable
    public ITableViewListener getTableViewListener();

    @NonNull
    public SelectionHandler getSelectionHandler();

    @Nullable
    public ColumnSortHandler getColumnSortHandler();

    @NonNull
    public VisibilityHandler getVisibilityHandler();

    @NonNull
    public DividerItemDecoration getHorizontalItemDecoration();

    @NonNull
    public DividerItemDecoration getVerticalItemDecoration();

    @NonNull
    public SortState getSortingStatus(int var1);

    @Nullable
    public SortState getRowHeaderSortingStatus();

    public void scrollToColumnPosition(int var1);

    public void scrollToColumnPosition(int var1, int var2);

    public void scrollToRowPosition(int var1);

    public void scrollToRowPosition(int var1, int var2);

    public void showRow(int var1);

    public void hideRow(int var1);

    public boolean isRowVisible(int var1);

    public void showAllHiddenRows();

    public void clearHiddenRowList();

    public void showColumn(int var1);

    public void hideColumn(int var1);

    public boolean isColumnVisible(int var1);

    public void showAllHiddenColumns();

    public void clearHiddenColumnList();

    public int getShadowColor();

    public int getSelectedColor();

    public int getUnSelectedColor();

    public int getSeparatorColor();

    public void sortColumn(int var1, @NonNull SortState var2);

    public void sortRowHeader(@NonNull SortState var1);

    public void remeasureColumnWidth(int var1);

    public int getRowHeaderWidth();

    public void setRowHeaderWidth(int var1);

    @Nullable
    public AbstractTableAdapter getAdapter();

    public void filter(@NonNull Filter var1);

    @Nullable
    public FilterHandler getFilterHandler();

    @NonNull
    public ScrollHandler getScrollHandler();
}

