/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.ColumnSortHelper;
import com.evrencoskun.tableview.sort.SortState;
import java.util.List;

public class ColumnHeaderRecyclerViewAdapter<CH>
extends AbstractRecyclerViewAdapter<CH> {
    private static final String LOG_TAG = ColumnHeaderRecyclerViewAdapter.class.getSimpleName();
    private ITableAdapter mTableAdapter;
    private ITableView mTableView;
    private ColumnSortHelper mColumnSortHelper;

    public ColumnHeaderRecyclerViewAdapter(Context context, List<CH> itemList, ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
        this.mTableView = tableAdapter.getTableView();
    }

    public AbstractViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateColumnHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(AbstractViewHolder holder, int position) {
        this.mTableAdapter.onBindColumnHeaderViewHolder(holder, this.getItem(position), position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getColumnHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(AbstractViewHolder viewHolder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)viewHolder);
        AbstractViewHolder.SelectionState selectionState = this.mTableView.getSelectionHandler().getColumnSelectionState(viewHolder.getAdapterPosition());
        if (!this.mTableView.isIgnoreSelectionColors()) {
            this.mTableView.getSelectionHandler().changeColumnBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
        if (this.mTableView.isSortable() && viewHolder instanceof AbstractSorterViewHolder) {
            SortState state = this.getColumnSortHelper().getSortingStatus(viewHolder.getAdapterPosition());
            ((AbstractSorterViewHolder)viewHolder).onSortingStatusChanged(state);
        }
    }

    public ColumnSortHelper getColumnSortHelper() {
        if (this.mColumnSortHelper == null) {
            this.mColumnSortHelper = new ColumnSortHelper(this.mTableView.getColumnHeaderLayoutManager());
        }
        return this.mColumnSortHelper;
    }
}

