/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;

public class SelectionHandler {
    public static final int UNSELECTED_POSITION = -1;
    private int mSelectedRowPosition = -1;
    private int mSelectedColumnPosition = -1;
    private boolean shadowEnabled = true;
    private ITableView mTableView;
    private AbstractViewHolder mPreviousSelectedViewHolder;
    private CellRecyclerView mColumnHeaderRecyclerView;
    private CellRecyclerView mRowHeaderRecyclerView;

    public SelectionHandler(ITableView tableView) {
        this.mTableView = tableView;
        this.mColumnHeaderRecyclerView = this.mTableView.getColumnHeaderRecyclerView();
        this.mRowHeaderRecyclerView = this.mTableView.getRowHeaderRecyclerView();
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.shadowEnabled = shadowEnabled;
    }

    public void setSelectedCellPositions(AbstractViewHolder selectedViewHolder, int column, int row) {
        this.setPreviousSelectedView(selectedViewHolder);
        this.mSelectedColumnPosition = column;
        this.mSelectedRowPosition = row;
        if (this.shadowEnabled) {
            this.selectedCellView();
        }
    }

    public void setSelectedColumnPosition(AbstractViewHolder selectedViewHolder, int column) {
        this.setPreviousSelectedView(selectedViewHolder);
        this.mSelectedColumnPosition = column;
        this.selectedColumnHeader();
        this.mSelectedRowPosition = -1;
    }

    public int getSelectedColumnPosition() {
        return this.mSelectedColumnPosition;
    }

    public void setSelectedRowPosition(AbstractViewHolder selectedViewHolder, int row) {
        this.setPreviousSelectedView(selectedViewHolder);
        this.mSelectedRowPosition = row;
        this.selectedRowHeader();
        this.mSelectedColumnPosition = -1;
    }

    public int getSelectedRowPosition() {
        return this.mSelectedRowPosition;
    }

    public void setPreviousSelectedView(AbstractViewHolder viewHolder) {
        AbstractViewHolder oldViewHolder;
        this.restorePreviousSelectedView();
        if (this.mPreviousSelectedViewHolder != null) {
            this.mPreviousSelectedViewHolder.setBackgroundColor(this.mTableView.getUnSelectedColor());
            this.mPreviousSelectedViewHolder.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        if ((oldViewHolder = this.mTableView.getCellLayoutManager().getCellViewHolder(this.getSelectedColumnPosition(), this.getSelectedRowPosition())) != null) {
            oldViewHolder.setBackgroundColor(this.mTableView.getUnSelectedColor());
            oldViewHolder.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        this.mPreviousSelectedViewHolder = viewHolder;
        this.mPreviousSelectedViewHolder.setBackgroundColor(this.mTableView.getSelectedColor());
        this.mPreviousSelectedViewHolder.setSelected(AbstractViewHolder.SelectionState.SELECTED);
    }

    private void restorePreviousSelectedView() {
        if (this.mSelectedColumnPosition != -1 && this.mSelectedRowPosition != -1) {
            this.unselectedCellView();
        } else if (this.mSelectedColumnPosition != -1) {
            this.unselectedColumnHeader();
        } else if (this.mSelectedRowPosition != -1) {
            this.unselectedRowHeader();
        }
    }

    private void selectedRowHeader() {
        this.changeVisibleCellViewsBackgroundForRow(this.mSelectedRowPosition, true);
        if (this.shadowEnabled) {
            this.mTableView.getColumnHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.SHADOWED, this.mTableView.getShadowColor(), false);
        }
    }

    private void unselectedRowHeader() {
        this.changeVisibleCellViewsBackgroundForRow(this.mSelectedRowPosition, false);
        this.mTableView.getColumnHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.mTableView.getUnSelectedColor(), false);
    }

    private void selectedCellView() {
        AbstractViewHolder columnHeader;
        int shadowColor = this.mTableView.getShadowColor();
        AbstractViewHolder rowHeader = (AbstractViewHolder)this.mRowHeaderRecyclerView.findViewHolderForAdapterPosition(this.mSelectedRowPosition);
        if (rowHeader != null) {
            rowHeader.setBackgroundColor(shadowColor);
            rowHeader.setSelected(AbstractViewHolder.SelectionState.SHADOWED);
        }
        if ((columnHeader = (AbstractViewHolder)this.mColumnHeaderRecyclerView.findViewHolderForAdapterPosition(this.mSelectedColumnPosition)) != null) {
            columnHeader.setBackgroundColor(shadowColor);
            columnHeader.setSelected(AbstractViewHolder.SelectionState.SHADOWED);
        }
    }

    private void unselectedCellView() {
        AbstractViewHolder columnHeader;
        int unSelectedColor = this.mTableView.getUnSelectedColor();
        AbstractViewHolder rowHeader = (AbstractViewHolder)this.mRowHeaderRecyclerView.findViewHolderForAdapterPosition(this.mSelectedRowPosition);
        if (rowHeader != null) {
            rowHeader.setBackgroundColor(unSelectedColor);
            rowHeader.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
        if ((columnHeader = (AbstractViewHolder)this.mColumnHeaderRecyclerView.findViewHolderForAdapterPosition(this.mSelectedColumnPosition)) != null) {
            columnHeader.setBackgroundColor(unSelectedColor);
            columnHeader.setSelected(AbstractViewHolder.SelectionState.UNSELECTED);
        }
    }

    private void selectedColumnHeader() {
        this.changeVisibleCellViewsBackgroundForColumn(this.mSelectedColumnPosition, true);
        this.mTableView.getRowHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.SHADOWED, this.mTableView.getShadowColor(), false);
    }

    private void unselectedColumnHeader() {
        this.changeVisibleCellViewsBackgroundForColumn(this.mSelectedColumnPosition, false);
        this.mTableView.getRowHeaderRecyclerView().setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.mTableView.getUnSelectedColor(), false);
    }

    public boolean isCellSelected(int column, int row) {
        return this.getSelectedColumnPosition() == column && this.getSelectedRowPosition() == row || this.isColumnSelected(column) || this.isRowSelected(row);
    }

    public AbstractViewHolder.SelectionState getCellSelectionState(int column, int row) {
        if (this.isCellSelected(column, row)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    public boolean isColumnSelected(int column) {
        return this.getSelectedColumnPosition() == column && this.getSelectedRowPosition() == -1;
    }

    public boolean isColumnShadowed(int column) {
        return this.getSelectedColumnPosition() == column && this.getSelectedRowPosition() != -1 || this.getSelectedColumnPosition() == -1 && this.getSelectedRowPosition() != -1;
    }

    public boolean isAnyColumnSelected() {
        return this.getSelectedColumnPosition() != -1 && this.getSelectedRowPosition() == -1;
    }

    public AbstractViewHolder.SelectionState getColumnSelectionState(int column) {
        if (this.isColumnShadowed(column)) {
            return AbstractViewHolder.SelectionState.SHADOWED;
        }
        if (this.isColumnSelected(column)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    public boolean isRowSelected(int row) {
        return this.getSelectedRowPosition() == row && this.getSelectedColumnPosition() == -1;
    }

    public boolean isRowShadowed(int row) {
        return this.getSelectedRowPosition() == row && this.getSelectedColumnPosition() != -1 || this.getSelectedRowPosition() == -1 && this.getSelectedColumnPosition() != -1;
    }

    public AbstractViewHolder.SelectionState getRowSelectionState(int row) {
        if (this.isRowShadowed(row)) {
            return AbstractViewHolder.SelectionState.SHADOWED;
        }
        if (this.isRowSelected(row)) {
            return AbstractViewHolder.SelectionState.SELECTED;
        }
        return AbstractViewHolder.SelectionState.UNSELECTED;
    }

    private void changeVisibleCellViewsBackgroundForRow(int row, boolean isSelected) {
        int selectedColor = this.mTableView.getSelectedColor();
        int unSelectedColor = this.mTableView.getUnSelectedColor();
        CellRecyclerView recyclerView = (CellRecyclerView)this.mTableView.getCellLayoutManager().findViewByPosition(row);
        if (recyclerView == null) {
            return;
        }
        recyclerView.setSelected(isSelected ? AbstractViewHolder.SelectionState.SELECTED : AbstractViewHolder.SelectionState.UNSELECTED, isSelected ? selectedColor : unSelectedColor, false);
    }

    private void changeVisibleCellViewsBackgroundForColumn(int column, boolean isSelected) {
        int selectedColor = this.mTableView.getSelectedColor();
        int unSelectedColor = this.mTableView.getUnSelectedColor();
        AbstractViewHolder[] visibleCellViews = this.mTableView.getCellLayoutManager().getVisibleCellViewsByColumnPosition(column);
        if (visibleCellViews != null) {
            for (AbstractViewHolder viewHolder : visibleCellViews) {
                if (viewHolder == null) continue;
                viewHolder.setBackgroundColor(isSelected ? selectedColor : unSelectedColor);
                viewHolder.setSelected(isSelected ? AbstractViewHolder.SelectionState.SELECTED : AbstractViewHolder.SelectionState.UNSELECTED);
            }
        }
    }

    public void changeRowBackgroundColorBySelectionStatus(AbstractViewHolder viewHolder, AbstractViewHolder.SelectionState selectionState) {
        if (this.shadowEnabled && selectionState == AbstractViewHolder.SelectionState.SHADOWED) {
            viewHolder.setBackgroundColor(this.mTableView.getShadowColor());
        } else if (selectionState == AbstractViewHolder.SelectionState.SELECTED) {
            viewHolder.setBackgroundColor(this.mTableView.getSelectedColor());
        } else {
            viewHolder.setBackgroundColor(this.mTableView.getUnSelectedColor());
        }
    }

    public void changeColumnBackgroundColorBySelectionStatus(AbstractViewHolder viewHolder, AbstractViewHolder.SelectionState selectionState) {
        if (this.shadowEnabled && selectionState == AbstractViewHolder.SelectionState.SHADOWED) {
            viewHolder.setBackgroundColor(this.mTableView.getShadowColor());
        } else if (selectionState == AbstractViewHolder.SelectionState.SELECTED) {
            viewHolder.setBackgroundColor(this.mTableView.getSelectedColor());
        } else {
            viewHolder.setBackgroundColor(this.mTableView.getUnSelectedColor());
        }
    }

    public void clearSelection() {
        this.unselectedRowHeader();
        this.unselectedCellView();
        this.unselectedColumnHeader();
    }

    public void setSelectedRowPosition(int row) {
        this.mSelectedRowPosition = row;
    }

    public void setSelectedColumnPosition(int column) {
        this.mSelectedColumnPosition = column;
    }
}

