/*
 * Decompiled with CFR 0.152.
 */
package com.evgenii.jsevaluator;

import android.content.Context;
import android.webkit.WebView;
import com.evgenii.jsevaluator.HandlerWrapper;
import com.evgenii.jsevaluator.JsFunctionCallFormatter;
import com.evgenii.jsevaluator.RequestIdGenerator;
import com.evgenii.jsevaluator.WebViewWrapper;
import com.evgenii.jsevaluator.interfaces.CallJavaResultInterface;
import com.evgenii.jsevaluator.interfaces.HandlerWrapperInterface;
import com.evgenii.jsevaluator.interfaces.JsCallback;
import com.evgenii.jsevaluator.interfaces.JsEvaluatorInterface;
import com.evgenii.jsevaluator.interfaces.WebViewWrapperInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsEvaluator
implements CallJavaResultInterface,
JsEvaluatorInterface {
    public static final String JS_NAMESPACE = "evgeniiJsEvaluator";
    private static final String JS_ERROR_PREFIX = "evgeniiJsEvaluatorException";
    protected WebViewWrapperInterface mWebViewWrapper;
    private final Context mContext;
    private final Map<Integer, JsCallback> mResultCallbacks = Collections.synchronizedMap(new HashMap());
    private HandlerWrapperInterface mHandler = new HandlerWrapper();
    private RequestIdGenerator requestIdGenerator = new RequestIdGenerator();

    public static String escapeCarriageReturn(String str) {
        return str.replace("\r", "\\r");
    }

    public static String escapeClosingScript(String str) {
        return str.replace("</", "<\\/");
    }

    public static String escapeNewLines(String str) {
        return str.replace("\n", "\\n");
    }

    public static String escapeSingleQuotes(String str) {
        return str.replace("'", "\\'");
    }

    public static String escapeSlash(String str) {
        return str.replace("\\", "\\\\");
    }

    public static String getJsForEval(String jsCode, int callbackIndex) {
        jsCode = JsEvaluator.escapeSlash(jsCode);
        jsCode = JsEvaluator.escapeSingleQuotes(jsCode);
        jsCode = JsEvaluator.escapeClosingScript(jsCode);
        jsCode = JsEvaluator.escapeNewLines(jsCode);
        jsCode = JsEvaluator.escapeCarriageReturn(jsCode);
        return String.format("%s.returnResultToJava(eval('try{%s}catch(e){\"%s\"+e}'), %s);", JS_NAMESPACE, jsCode, JS_ERROR_PREFIX, callbackIndex);
    }

    public JsEvaluator(Context context) {
        this.mContext = context;
    }

    @Override
    public void callFunction(String jsCode, JsCallback resultCallback, String name, Object ... args) {
        jsCode = jsCode + "; " + JsFunctionCallFormatter.toString(name, args);
        this.evaluate(jsCode, resultCallback);
    }

    @Override
    public void evaluate(String jsCode) {
        this.evaluate(jsCode, null);
    }

    @Override
    public void evaluate(String jsCode, JsCallback resultCallback) {
        int callbackIndex = this.requestIdGenerator.generate();
        String js = JsEvaluator.getJsForEval(jsCode, callbackIndex);
        if (resultCallback != null) {
            this.mResultCallbacks.put(callbackIndex, resultCallback);
        }
        this.getWebViewWrapper().loadJavaScript(js);
    }

    @Override
    public void destroy() {
        this.getWebViewWrapper().destroy();
    }

    @Override
    public WebView getWebView() {
        return this.getWebViewWrapper().getWebView();
    }

    public Map<Integer, JsCallback> getResultCallbacks() {
        return this.mResultCallbacks;
    }

    public WebViewWrapperInterface getWebViewWrapper() {
        if (this.mWebViewWrapper == null) {
            this.mWebViewWrapper = new WebViewWrapper(this.mContext, this);
        }
        return this.mWebViewWrapper;
    }

    @Override
    public void jsCallFinished(final String value, Integer callIndex) {
        final JsCallback callback = this.mResultCallbacks.remove(callIndex);
        if (callback == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (value != null && value.startsWith(JsEvaluator.JS_ERROR_PREFIX)) {
                    callback.onError(value.substring(JsEvaluator.JS_ERROR_PREFIX.length()));
                } else {
                    callback.onResult(value);
                }
            }
        });
    }

    public void setHandler(HandlerWrapperInterface handlerWrapperInterface) {
        this.mHandler = handlerWrapperInterface;
    }

    public void setWebViewWrapper(WebViewWrapperInterface webViewWrapper) {
        this.mWebViewWrapper = webViewWrapper;
    }

    public void setRequestIdGenerator(RequestIdGenerator requestIdGenerator) {
        this.requestIdGenerator = requestIdGenerator;
    }
}

