/*
 * Decompiled with CFR 0.152.
 */
package com.evgenii.jsevaluator;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.evgenii.jsevaluator.JavaScriptInterface;
import com.evgenii.jsevaluator.interfaces.CallJavaResultInterface;
import com.evgenii.jsevaluator.interfaces.WebViewWrapperInterface;
import java.io.UnsupportedEncodingException;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class WebViewWrapper
implements WebViewWrapperInterface {
    protected WebView mWebView;

    public WebViewWrapper(Context context, CallJavaResultInterface callJavaResult) {
        this.mWebView = new WebView(context);
        this.mWebView.setWillNotDraw(true);
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        JavaScriptInterface jsInterface = new JavaScriptInterface(callJavaResult);
        this.mWebView.addJavascriptInterface((Object)jsInterface, "evgeniiJsEvaluator");
    }

    @Override
    public void loadJavaScript(String javascript) {
        try {
            javascript = "<script>" + javascript + "</script>";
            byte[] data = javascript.getBytes("UTF-8");
            String base64 = Base64.encodeToString((byte[])data, (int)0);
            this.mWebView.loadUrl("data:text/html;charset=utf-8;base64," + base64);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        if (this.mWebView != null) {
            this.mWebView.clearHistory();
            this.mWebView.clearCache(true);
            this.mWebView.loadUrl("about:blank");
            this.mWebView.pauseTimers();
            this.mWebView = null;
        }
    }

    @Override
    public WebView getWebView() {
        return this.mWebView;
    }
}

