/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.everit.json.schema.FormatValidator;

public class URIFormatValidator
implements FormatValidator {
    private final boolean protocolRelativeURIPermitted;

    public URIFormatValidator() {
        this(true);
    }

    public URIFormatValidator(boolean protocolRelativeURIPermitted) {
        this.protocolRelativeURIPermitted = protocolRelativeURIPermitted;
    }

    @Override
    public Optional<String> validate(String subject) {
        try {
            URI uri = new URI(subject);
            if (this.hasProtocol(uri) || this.protocolRelativeURIPermitted && this.isProtocolRelativeURI(subject)) {
                return Optional.empty();
            }
            throw new URISyntaxException(subject, "no protocol and not protocol-relative");
        }
        catch (NullPointerException | URISyntaxException e) {
            return this.failure(subject);
        }
    }

    protected Optional<String> failure(String subject) {
        return Optional.of(String.format("[%s] is not a valid URI", subject));
    }

    private boolean isProtocolRelativeURI(String subject) {
        return subject.startsWith("//");
    }

    private boolean hasProtocol(URI uri) {
        return uri.getScheme() != null;
    }

    @Override
    public String formatName() {
        return "uri";
    }
}

