/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import com.google.re2j.Pattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

abstract class Visitor {
    Visitor() {
    }

    void visitNumberSchema(NumberSchema numberSchema) {
        this.visitExclusiveMinimum(numberSchema.isExclusiveMinimum());
        this.visitMinimum(numberSchema.getMinimum());
        this.visitExclusiveMinimumLimit(numberSchema.getExclusiveMinimumLimit());
        this.visitExclusiveMaximum(numberSchema.isExclusiveMaximum());
        this.visitMaximum(numberSchema.getMaximum());
        this.visitExclusiveMaximumLimit(numberSchema.getExclusiveMaximumLimit());
        this.visitMultipleOf(numberSchema.getMultipleOf());
    }

    void visitMinimum(Number minimum) {
    }

    void visitExclusiveMinimum(boolean exclusiveMinimum) {
    }

    void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
    }

    void visitMaximum(Number maximum) {
    }

    void visitExclusiveMaximum(boolean exclusiveMaximum) {
    }

    void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
    }

    void visitMultipleOf(Number multipleOf) {
    }

    void visit(Schema schema) {
        schema.accept(this);
    }

    void visitArraySchema(ArraySchema arraySchema) {
        this.visitMinItems(arraySchema.getMinItems());
        this.visitMaxItems(arraySchema.getMaxItems());
        this.visitUniqueItems(arraySchema.needsUniqueItems());
        this.visitAllItemSchema(arraySchema.getAllItemSchema());
        this.visitAdditionalItems(arraySchema.permitsAdditionalItems());
        List<Schema> itemSchemas = arraySchema.getItemSchemas();
        if (itemSchemas != null) {
            for (int i = 0; i < itemSchemas.size(); ++i) {
                this.visitItemSchema(i, itemSchemas.get(i));
            }
        }
        this.visitSchemaOfAdditionalItems(arraySchema.getSchemaOfAdditionalItems());
        this.visitContainedItemSchema(arraySchema.getContainedItemSchema());
    }

    void visitMinItems(Integer minItems) {
    }

    void visitMaxItems(Integer maxItems) {
    }

    void visitUniqueItems(boolean uniqueItems) {
    }

    void visitAllItemSchema(Schema allItemSchema) {
    }

    void visitAdditionalItems(boolean additionalItems) {
    }

    void visitItemSchema(int index, Schema itemSchema) {
    }

    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
    }

    void visitContainedItemSchema(Schema containedItemSchema) {
    }

    void visitBooleanSchema(BooleanSchema schema) {
    }

    void visitNullSchema(NullSchema nullSchema) {
    }

    void visitEmptySchema() {
    }

    void visitConstSchema(ConstSchema constSchema) {
    }

    void visitEnumSchema(EnumSchema enumSchema) {
    }

    void visitFalseSchema(FalseSchema falseSchema) {
    }

    void visitNotSchema(NotSchema notSchema) {
    }

    void visitReferenceSchema(ReferenceSchema referenceSchema) {
    }

    void visitObjectSchema(ObjectSchema objectSchema) {
        for (String string : objectSchema.getRequiredProperties()) {
            this.visitRequiredPropertyName(string);
        }
        this.visitPropertyNameSchema(objectSchema.getPropertyNameSchema());
        this.visitMinProperties(objectSchema.getMinProperties());
        this.visitMaxProperties(objectSchema.getMaxProperties());
        for (Map.Entry entry : objectSchema.getPropertyDependencies().entrySet()) {
            this.visitPropertyDependencies((String)entry.getKey(), (Set)entry.getValue());
        }
        this.visitAdditionalProperties(objectSchema.permitsAdditionalProperties());
        this.visitSchemaOfAdditionalProperties(objectSchema.getSchemaOfAdditionalProperties());
        for (Map.Entry entry : objectSchema.getPatternProperties().entrySet()) {
            this.visitPatternPropertySchema((Pattern)entry.getKey(), (Schema)entry.getValue());
        }
        for (Map.Entry entry : objectSchema.getSchemaDependencies().entrySet()) {
            this.visitSchemaDependency((String)entry.getKey(), (Schema)entry.getValue());
        }
        Map<String, Schema> propertySchemas = objectSchema.getPropertySchemas();
        if (propertySchemas != null) {
            for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
                this.visitPropertySchema(entry.getKey(), entry.getValue());
            }
        }
    }

    void visitPropertySchema(String properyName, Schema schema) {
    }

    void visitSchemaDependency(String propKey, Schema schema) {
    }

    void visitPatternPropertySchema(Pattern propertyNamePattern, Schema schema) {
    }

    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
    }

    void visitAdditionalProperties(boolean additionalProperties) {
    }

    void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
    }

    void visitMaxProperties(Integer maxProperties) {
    }

    void visitMinProperties(Integer minProperties) {
    }

    void visitPropertyNameSchema(Schema propertyNameSchema) {
    }

    void visitRequiredPropertyName(String requiredPropName) {
    }

    void visitStringSchema(StringSchema stringSchema) {
        this.visitMinLength(stringSchema.getMinLength());
        this.visitMaxLength(stringSchema.getMaxLength());
        this.visitPattern(stringSchema.getRE2JPattern());
        this.visitFormat(stringSchema.getFormatValidator());
    }

    void visitFormat(FormatValidator formatValidator) {
    }

    void visitPattern(Pattern pattern) {
    }

    void visitMaxLength(Integer maxLength) {
    }

    void visitMinLength(Integer minLength) {
    }

    void visitCombinedSchema(CombinedSchema combinedSchema) {
    }

    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        conditionalSchema.getIfSchema().ifPresent(this::visitIfSchema);
        conditionalSchema.getThenSchema().ifPresent(this::visitThenSchema);
        conditionalSchema.getElseSchema().ifPresent(this::visitElseSchema);
    }

    void visitIfSchema(Schema ifSchema) {
    }

    void visitThenSchema(Schema thenSchema) {
    }

    void visitElseSchema(Schema elseSchema) {
    }
}

