/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.loader.ArraySchemaLoader;
import org.everit.json.schema.loader.CombinedSchemaLoader;
import org.everit.json.schema.loader.ExclusiveLimitHandler;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.ObjectSchemaLoader;
import org.everit.json.schema.loader.ReferenceLookup;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.StringSchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.WrappingFormatValidator;
import org.json.JSONObject;
import org.json.JSONPointer;

public class SchemaLoader {
    private static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf");
    private static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    private final LoaderConfig config;
    private final LoadingState ls;
    private final ExclusiveLimitHandler exclusiveLimitHandler;

    static JSONObject toOrgJSONObject(JsonObject value) {
        return new JSONObject(value.toMap());
    }

    public static SchemaLoaderBuilder builder() {
        return new SchemaLoaderBuilder();
    }

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient httpClient) {
        SchemaLoader loader = SchemaLoader.builder().schemaJson(schemaJson).httpClient(httpClient).build();
        return loader.load().build();
    }

    private URI extractURIFromIdAttribute(JsonObject obj) {
        return obj.maybe(this.config.specVersion.idKeyword()).map(JsonValue::requireString).map(rawId -> {
            try {
                return new URI((String)rawId);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public SchemaLoader(SchemaLoaderBuilder builder) {
        Map schemaObj;
        Object schemaValue;
        SpecificationVersion specVersion = builder.specVersion;
        if (builder.schemaJson instanceof Map && (schemaValue = (schemaObj = (Map)builder.schemaJson).get("$schema")) != null) {
            specVersion = SpecificationVersion.getByMetaSchemaUrl((String)schemaValue);
        }
        this.config = new LoaderConfig(builder.httpClient, builder.formatValidators, specVersion, builder.useDefaults, builder.nullableSupport);
        this.ls = new LoadingState(this.config, builder.pointerSchemas, builder.rootSchemaJson == null ? builder.schemaJson : builder.rootSchemaJson, builder.schemaJson, builder.id, builder.pointerToCurrentObj);
        this.exclusiveLimitHandler = ExclusiveLimitHandler.ofSpecVersion(this.config.specVersion);
    }

    SchemaLoader(LoadingState ls) {
        this.ls = ls;
        this.config = ls.config;
        this.exclusiveLimitHandler = ExclusiveLimitHandler.ofSpecVersion(ls.specVersion());
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JsonArray subtypeJsons = this.ls.schemaJson().require("type").requireArray();
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        subtypeJsons.forEach((j, raw) -> subschemas.add((Schema)this.loadForExplicitType(raw.requireString()).build()));
        return CombinedSchema.anyOf(subschemas);
    }

    private Schema.Builder buildConstSchema() {
        return ConstSchema.builder().permittedValue(this.ls.schemaJson().require("const").unwrap());
    }

    private EnumSchema.Builder buildEnumSchema() {
        EnumSchema.Builder builder = EnumSchema.builder();
        HashSet<Object> possibleValues = new HashSet<Object>();
        this.ls.schemaJson().require("enum").requireArray().forEach((i, item) -> possibleValues.add(item.unwrap()));
        builder.possibleValues(possibleValues);
        return builder;
    }

    private NotSchema.Builder buildNotSchema() {
        Object mustNotMatch = this.loadChild(this.ls.schemaJson().require("not")).build();
        return NotSchema.builder().mustNotMatch((Schema)mustNotMatch);
    }

    private Schema.Builder<?> buildSchemaWithoutExplicitType() {
        if (this.ls.schemaJson().isEmpty()) {
            return EmptySchema.builder();
        }
        if (this.ls.schemaJson().containsKey("$ref")) {
            String ref = this.ls.schemaJson().require("$ref").requireString();
            return new ReferenceLookup(this.ls).lookup(ref, this.ls.schemaJson());
        }
        Schema.Builder<?> rval = this.sniffSchemaByProps();
        if (rval != null) {
            return rval;
        }
        if (this.ls.schemaJson().containsKey("not")) {
            return this.buildNotSchema();
        }
        return EmptySchema.builder();
    }

    private NumberSchema.Builder buildNumberSchema() {
        NumberSchema.Builder builder = NumberSchema.builder();
        this.ls.schemaJson().maybe("minimum").map(JsonValue::requireNumber).ifPresent(builder::minimum);
        this.ls.schemaJson().maybe("maximum").map(JsonValue::requireNumber).ifPresent(builder::maximum);
        this.ls.schemaJson().maybe("multipleOf").map(JsonValue::requireNumber).ifPresent(builder::multipleOf);
        this.ls.schemaJson().maybe("exclusiveMinimum").ifPresent(exclMin -> this.exclusiveLimitHandler.handleExclusiveMinimum((JsonValue)exclMin, builder));
        this.ls.schemaJson().maybe("exclusiveMaximum").ifPresent(exclMax -> this.exclusiveLimitHandler.handleExclusiveMaximum((JsonValue)exclMax, builder));
        return builder;
    }

    private Schema.Builder loadSchemaBoolean(Boolean rawBoolean) {
        return rawBoolean != false ? TrueSchema.builder() : FalseSchema.builder();
    }

    private Schema.Builder loadSchemaObject(JsonObject o) {
        Schema.Builder builder = this.ls.schemaJson().containsKey("enum") ? this.buildEnumSchema() : (this.ls.schemaJson().containsKey("const") && this.config.specVersion == SpecificationVersion.DRAFT_6 ? this.buildConstSchema() : new CombinedSchemaLoader(this.ls, this).load().orElseGet(() -> {
            if (!this.ls.schemaJson().containsKey("type") || this.ls.schemaJson().containsKey("$ref")) {
                return this.buildSchemaWithoutExplicitType();
            }
            return this.loadForType(this.ls.schemaJson().require("type"));
        }));
        this.loadCommonSchemaProperties(builder);
        return builder;
    }

    private void loadCommonSchemaProperties(Schema.Builder builder) {
        this.ls.schemaJson().maybe(this.config.specVersion.idKeyword()).map(JsonValue::requireString).ifPresent(builder::id);
        this.ls.schemaJson().maybe("title").map(JsonValue::requireString).ifPresent(builder::title);
        this.ls.schemaJson().maybe("description").map(JsonValue::requireString).ifPresent(builder::description);
        if (this.config.nullableSupport) {
            builder.nullable(this.ls.schemaJson().maybe("nullable").map(JsonValue::requireBoolean).orElse(Boolean.FALSE));
        }
        if (this.config.useDefaults) {
            this.ls.schemaJson().maybe("default").map(JsonValue::deepToOrgJson).ifPresent(builder::defaultValue);
        }
        builder.schemaLocation(new JSONPointer(this.ls.pointerToCurrentObj).toURIFragment());
    }

    public Schema.Builder<?> load() {
        return this.ls.schemaJson.canBeMappedTo(Boolean.class, this::loadSchemaBoolean).orMappedTo(JsonObject.class, this::loadSchemaObject).requireAny();
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        switch (typeString) {
            case "string": {
                return new StringSchemaLoader(this.ls, this.config.formatValidators).load();
            }
            case "integer": {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case "number": {
                return this.buildNumberSchema();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return this.buildArraySchema();
            }
            case "object": {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(String.format("unknown type: [%s]", typeString));
    }

    private ObjectSchema.Builder buildObjectSchema() {
        return new ObjectSchemaLoader(this.ls, this.config, this).load();
    }

    private ArraySchema.Builder buildArraySchema() {
        return new ArraySchemaLoader(this.ls, this.config, this).load();
    }

    Schema.Builder loadForType(JsonValue type) {
        return type.canBeMappedTo(JsonArray.class, arr -> this.buildAnyOfSchemaForMultipleTypes()).orMappedTo(String.class, this::loadForExplicitType).requireAny();
    }

    private boolean schemaHasAnyOf(Collection<String> propNames) {
        return propNames.stream().filter(this.ls.schemaJson()::containsKey).findAny().isPresent();
    }

    Schema.Builder<?> loadChild(JsonValue childJson) {
        return new SchemaLoader(childJson.ls).load();
    }

    Schema.Builder<?> sniffSchemaByProps() {
        if (this.schemaHasAnyOf(this.config.specVersion.arrayKeywords())) {
            return this.buildArraySchema().requiresArray(false);
        }
        if (this.schemaHasAnyOf(this.config.specVersion.objectKeywords())) {
            return this.buildObjectSchema().requiresObject(false);
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            return this.buildNumberSchema().requiresNumber(false);
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            return new StringSchemaLoader(this.ls, this.config.formatValidators).load().requiresString(false);
        }
        return null;
    }

    SpecificationVersion specVersion() {
        return this.ls.specVersion();
    }

    @Deprecated
    Optional<FormatValidator> getFormatValidator(String formatName) {
        return Optional.ofNullable(this.config.formatValidators.get(formatName));
    }

    public static class SchemaLoaderBuilder {
        SchemaClient httpClient = new DefaultSchemaClient();
        Object schemaJson;
        Object rootSchemaJson;
        Map<String, ReferenceSchema.Builder> pointerSchemas = new HashMap<String, ReferenceSchema.Builder>();
        URI id;
        List<String> pointerToCurrentObj = Collections.emptyList();
        Map<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>(SpecificationVersion.DRAFT_4.defaultFormatValidators());
        SpecificationVersion specVersion = SpecificationVersion.DRAFT_4;
        boolean useDefaults = false;
        private boolean nullableSupport = false;

        public SchemaLoaderBuilder addFormatValidator(FormatValidator formatValidator) {
            this.formatValidators.put(formatValidator.formatName(), formatValidator);
            return this;
        }

        @Deprecated
        public SchemaLoaderBuilder addFormatValidator(String formatName, FormatValidator formatValidator) {
            if (!Objects.equals(formatName, formatValidator.formatName())) {
                this.formatValidators.put(formatName, new WrappingFormatValidator(formatName, formatValidator));
            } else {
                this.formatValidators.put(formatName, formatValidator);
            }
            return this;
        }

        public SchemaLoaderBuilder draftV6Support() {
            this.specVersion = SpecificationVersion.DRAFT_6;
            this.formatValidators = new HashMap<String, FormatValidator>(SpecificationVersion.DRAFT_6.defaultFormatValidators());
            return this;
        }

        public SchemaLoader build() {
            return new SchemaLoader(this);
        }

        @Deprecated
        public JSONObject getRootSchemaJson() {
            return new JSONObject((Map)(this.rootSchemaJson == null ? this.schemaJson : this.rootSchemaJson));
        }

        public SchemaLoaderBuilder httpClient(SchemaClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SchemaLoaderBuilder resolutionScope(String id) {
            try {
                return this.resolutionScope(new URI(id));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public SchemaLoaderBuilder resolutionScope(URI id) {
            this.id = id;
            return this;
        }

        SchemaLoaderBuilder pointerSchemas(Map<String, ReferenceSchema.Builder> pointerSchemas) {
            this.pointerSchemas = pointerSchemas;
            return this;
        }

        SchemaLoaderBuilder rootSchemaJson(Object rootSchemaJson) {
            this.rootSchemaJson = rootSchemaJson;
            return this;
        }

        public SchemaLoaderBuilder schemaJson(JSONObject schemaJson) {
            return this.schemaJson(schemaJson.toMap());
        }

        public SchemaLoaderBuilder schemaJson(Object schema) {
            if (schema instanceof JSONObject) {
                schema = ((JSONObject)schema).toMap();
            }
            this.schemaJson = schema;
            return this;
        }

        SchemaLoaderBuilder formatValidators(Map<String, FormatValidator> formatValidators) {
            this.formatValidators = formatValidators;
            return this;
        }

        SchemaLoaderBuilder pointerToCurrentObj(List<String> pointerToCurrentObj) {
            this.pointerToCurrentObj = Objects.requireNonNull(pointerToCurrentObj);
            return this;
        }

        public SchemaLoaderBuilder useDefaults(boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public SchemaLoaderBuilder nullableSupport(boolean nullableSupport) {
            this.nullableSupport = nullableSupport;
            return this;
        }
    }
}

