/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Collection;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.ArraySchemaValidatingVisitor;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.NumberSchemaValidatingVisitor;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ObjectSchemaValidatingVisitor;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.StringSchemaValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.ValidationFailureReporter;
import org.everit.json.schema.Visitor;
import org.json.JSONObject;

class ValidatingVisitor
extends Visitor {
    protected Object subject;
    private ValidationFailureReporter failureReporter;

    private static boolean isNull(Object obj) {
        return obj == null || JSONObject.NULL.equals(obj);
    }

    @Override
    void visit(Schema schema) {
        if (schema.isNullable() == Boolean.FALSE && ValidatingVisitor.isNull(this.subject)) {
            this.failureReporter.failure("value cannot be null", "nullable");
        }
        super.visit(schema);
    }

    ValidatingVisitor(Object subject, ValidationFailureReporter failureReporter) {
        this.subject = subject;
        this.failureReporter = failureReporter;
    }

    @Override
    void visitNumberSchema(NumberSchema numberSchema) {
        numberSchema.accept(new NumberSchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitArraySchema(ArraySchema arraySchema) {
        arraySchema.accept(new ArraySchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitBooleanSchema(BooleanSchema schema) {
        if (!(this.subject instanceof Boolean)) {
            this.failureReporter.failure(Boolean.class, this.subject);
        }
    }

    @Override
    void visitNullSchema(NullSchema nullSchema) {
        if (this.subject != null && this.subject != JSONObject.NULL) {
            this.failureReporter.failure("expected: null, found: " + this.subject.getClass().getSimpleName(), "type");
        }
    }

    @Override
    void visitConstSchema(ConstSchema constSchema) {
        if (ValidatingVisitor.isNull(this.subject) && ValidatingVisitor.isNull(constSchema.getPermittedValue())) {
            return;
        }
        Object effectiveSubject = EnumSchema.toJavaValue(this.subject);
        if (!ObjectComparator.deepEquals(effectiveSubject, constSchema.getPermittedValue())) {
            this.failureReporter.failure("", "const");
        }
    }

    @Override
    void visitEnumSchema(EnumSchema enumSchema) {
        Object effectiveSubject = EnumSchema.toJavaValue(this.subject);
        for (Object possibleValue : enumSchema.getPossibleValues()) {
            if (!ObjectComparator.deepEquals(possibleValue, effectiveSubject)) continue;
            return;
        }
        this.failureReporter.failure(String.format("%s is not a valid enum value", this.subject), "enum");
    }

    @Override
    void visitFalseSchema(FalseSchema falseSchema) {
        this.failureReporter.failure("false schema always fails", "false");
    }

    @Override
    void visitNotSchema(NotSchema notSchema) {
        Schema mustNotMatch = notSchema.getMustNotMatch();
        ValidationException failure = this.getFailureOfSchema(mustNotMatch, this.subject);
        if (failure == null) {
            this.failureReporter.failure("subject must not be valid against schema " + mustNotMatch, "not");
        }
    }

    @Override
    void visitReferenceSchema(ReferenceSchema referenceSchema) {
        Schema referredSchema = referenceSchema.getReferredSchema();
        if (referredSchema == null) {
            throw new IllegalStateException("referredSchema must be injected before validation");
        }
        ValidationException failure = this.getFailureOfSchema(referredSchema, this.subject);
        if (failure != null) {
            this.failureReporter.failure(failure);
        }
    }

    @Override
    void visitObjectSchema(ObjectSchema objectSchema) {
        objectSchema.accept(new ObjectSchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitStringSchema(StringSchema stringSchema) {
        stringSchema.accept(new StringSchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitCombinedSchema(CombinedSchema combinedSchema) {
        ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
        Collection<Schema> subschemas = combinedSchema.getSubschemas();
        CombinedSchema.ValidationCriterion criterion = combinedSchema.getCriterion();
        for (Schema subschema : subschemas) {
            ValidationException exception = this.getFailureOfSchema(subschema, this.subject);
            if (null == exception) continue;
            failures.add(exception);
        }
        int matchingCount = subschemas.size() - failures.size();
        try {
            criterion.validate(subschemas.size(), matchingCount);
        }
        catch (ValidationException e) {
            this.failureReporter.failure(new ValidationException(combinedSchema, new StringBuilder(e.getPointerToViolation()), e.getMessage(), failures, e.getKeyword(), combinedSchema.getSchemaLocation()));
        }
    }

    ValidationException getFailureOfSchema(Schema schema, Object input) {
        Object origSubject = this.subject;
        this.subject = input;
        return this.failureReporter.inContextOfSchema(schema, () -> {
            this.visit(schema);
            this.subject = origSubject;
        });
    }

    void failIfErrorFound() {
        this.failureReporter.validationFinished();
    }

    void failure(String message, String keyword) {
        this.failureReporter.failure(message, keyword);
    }

    void failure(Class<?> expectedType, Object actualValue) {
        this.failureReporter.failure(expectedType, actualValue);
    }

    void failure(ValidationException exc) {
        this.failureReporter.failure(exc);
    }

    boolean passesTypeCheck(Class<?> expectedType, boolean schemaRequiresType, Boolean nullable) {
        if (ValidatingVisitor.isNull(this.subject)) {
            if (schemaRequiresType && nullable != Boolean.TRUE) {
                this.failureReporter.failure(expectedType, this.subject);
            }
            return false;
        }
        if (expectedType.isAssignableFrom(this.subject.getClass())) {
            return true;
        }
        if (schemaRequiresType) {
            this.failureReporter.failure(expectedType, this.subject);
        }
        return false;
    }
}

