/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;
import org.json.JSONObject;

class ObjectSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private JSONObject objSubject;
    private ObjectSchema schema;
    private int objectSize;
    private final ValidatingVisitor owner;

    public ObjectSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = Objects.requireNonNull(subject, "subject cannot be null");
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitObjectSchema(ObjectSchema objectSchema) {
        if (this.owner.passesTypeCheck(JSONObject.class, objectSchema.requiresObject(), objectSchema.isNullable())) {
            this.objSubject = (JSONObject)this.subject;
            this.objectSize = this.objSubject.length();
            this.schema = objectSchema;
            super.visitObjectSchema(objectSchema);
        }
    }

    @Override
    void visitRequiredPropertyName(String requiredPropName) {
        if (!this.objSubject.has(requiredPropName)) {
            this.owner.failure(String.format("required key [%s] not found", requiredPropName), "required");
        }
    }

    @Override
    void visitPropertyNameSchema(Schema propertyNameSchema) {
        if (propertyNameSchema != null) {
            String[] names = JSONObject.getNames((JSONObject)this.objSubject);
            if (names == null || names.length == 0) {
                return;
            }
            for (String name : names) {
                ValidationException failure = this.owner.getFailureOfSchema(propertyNameSchema, name);
                if (failure == null) continue;
                this.owner.failure(failure.prepend(name));
            }
        }
    }

    @Override
    void visitMinProperties(Integer minProperties) {
        if (minProperties != null && this.objectSize < minProperties) {
            this.owner.failure(String.format("minimum size: [%d], found: [%d]", minProperties, this.objectSize), "minProperties");
        }
    }

    @Override
    void visitMaxProperties(Integer maxProperties) {
        if (maxProperties != null && this.objectSize > maxProperties) {
            this.owner.failure(String.format("maximum size: [%d], found: [%d]", maxProperties, this.objectSize), "maxProperties");
        }
    }

    @Override
    void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
        if (this.objSubject.has(ifPresent)) {
            for (String mustBePresent : allMustBePresent) {
                if (this.objSubject.has(mustBePresent)) continue;
                this.owner.failure(String.format("property [%s] is required", mustBePresent), "dependencies");
            }
        }
    }

    @Override
    void visitAdditionalProperties(boolean permitsAdditionalProperties) {
        if (!permitsAdditionalProperties) {
            List<String> additionalProperties = this.getAdditionalProperties();
            if (null == additionalProperties || additionalProperties.isEmpty()) {
                return;
            }
            for (String additionalProperty : additionalProperties) {
                this.owner.failure(String.format("extraneous key [%s] is not permitted", additionalProperty), "additionalProperties");
            }
        }
    }

    @Override
    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
        if (schemaOfAdditionalProperties != null) {
            List<String> additionalPropNames = this.getAdditionalProperties();
            for (String propName : additionalPropNames) {
                Object propVal = this.objSubject.get(propName);
                ValidationException failure = this.owner.getFailureOfSchema(schemaOfAdditionalProperties, propVal);
                if (failure == null) continue;
                this.owner.failure(failure.prepend(propName, this.schema));
            }
        }
    }

    private List<String> getAdditionalProperties() {
        String[] names = JSONObject.getNames((JSONObject)this.objSubject);
        if (names == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (this.schema.getPropertySchemas().containsKey(name) || this.matchesAnyPattern(name)) continue;
            namesList.add(name);
        }
        return namesList;
    }

    private boolean matchesAnyPattern(String key) {
        for (Pattern pattern : this.schema.getPatternProperties().keySet()) {
            if (!pattern.matcher(key).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    void visitPatternPropertySchema(Pattern propertyNamePattern, Schema schema) {
        String[] propNames = JSONObject.getNames((JSONObject)this.objSubject);
        if (propNames == null || propNames.length == 0) {
            return;
        }
        for (String propName : propNames) {
            ValidationException failure;
            if (!propertyNamePattern.matcher(propName).find() || (failure = this.owner.getFailureOfSchema(schema, this.objSubject.get(propName))) == null) continue;
            this.owner.failure(failure.prepend(propName));
        }
    }

    @Override
    void visitSchemaDependency(String propName, Schema schema) {
        ValidationException failure;
        if (this.objSubject.has(propName) && (failure = this.owner.getFailureOfSchema(schema, this.objSubject)) != null) {
            this.owner.failure(failure);
        }
    }

    @Override
    void visitPropertySchema(String properyName, Schema schema) {
        if (this.objSubject.has(properyName)) {
            ValidationException failure = this.owner.getFailureOfSchema(schema, this.objSubject.get(properyName));
            if (failure != null) {
                this.owner.failure(failure.prepend(properyName));
            }
        } else if (schema.hasDefaultValue()) {
            this.objSubject.put(properyName, schema.getDefaultValue());
        }
    }
}

