/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.function.BiFunction;
import org.everit.json.schema.CollectingFailureReporter;
import org.everit.json.schema.EarlyFailingFailureReporter;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationFailureReporter;
import org.everit.json.schema.Validator;

class DefaultValidator
implements Validator {
    private BiFunction<Schema, Object, ValidatingVisitor> visitorFactory;
    private boolean failEarly;

    public DefaultValidator(boolean failEarly) {
        this.failEarly = failEarly;
    }

    @Override
    public void performValidation(Schema schema, Object input) {
        ValidationFailureReporter failureReporter = this.createFailureReporter(schema);
        ValidatingVisitor visitor = new ValidatingVisitor(input, failureReporter);
        visitor.visit(schema);
        visitor.failIfErrorFound();
    }

    private ValidationFailureReporter createFailureReporter(Schema schema) {
        if (this.failEarly) {
            return new EarlyFailingFailureReporter(schema);
        }
        return new CollectingFailureReporter(schema);
    }
}

