/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.internal.DateTimeFormatValidator;
import org.everit.json.schema.internal.EmailFormatValidator;
import org.everit.json.schema.internal.HostnameFormatValidator;
import org.everit.json.schema.internal.IPV4Validator;
import org.everit.json.schema.internal.IPV6Validator;
import org.everit.json.schema.internal.JsonPointerFormatValidator;
import org.everit.json.schema.internal.URIFormatValidator;
import org.everit.json.schema.internal.URIReferenceFormatValidator;
import org.everit.json.schema.internal.URITemplateFormatValidator;

enum SpecificationVersion {
    DRAFT_4{

        @Override
        List<String> arrayKeywords() {
            return V4_ARRAY_KEYWORDS;
        }

        @Override
        List<String> objectKeywords() {
            return V4_OBJECT_KEYWORDS;
        }

        @Override
        String idKeyword() {
            return "id";
        }

        @Override
        String metaSchemaUrl() {
            return "http://json-schema.org/draft-04/schema";
        }

        @Override
        Map<String, FormatValidator> defaultFormatValidators() {
            return V4_VALIDATORS;
        }
    }
    ,
    DRAFT_6{

        @Override
        List<String> arrayKeywords() {
            return V6_ARRAY_KEYWORDS;
        }

        @Override
        List<String> objectKeywords() {
            return V6_OBJECT_KEYWORDS;
        }

        @Override
        String idKeyword() {
            return "$id";
        }

        @Override
        String metaSchemaUrl() {
            return "http://json-schema.org/draft-06/schema";
        }

        @Override
        Map<String, FormatValidator> defaultFormatValidators() {
            return V6_VALIDATORS;
        }
    };

    private static final List<String> V6_OBJECT_KEYWORDS;
    private static final List<String> V6_ARRAY_KEYWORDS;
    private static final List<String> V4_OBJECT_KEYWORDS;
    private static final List<String> V4_ARRAY_KEYWORDS;
    private static final Map<String, FormatValidator> V4_VALIDATORS;
    private static final Map<String, FormatValidator> V6_VALIDATORS;

    static SpecificationVersion getByMetaSchemaUrl(String metaSchemaUrl) {
        return Arrays.stream(SpecificationVersion.values()).filter(v -> metaSchemaUrl.startsWith(v.metaSchemaUrl())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("could not determine schema version: no meta-schema is known with URL [%s]", metaSchemaUrl)));
    }

    private static final List<String> keywords(String ... keywords) {
        return Collections.unmodifiableList(Arrays.asList(keywords));
    }

    abstract List<String> arrayKeywords();

    abstract List<String> objectKeywords();

    abstract String idKeyword();

    abstract String metaSchemaUrl();

    abstract Map<String, FormatValidator> defaultFormatValidators();

    static {
        V6_OBJECT_KEYWORDS = SpecificationVersion.keywords("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties", "propertyNames");
        V6_ARRAY_KEYWORDS = SpecificationVersion.keywords("items", "additionalItems", "minItems", "maxItems", "uniqueItems", "contains");
        V4_OBJECT_KEYWORDS = SpecificationVersion.keywords("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties");
        V4_ARRAY_KEYWORDS = SpecificationVersion.keywords("items", "additionalItems", "minItems", "maxItems", "uniqueItems");
        HashMap<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>();
        formatValidators.put("date-time", new DateTimeFormatValidator());
        formatValidators.put("uri", new URIFormatValidator());
        formatValidators.put("email", new EmailFormatValidator());
        formatValidators.put("ipv4", new IPV4Validator());
        formatValidators.put("ipv6", new IPV6Validator());
        formatValidators.put("hostname", new HostnameFormatValidator());
        V4_VALIDATORS = Collections.unmodifiableMap(formatValidators);
        HashMap<String, FormatValidator> v6Validators = new HashMap<String, FormatValidator>(V4_VALIDATORS);
        v6Validators.put("json-pointer", new JsonPointerFormatValidator());
        v6Validators.put("uri-reference", new URIReferenceFormatValidator());
        v6Validators.put("uri-template", new URITemplateFormatValidator());
        V6_VALIDATORS = Collections.unmodifiableMap(v6Validators);
    }
}

