/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONObject;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final Schema propertyNameSchema;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Pattern, Schema> patternProperties;

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = ObjectSchema.copyMap(builder.propertyDependencies);
        this.schemaDependencies = ObjectSchema.copyMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = ObjectSchema.copyMap(builder.patternProperties);
        this.propertyNameSchema = builder.propertyNameSchema;
    }

    private List<String> getAdditionalProperties(JSONObject subject) {
        String[] names = JSONObject.getNames((JSONObject)subject);
        if (names == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (this.propertySchemas.containsKey(name) || this.matchesAnyPattern(name)) continue;
            namesList.add(name);
        }
        return namesList;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Map<Pattern, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    public Schema getPropertyNameSchema() {
        return this.propertyNameSchema;
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        try {
            schema.validate(input);
            return Optional.empty();
        }
        catch (ValidationException e) {
            return Optional.of(e);
        }
    }

    private boolean matchesAnyPattern(String key) {
        for (Pattern pattern : this.patternProperties.keySet()) {
            if (!pattern.matcher(key).find()) continue;
            return true;
        }
        return false;
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    private void testAdditionalProperties(JSONObject subject, List<ValidationException> validationExceptions) {
        block4: {
            block3: {
                if (this.additionalProperties) break block3;
                List<String> additionalProperties = this.getAdditionalProperties(subject);
                if (null == additionalProperties || additionalProperties.isEmpty()) {
                    return;
                }
                for (String additionalProperty : additionalProperties) {
                    validationExceptions.add(new ValidationException((Schema)this, String.format("extraneous key [%s] is not permitted", additionalProperty), "additionalProperties"));
                }
                break block4;
            }
            if (this.schemaOfAdditionalProperties == null) break block4;
            List<String> additionalPropNames = this.getAdditionalProperties(subject);
            for (String propName : additionalPropNames) {
                Object propVal = subject.get(propName);
                Optional<ValidationException> exception = this.ifFails(this.schemaOfAdditionalProperties, propVal);
                if (!exception.isPresent()) continue;
                validationExceptions.add(exception.get().prepend(propName, this));
            }
        }
    }

    private void testPatternProperties(JSONObject subject, List<ValidationException> validationExceptions) {
        String[] propNames = JSONObject.getNames((JSONObject)subject);
        if (propNames == null || propNames.length == 0) {
            return;
        }
        for (Map.Entry<Pattern, Schema> entry : this.patternProperties.entrySet()) {
            for (String propName : propNames) {
                Optional<ValidationException> exception;
                if (!entry.getKey().matcher(propName).find() || !(exception = this.ifFails(entry.getValue(), subject.get(propName))).isPresent()) continue;
                validationExceptions.add(exception.get().prepend(propName));
            }
        }
    }

    private void testProperties(JSONObject subject, List<ValidationException> validationExceptions) {
        if (this.propertySchemas != null) {
            for (Map.Entry<String, Schema> entry : this.propertySchemas.entrySet()) {
                Optional<ValidationException> exception;
                String key = entry.getKey();
                if (!subject.has(key) || !(exception = this.ifFails(entry.getValue(), subject.get(key))).isPresent()) continue;
                validationExceptions.add(exception.get().prepend(key));
            }
        }
    }

    private void testPropertyDependencies(JSONObject subject, List<ValidationException> validationExceptions) {
        for (String property : this.propertyDependencies.keySet()) {
            if (!subject.has(property)) continue;
            for (String mustBePresent : this.propertyDependencies.get(property)) {
                if (subject.has(mustBePresent)) continue;
                validationExceptions.add(this.failure(String.format("property [%s] is required", mustBePresent), "dependencies"));
            }
        }
    }

    private void testRequiredProperties(JSONObject subject, List<ValidationException> validationExceptions) {
        for (String required : this.requiredProperties) {
            if (subject.has(required)) continue;
            validationExceptions.add(this.failure(String.format("required key [%s] not found", required), "required"));
        }
    }

    private void testSchemaDependencies(JSONObject subject, List<ValidationException> validationExceptions) {
        for (Map.Entry<String, Schema> schemaDep : this.schemaDependencies.entrySet()) {
            String propName = schemaDep.getKey();
            if (!subject.has(propName)) continue;
            this.ifFails(schemaDep.getValue(), subject).ifPresent(validationExceptions::add);
        }
    }

    private void testSize(JSONObject subject, List<ValidationException> validationExceptions) {
        int actualSize = subject.length();
        if (this.minProperties != null && actualSize < this.minProperties) {
            validationExceptions.addAll(Arrays.asList(this.failure(String.format("minimum size: [%d], found: [%d]", this.minProperties, actualSize), "minProperties")));
            return;
        }
        if (this.maxProperties != null && actualSize > this.maxProperties) {
            validationExceptions.addAll(Arrays.asList(this.failure(String.format("maximum size: [%d], found: [%d]", this.maxProperties, actualSize), "maxProperties")));
        }
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONObject)) {
            if (this.requiresObject) {
                throw this.failure(JSONObject.class, subject);
            }
        } else {
            ArrayList<ValidationException> validationExceptions = new ArrayList<ValidationException>();
            JSONObject objSubject = (JSONObject)subject;
            this.testProperties(objSubject, validationExceptions);
            this.testRequiredProperties(objSubject, validationExceptions);
            this.testAdditionalProperties(objSubject, validationExceptions);
            this.testSize(objSubject, validationExceptions);
            this.testPropertyDependencies(objSubject, validationExceptions);
            this.testSchemaDependencies(objSubject, validationExceptions);
            this.testPatternProperties(objSubject, validationExceptions);
            this.testPropertyNames(objSubject, validationExceptions);
            ValidationException.throwFor(this, validationExceptions);
        }
    }

    private void testPropertyNames(JSONObject subject, List<ValidationException> validationExceptions) {
        if (this.propertyNameSchema != null) {
            String[] names = JSONObject.getNames((JSONObject)subject);
            if (names == null || names.length == 0) {
                return;
            }
            for (String name : names) {
                try {
                    this.propertyNameSchema.validate(name);
                }
                catch (ValidationException e) {
                    validationExceptions.add(e.prepend(name));
                }
            }
        }
    }

    @Override
    public boolean definesProperty(String field) {
        String remaining;
        String nextToken;
        int firstSlashIdx = (field = field.replaceFirst("^#", "").replaceFirst("^/", "")).indexOf(47);
        if (firstSlashIdx == -1) {
            nextToken = field;
            remaining = null;
        } else {
            nextToken = field.substring(0, firstSlashIdx);
            remaining = field.substring(firstSlashIdx + 1);
        }
        return !field.isEmpty() && (this.definesSchemaProperty(nextToken, remaining) || this.definesPatternProperty(nextToken, remaining) || this.definesSchemaDependencyProperty(field));
    }

    private boolean definesSchemaProperty(String current, String remaining) {
        boolean hasSuffix;
        current = this.unescape(current);
        boolean bl = hasSuffix = remaining != null;
        if (this.propertySchemas.containsKey(current)) {
            if (hasSuffix) {
                return this.propertySchemas.get(current).definesProperty(remaining);
            }
            return true;
        }
        return false;
    }

    private boolean definesPatternProperty(String current, String remaining) {
        for (Pattern pattern : this.patternProperties.keySet()) {
            if (!pattern.matcher(current).matches() || remaining != null && !this.patternProperties.get(pattern).definesProperty(remaining)) continue;
            return true;
        }
        return false;
    }

    private boolean definesSchemaDependencyProperty(String field) {
        if (this.schemaDependencies.containsKey(field)) {
            return true;
        }
        for (Schema schema : this.schemaDependencies.values()) {
            if (!schema.definesProperty(field)) continue;
            return true;
        }
        return false;
    }

    private String unescape(String value) {
        return value.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)o;
            return that.canEqual(this) && this.additionalProperties == that.additionalProperties && this.requiresObject == that.requiresObject && Objects.equals(this.propertySchemas, that.propertySchemas) && Objects.equals(this.schemaOfAdditionalProperties, that.schemaOfAdditionalProperties) && Objects.equals(this.requiredProperties, that.requiredProperties) && Objects.equals(this.minProperties, that.minProperties) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.propertyDependencies, that.propertyDependencies) && Objects.equals(this.schemaDependencies, that.schemaDependencies) && Objects.equals(this.patternProperties, that.patternProperties) && Objects.equals(this.propertyNameSchema, that.propertyNameSchema) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertySchemas, this.propertyNameSchema, this.additionalProperties, this.schemaOfAdditionalProperties, this.requiredProperties, this.minProperties, this.maxProperties, this.propertyDependencies, this.schemaDependencies, this.requiresObject, this.patternProperties);
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresObject) {
            writer.key("type").value("object");
        }
        if (!this.propertySchemas.isEmpty()) {
            writer.key("properties");
            writer.printSchemaMap(this.propertySchemas);
        }
        writer.ifPresent("minProperties", this.minProperties);
        writer.ifPresent("maxProperties", this.maxProperties);
        if (!this.requiredProperties.isEmpty()) {
            writer.key("required").value(this.requiredProperties);
        }
        if (this.schemaOfAdditionalProperties != null) {
            writer.key("additionalProperties");
            this.schemaOfAdditionalProperties.describeTo(writer);
        }
        if (this.propertyNameSchema != null) {
            writer.key("propertyNames");
            this.propertyNameSchema.describeTo(writer);
        }
        if (!this.propertyDependencies.isEmpty()) {
            this.describePropertyDependenciesTo(writer);
        }
        if (!this.schemaDependencies.isEmpty()) {
            writer.key("dependencies");
            writer.printSchemaMap(this.schemaDependencies);
        }
        if (!this.patternProperties.isEmpty()) {
            writer.key("patternProperties");
            writer.printSchemaMap(this.patternProperties);
        }
        writer.ifFalse("additionalProperties", this.additionalProperties);
    }

    private void describePropertyDependenciesTo(JSONPrinter writer) {
        writer.key("dependencies");
        writer.object();
        this.propertyDependencies.entrySet().forEach(entry -> {
            writer.key((String)entry.getKey());
            writer.array();
            ((Set)entry.getValue()).forEach(writer::value);
            writer.endArray();
        });
        writer.endObject();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectSchema;
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private final Map<Pattern, Schema> patternProperties = new HashMap<Pattern, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new HashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();
        private Schema propertyNameSchema;

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull(propName, "propName cannot be null");
            Objects.requireNonNull(schema, "schema cannot be null");
            this.propertySchemas.put(propName, schema);
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder patternProperty(Pattern pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder patternProperty(String pattern, Schema schema) {
            return this.patternProperty(Pattern.compile(pattern), schema);
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new HashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }

        public Builder propertyNameSchema(Schema propertyNameSchema) {
            this.propertyNameSchema = propertyNameSchema;
            return this;
        }
    }
}

