/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import org.everit.json.schema.Schema;
import org.everit.json.schema.internal.JSONPrinter;

public class BooleanSchema
extends Schema {
    public static final BooleanSchema INSTANCE = new BooleanSchema(BooleanSchema.builder());

    public static Builder builder() {
        return new Builder();
    }

    public BooleanSchema(Builder builder) {
        super(builder);
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof Boolean)) {
            throw this.failure(Boolean.class, subject);
        }
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key("type");
        writer.value("boolean");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BooleanSchema) {
            BooleanSchema that = (BooleanSchema)o;
            return that.canEqual(this) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BooleanSchema;
    }

    public static class Builder
    extends Schema.Builder<BooleanSchema> {
        @Override
        public BooleanSchema build() {
            return new BooleanSchema(this);
        }
    }
}

