/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONArray;

public class ArraySchema
extends Schema {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;
    private final Schema allItemSchema;
    private final boolean additionalItems;
    private final List<Schema> itemSchemas;
    private final boolean requiresArray;
    private final Schema schemaOfAdditionalItems;
    private final Schema containedItemSchema;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(Builder builder) {
        super(builder);
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
        this.uniqueItems = builder.uniqueItems;
        this.allItemSchema = builder.allItemSchema;
        this.itemSchemas = builder.itemSchemas;
        this.additionalItems = !builder.additionalItems && this.allItemSchema != null ? true : builder.schemaOfAdditionalItems != null || builder.additionalItems;
        this.schemaOfAdditionalItems = builder.schemaOfAdditionalItems;
        if (this.allItemSchema != null && this.itemSchemas != null) {
            throw new SchemaException("cannot perform both tuple and list validation");
        }
        this.requiresArray = builder.requiresArray;
        this.containedItemSchema = builder.containedItemSchema;
    }

    public Schema getAllItemSchema() {
        return this.allItemSchema;
    }

    public List<Schema> getItemSchemas() {
        return this.itemSchemas;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema getSchemaOfAdditionalItems() {
        return this.schemaOfAdditionalItems;
    }

    public Schema getContainedItemSchema() {
        return this.containedItemSchema;
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        try {
            schema.validate(input);
            return Optional.empty();
        }
        catch (ValidationException e) {
            return Optional.of(e);
        }
    }

    public boolean needsUniqueItems() {
        return this.uniqueItems;
    }

    public boolean permitsAdditionalItems() {
        return this.additionalItems;
    }

    public boolean requiresArray() {
        return this.requiresArray;
    }

    private void testItemCount(JSONArray subject, List<ValidationException> validationExceptions) {
        int actualLength = subject.length();
        if (this.minItems != null && actualLength < this.minItems) {
            validationExceptions.add(this.failure("expected minimum item count: " + this.minItems + ", found: " + actualLength, "minItems"));
            return;
        }
        if (this.maxItems != null && this.maxItems < actualLength) {
            validationExceptions.add(this.failure("expected maximum item count: " + this.maxItems + ", found: " + actualLength, "maxItems"));
        }
    }

    private void testItems(JSONArray subject, List<ValidationException> validationExceptions) {
        if (this.allItemSchema != null) {
            this.validateItemsAgainstSchema(IntStream.range(0, subject.length()), subject, this.allItemSchema, validationExceptions::add);
        } else if (this.itemSchemas != null) {
            if (!this.additionalItems && subject.length() > this.itemSchemas.size()) {
                validationExceptions.add(this.failure(String.format("expected: [%d] array items, found: [%d]", this.itemSchemas.size(), subject.length()), "items"));
            }
            int itemValidationUntil = Math.min(subject.length(), this.itemSchemas.size());
            this.validateItemsAgainstSchema(IntStream.range(0, itemValidationUntil), subject, this.itemSchemas::get, validationExceptions::add);
            if (this.schemaOfAdditionalItems != null) {
                this.validateItemsAgainstSchema(IntStream.range(itemValidationUntil, subject.length()), subject, this.schemaOfAdditionalItems, validationExceptions::add);
            }
        }
    }

    private void validateItemsAgainstSchema(IntStream indices, JSONArray items, Schema schema, Consumer<ValidationException> failureCollector) {
        this.validateItemsAgainstSchema(indices, items, (int i) -> schema, failureCollector);
    }

    private void validateItemsAgainstSchema(IntStream indices, JSONArray items, IntFunction<Schema> schemaForIndex, Consumer<ValidationException> failureCollector) {
        for (int i : indices.toArray()) {
            String copyOfI = String.valueOf(i);
            this.ifFails(schemaForIndex.apply(i), items.get(i)).map(exc -> exc.prepend(copyOfI)).ifPresent(failureCollector);
        }
    }

    private void testUniqueness(JSONArray subject, List<ValidationException> validationExceptions) {
        if (subject.length() == 0) {
            return;
        }
        ArrayList<Object> uniqueItems = new ArrayList<Object>(subject.length());
        for (int i = 0; i < subject.length(); ++i) {
            Object item = subject.get(i);
            for (Object e : uniqueItems) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                validationExceptions.add(this.failure("array items are not unique", "uniqueItems"));
                return;
            }
            uniqueItems.add(item);
        }
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONArray)) {
            if (this.requiresArray) {
                throw this.failure(JSONArray.class, subject);
            }
        } else {
            ArrayList<ValidationException> validationExceptions = new ArrayList<ValidationException>();
            JSONArray arrSubject = (JSONArray)subject;
            this.testItemCount(arrSubject, validationExceptions);
            if (this.uniqueItems) {
                this.testUniqueness(arrSubject, validationExceptions);
            }
            this.testItems(arrSubject, validationExceptions);
            this.testContains(arrSubject, validationExceptions);
            if (null != validationExceptions) {
                ValidationException.throwFor(this, validationExceptions);
            }
        }
    }

    private void testContains(JSONArray arrSubject, List<ValidationException> validationExceptions) {
        if (this.containedItemSchema == null) {
            return;
        }
        for (int i = 0; i < arrSubject.length(); ++i) {
            Optional<ValidationException> exception = this.ifFails(this.containedItemSchema, arrSubject.get(i));
            if (exception.isPresent()) continue;
            return;
        }
        validationExceptions.add(this.failure("expected at least one array item to match 'contains' schema", "contains"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)o;
            return that.canEqual(this) && this.uniqueItems == that.uniqueItems && this.additionalItems == that.additionalItems && this.requiresArray == that.requiresArray && Objects.equals(this.minItems, that.minItems) && Objects.equals(this.maxItems, that.maxItems) && Objects.equals(this.allItemSchema, that.allItemSchema) && Objects.equals(this.itemSchemas, that.itemSchemas) && Objects.equals(this.schemaOfAdditionalItems, that.schemaOfAdditionalItems) && Objects.equals(this.containedItemSchema, that.containedItemSchema) && super.equals(o);
        }
        return false;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresArray) {
            writer.key("type").value("array");
        }
        writer.ifTrue("uniqueItems", this.uniqueItems);
        writer.ifPresent("minItems", this.minItems);
        writer.ifPresent("maxItems", this.maxItems);
        writer.ifFalse("additionalItems", this.additionalItems);
        if (this.allItemSchema != null) {
            writer.key("items");
            this.allItemSchema.describeTo(writer);
        }
        if (this.itemSchemas != null) {
            writer.key("items");
            writer.array();
            this.itemSchemas.forEach(schema -> schema.describeTo(writer));
            writer.endArray();
        }
        if (this.schemaOfAdditionalItems != null) {
            writer.key("additionalItems");
            this.schemaOfAdditionalItems.describeTo(writer);
        }
        if (this.containedItemSchema != null) {
            writer.key("contains");
            this.containedItemSchema.describeTo(writer);
        }
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArraySchema;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minItems, this.maxItems, this.uniqueItems, this.allItemSchema, this.additionalItems, this.itemSchemas, this.requiresArray, this.schemaOfAdditionalItems, this.containedItemSchema);
    }

    public static class Builder
    extends Schema.Builder<ArraySchema> {
        private boolean requiresArray = true;
        private Integer minItems;
        private Integer maxItems;
        private boolean uniqueItems = false;
        private Schema allItemSchema;
        private List<Schema> itemSchemas = null;
        private boolean additionalItems = true;
        private Schema schemaOfAdditionalItems;
        private Schema containedItemSchema;

        public Builder addItemSchema(Schema itemSchema) {
            if (this.itemSchemas == null) {
                this.itemSchemas = new ArrayList<Schema>();
            }
            this.itemSchemas.add(Objects.requireNonNull(itemSchema, "itemSchema cannot be null"));
            return this;
        }

        public Builder additionalItems(boolean additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        public Builder allItemSchema(Schema allItemSchema) {
            this.allItemSchema = allItemSchema;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder requiresArray(boolean requiresArray) {
            this.requiresArray = requiresArray;
            return this;
        }

        public Builder schemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
            this.schemaOfAdditionalItems = schemaOfAdditionalItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        public Builder containsItemSchema(Schema contained) {
            this.containedItemSchema = contained;
            return this;
        }
    }
}

