/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.io.StringWriter;
import java.util.Objects;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;

public abstract class Schema {
    private final String title;
    private final String description;
    private final String id;
    protected final String schemaLocation;

    protected Schema(Builder<?> builder) {
        this.title = ((Builder)builder).title;
        this.description = ((Builder)builder).description;
        this.id = ((Builder)builder).id;
        this.schemaLocation = ((Builder)builder).schemaLocation;
    }

    public abstract void validate(Object var1);

    public boolean definesProperty(String field) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Schema) {
            Schema schema = (Schema)o;
            return schema.canEqual(this) && Objects.equals(this.title, schema.title) && Objects.equals(this.description, schema.description) && Objects.equals(this.id, schema.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.id);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public final void describeTo(JSONPrinter writer) {
        writer.object();
        writer.ifPresent("title", this.title);
        writer.ifPresent("description", this.description);
        writer.ifPresent("id", this.id);
        this.describePropertiesTo(writer);
        writer.endObject();
    }

    void describePropertiesTo(JSONPrinter writer) {
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.describeTo(new JSONPrinter(w));
        return w.getBuffer().toString();
    }

    protected ValidationException failure(String message, String keyword) {
        return new ValidationException(this, message, keyword, this.schemaLocation);
    }

    protected ValidationException failure(Class<?> expectedType, Object actualValue) {
        return new ValidationException(this, expectedType, actualValue, "type", this.schemaLocation);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public static abstract class Builder<S extends Schema> {
        private String title;
        private String description;
        private String id;
        private String schemaLocation;

        public Builder<S> title(String title) {
            this.title = title;
            return this;
        }

        public Builder<S> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<S> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<S> schemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public abstract S build();
    }
}

