/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONObject;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final Schema propertyNameSchema;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Pattern, Schema> patternProperties;

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = ObjectSchema.copyMap(builder.propertyDependencies);
        this.schemaDependencies = ObjectSchema.copyMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = ObjectSchema.copyMap(builder.patternProperties);
        this.propertyNameSchema = builder.propertyNameSchema;
    }

    private Stream<String> getAdditionalProperties(JSONObject subject) {
        String[] names = JSONObject.getNames((JSONObject)subject);
        if (names == null) {
            return Stream.empty();
        }
        return Arrays.stream(names).filter(key -> !this.propertySchemas.containsKey(key)).filter(key -> !this.matchesAnyPattern((String)key));
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Map<Pattern, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    public Schema getPropertyNameSchema() {
        return this.propertyNameSchema;
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        try {
            schema.validate(input);
            return Optional.empty();
        }
        catch (ValidationException e) {
            return Optional.of(e);
        }
    }

    private boolean matchesAnyPattern(String key) {
        return this.patternProperties.keySet().stream().filter(pattern -> pattern.matcher(key).find()).findAny().isPresent();
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    private List<ValidationException> testAdditionalProperties(JSONObject subject) {
        if (!this.additionalProperties) {
            return this.getAdditionalProperties(subject).map(unneeded -> String.format("extraneous key [%s] is not permitted", unneeded)).map(msg -> new ValidationException((Schema)this, (String)msg, "additionalProperties")).collect(Collectors.toList());
        }
        if (this.schemaOfAdditionalProperties != null) {
            List additionalPropNames = this.getAdditionalProperties(subject).collect(Collectors.toList());
            ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
            for (String propName : additionalPropNames) {
                Object propVal = subject.get(propName);
                this.ifFails(this.schemaOfAdditionalProperties, propVal).map(failure -> failure.prepend(propName, this)).ifPresent(rval::add);
            }
            return rval;
        }
        return Collections.emptyList();
    }

    private List<ValidationException> testPatternProperties(JSONObject subject) {
        String[] propNames = JSONObject.getNames((JSONObject)subject);
        if (propNames == null || propNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        for (Map.Entry<Pattern, Schema> entry : this.patternProperties.entrySet()) {
            for (String propName : propNames) {
                if (!entry.getKey().matcher(propName).find()) continue;
                this.ifFails(entry.getValue(), subject.get(propName)).map(exc -> exc.prepend(propName)).ifPresent(rval::add);
            }
        }
        return rval;
    }

    private List<ValidationException> testProperties(JSONObject subject) {
        if (this.propertySchemas != null) {
            ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
            for (Map.Entry<String, Schema> entry : this.propertySchemas.entrySet()) {
                String key = entry.getKey();
                if (!subject.has(key)) continue;
                this.ifFails(entry.getValue(), subject.get(key)).map(exc -> exc.prepend(key)).ifPresent(rval::add);
            }
            return rval;
        }
        return Collections.emptyList();
    }

    private List<ValidationException> testPropertyDependencies(JSONObject subject) {
        return this.propertyDependencies.keySet().stream().filter(arg_0 -> ((JSONObject)subject).has(arg_0)).flatMap(ifPresent -> this.propertyDependencies.get(ifPresent).stream()).filter(mustBePresent -> !subject.has(mustBePresent)).map(missingKey -> String.format("property [%s] is required", missingKey)).map(excMessage -> this.failure((String)excMessage, "dependencies")).collect(Collectors.toList());
    }

    private List<ValidationException> testRequiredProperties(JSONObject subject) {
        return this.requiredProperties.stream().filter(key -> !subject.has(key)).map(missingKey -> String.format("required key [%s] not found", missingKey)).map(excMessage -> this.failure((String)excMessage, "required")).collect(Collectors.toList());
    }

    private List<ValidationException> testSchemaDependencies(JSONObject subject) {
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        for (Map.Entry<String, Schema> schemaDep : this.schemaDependencies.entrySet()) {
            String propName = schemaDep.getKey();
            if (!subject.has(propName)) continue;
            this.ifFails(schemaDep.getValue(), subject).ifPresent(rval::add);
        }
        return rval;
    }

    private List<ValidationException> testSize(JSONObject subject) {
        int actualSize = subject.length();
        if (this.minProperties != null && actualSize < this.minProperties) {
            return Arrays.asList(this.failure(String.format("minimum size: [%d], found: [%d]", this.minProperties, actualSize), "minProperties"));
        }
        if (this.maxProperties != null && actualSize > this.maxProperties) {
            return Arrays.asList(this.failure(String.format("maximum size: [%d], found: [%d]", this.maxProperties, actualSize), "maxProperties"));
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof JSONObject)) {
            if (this.requiresObject) {
                throw this.failure(JSONObject.class, subject);
            }
        } else {
            ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
            JSONObject objSubject = (JSONObject)subject;
            failures.addAll(this.testProperties(objSubject));
            failures.addAll(this.testRequiredProperties(objSubject));
            failures.addAll(this.testAdditionalProperties(objSubject));
            failures.addAll(this.testSize(objSubject));
            failures.addAll(this.testPropertyDependencies(objSubject));
            failures.addAll(this.testSchemaDependencies(objSubject));
            failures.addAll(this.testPatternProperties(objSubject));
            failures.addAll(this.testPropertyNames(objSubject));
            ValidationException.throwFor(this, failures);
        }
    }

    private Collection<? extends ValidationException> testPropertyNames(JSONObject subject) {
        if (this.propertyNameSchema != null) {
            String[] names = JSONObject.getNames((JSONObject)subject);
            if (names == null || names.length == 0) {
                return Collections.emptyList();
            }
            Collection failures = Arrays.stream(names).map(name -> {
                try {
                    this.propertyNameSchema.validate(name);
                    return null;
                }
                catch (ValidationException e) {
                    return e.prepend((String)name);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return failures;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean definesProperty(String field) {
        String remaining;
        String nextToken;
        int firstSlashIdx = (field = field.replaceFirst("^#", "").replaceFirst("^/", "")).indexOf(47);
        if (firstSlashIdx == -1) {
            nextToken = field;
            remaining = null;
        } else {
            nextToken = field.substring(0, firstSlashIdx);
            remaining = field.substring(firstSlashIdx + 1);
        }
        return !field.isEmpty() && (this.definesSchemaProperty(nextToken, remaining) || this.definesPatternProperty(nextToken, remaining) || this.definesSchemaDependencyProperty(field));
    }

    private boolean definesSchemaProperty(String current, String remaining) {
        boolean hasSuffix;
        current = this.unescape(current);
        boolean bl = hasSuffix = remaining != null;
        if (this.propertySchemas.containsKey(current)) {
            if (hasSuffix) {
                return this.propertySchemas.get(current).definesProperty(remaining);
            }
            return true;
        }
        return false;
    }

    private boolean definesPatternProperty(String current, String remaining) {
        return this.patternProperties.keySet().stream().filter(pattern -> pattern.matcher(current).matches()).map(pattern -> this.patternProperties.get(pattern)).filter(schema -> remaining == null || schema.definesProperty(remaining)).findAny().isPresent();
    }

    private boolean definesSchemaDependencyProperty(String field) {
        return this.schemaDependencies.containsKey(field) || this.schemaDependencies.values().stream().filter(schema -> schema.definesProperty(field)).findAny().isPresent();
    }

    private String unescape(String value) {
        return value.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)o;
            return that.canEqual(this) && this.additionalProperties == that.additionalProperties && this.requiresObject == that.requiresObject && Objects.equals(this.propertySchemas, that.propertySchemas) && Objects.equals(this.schemaOfAdditionalProperties, that.schemaOfAdditionalProperties) && Objects.equals(this.requiredProperties, that.requiredProperties) && Objects.equals(this.minProperties, that.minProperties) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.propertyDependencies, that.propertyDependencies) && Objects.equals(this.schemaDependencies, that.schemaDependencies) && Objects.equals(this.patternProperties, that.patternProperties) && Objects.equals(this.propertyNameSchema, that.propertyNameSchema) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertySchemas, this.propertyNameSchema, this.additionalProperties, this.schemaOfAdditionalProperties, this.requiredProperties, this.minProperties, this.maxProperties, this.propertyDependencies, this.schemaDependencies, this.requiresObject, this.patternProperties);
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresObject) {
            writer.key("type").value("object");
        }
        if (!this.propertySchemas.isEmpty()) {
            writer.key("properties");
            writer.printSchemaMap(this.propertySchemas);
        }
        writer.ifPresent("minProperties", this.minProperties);
        writer.ifPresent("maxProperties", this.maxProperties);
        if (!this.requiredProperties.isEmpty()) {
            writer.key("required").value(this.requiredProperties);
        }
        if (this.schemaOfAdditionalProperties != null) {
            writer.key("additionalProperties");
            this.schemaOfAdditionalProperties.describeTo(writer);
        }
        if (this.propertyNameSchema != null) {
            writer.key("propertyNames");
            this.propertyNameSchema.describeTo(writer);
        }
        if (!this.propertyDependencies.isEmpty()) {
            this.describePropertyDependenciesTo(writer);
        }
        if (!this.schemaDependencies.isEmpty()) {
            writer.key("dependencies");
            writer.printSchemaMap(this.schemaDependencies);
        }
        if (!this.patternProperties.isEmpty()) {
            writer.key("patternProperties");
            writer.printSchemaMap(this.patternProperties);
        }
        writer.ifFalse("additionalProperties", this.additionalProperties);
    }

    private void describePropertyDependenciesTo(JSONPrinter writer) {
        writer.key("dependencies");
        writer.object();
        this.propertyDependencies.entrySet().forEach(entry -> {
            writer.key((String)entry.getKey());
            writer.array();
            ((Set)entry.getValue()).forEach(writer::value);
            writer.endArray();
        });
        writer.endObject();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectSchema;
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private final Map<Pattern, Schema> patternProperties = new HashMap<Pattern, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new HashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();
        private Schema propertyNameSchema;

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull(propName, "propName cannot be null");
            Objects.requireNonNull(schema, "schema cannot be null");
            this.propertySchemas.put(propName, schema);
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder patternProperty(Pattern pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder patternProperty(String pattern, Schema schema) {
            return this.patternProperty(Pattern.compile(pattern), schema);
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new HashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }

        public Builder propertyNameSchema(Schema propertyNameSchema) {
            this.propertyNameSchema = propertyNameSchema;
            return this;
        }
    }
}

