/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONArray;
import org.json.JSONObject;

public class EnumSchema
extends Schema {
    private final Set<Object> possibleValues;

    static Object toJavaValue(Object orig) {
        if (orig instanceof JSONArray) {
            return ((JSONArray)orig).toList();
        }
        if (orig instanceof JSONObject) {
            return ((JSONObject)orig).toMap();
        }
        return orig;
    }

    static Set<Object> toJavaValues(Set<Object> orgJsons) {
        return orgJsons.stream().map(EnumSchema::toJavaValue).collect(Collectors.toSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnumSchema(Builder builder) {
        super(builder);
        this.possibleValues = Collections.unmodifiableSet(EnumSchema.toJavaValues(builder.possibleValues));
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void validate(Object subject) {
        Object effectiveSubject = EnumSchema.toJavaValue(subject);
        this.possibleValues.stream().filter(val -> ObjectComparator.deepEquals(val, effectiveSubject)).findAny().orElseThrow(() -> this.failure(String.format("%s is not a valid enum value", subject), "enum"));
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key("enum");
        writer.array();
        this.possibleValues.forEach(writer::value);
        writer.endArray();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumSchema) {
            EnumSchema that = (EnumSchema)o;
            return that.canEqual(this) && Objects.equals(this.possibleValues, that.possibleValues) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.possibleValues);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumSchema;
    }

    public static class Builder
    extends Schema.Builder<EnumSchema> {
        private Set<Object> possibleValues = new HashSet<Object>();

        @Override
        public EnumSchema build() {
            return new EnumSchema(this);
        }

        public Builder possibleValue(Object possibleValue) {
            this.possibleValues.add(possibleValue);
            return this;
        }

        public Builder possibleValues(Set<Object> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }
    }
}

