/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.json.JSONObject;

public class ConstSchema
extends Schema {
    private final Object permittedValue;

    public static ConstSchemaBuilder builder() {
        return new ConstSchemaBuilder();
    }

    protected ConstSchema(ConstSchemaBuilder builder) {
        super(builder);
        this.permittedValue = EnumSchema.toJavaValue(builder.permittedValue);
    }

    @Override
    public void validate(Object subject) {
        if (this.isNull(subject) && this.isNull(this.permittedValue)) {
            return;
        }
        Object effectiveSubject = EnumSchema.toJavaValue(subject);
        if (!ObjectComparator.deepEquals(effectiveSubject, this.permittedValue)) {
            throw this.failure("", "const");
        }
    }

    private boolean isNull(Object obj) {
        return obj == null || JSONObject.NULL.equals(obj);
    }

    public static class ConstSchemaBuilder
    extends Schema.Builder<ConstSchema> {
        private Object permittedValue;

        public ConstSchemaBuilder permittedValue(Object permittedValue) {
            this.permittedValue = permittedValue;
            return this;
        }

        @Override
        public ConstSchema build() {
            return new ConstSchema(this);
        }
    }
}

