/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Optional;
import org.everit.json.schema.Schema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;

public class ConditionalSchema
extends Schema {
    private final Schema ifSchema;
    private final Schema thenSchema;
    private final Schema elseSchema;

    public static Builder builder() {
        return new Builder();
    }

    public ConditionalSchema(Builder builder) {
        super(builder);
        this.ifSchema = builder.ifSchema;
        this.thenSchema = builder.thenSchema;
        this.elseSchema = builder.elseSchema;
    }

    public Optional<Schema> getIfSchema() {
        return Optional.ofNullable(this.ifSchema);
    }

    public Optional<Schema> getThenSchema() {
        return Optional.ofNullable(this.thenSchema);
    }

    public Optional<Schema> getElseSchema() {
        return Optional.ofNullable(this.elseSchema);
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitConditionalSchema(this);
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.ifSchema != null) {
            writer.key("if");
            this.ifSchema.describeTo(writer);
        }
        if (this.thenSchema != null) {
            writer.key("then");
            this.thenSchema.describeTo(writer);
        }
        if (this.elseSchema != null) {
            writer.key("else");
            this.elseSchema.describeTo(writer);
        }
    }

    public static class Builder
    extends Schema.Builder<ConditionalSchema> {
        private Schema ifSchema;
        private Schema thenSchema;
        private Schema elseSchema;

        public Builder ifSchema(Schema ifSchema) {
            this.ifSchema = ifSchema;
            return this;
        }

        public Builder thenSchema(Schema thenSchema) {
            this.thenSchema = thenSchema;
            return this;
        }

        public Builder elseSchema(Schema elseSchema) {
            this.elseSchema = elseSchema;
            return this;
        }

        @Override
        public ConditionalSchema build() {
            return new ConditionalSchema(this);
        }
    }
}

