/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.V4TestSuiteTest;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Validator;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class TestCase {
    final String schemaDescription;
    final Object schemaJson;
    final String inputDescription;
    final Object inputData;
    final boolean expectedToBeValid;
    private Schema schema;

    private static JSONArray loadTests(InputStream input) {
        try {
            return new JSONArray(new JSONTokener(IOUtils.toString((Reader)new InputStreamReader(input))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static List<Arguments> loadAsParamsFromPackage(String packageName) {
        return TestCase.loadAsParamsFromPackage(packageName, Collections.emptyList());
    }

    static List<Arguments> loadAsParamsFromPackage(String packageName, Collection<String> excludePatterns) {
        ArrayList<Arguments> rval = new ArrayList<Arguments>();
        Reflections refs = new Reflections(packageName, new Scanner[]{new ResourcesScanner()});
        Set paths = refs.getResources(Pattern.compile(".*\\.json"));
        for (String path : paths) {
            if (path.indexOf("/optional/") > -1 || path.indexOf("/remotes/") > -1) continue;
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            if (excludePatterns.stream().anyMatch(fileName::contains)) continue;
            JSONArray arr = TestCase.loadTests(V4TestSuiteTest.class.getResourceAsStream("/" + path));
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject schemaTest = arr.getJSONObject(i);
                JSONArray testcaseInputs = schemaTest.getJSONArray("tests");
                for (int j = 0; j < testcaseInputs.length(); ++j) {
                    JSONObject input = testcaseInputs.getJSONObject(j);
                    TestCase testcase = new TestCase(input, schemaTest, fileName);
                    rval.add(Arguments.of((Object[])new Object[]{testcase, testcase.schemaDescription}));
                }
            }
        }
        return rval;
    }

    private TestCase(JSONObject input, JSONObject schemaTest, String fileName) {
        this.schemaDescription = "[" + fileName + "]/" + schemaTest.getString("description");
        this.schemaJson = schemaTest.get("schema");
        this.inputDescription = "[" + fileName + "]/" + input.getString("description");
        this.expectedToBeValid = input.getBoolean("valid");
        this.inputData = input.get("data");
    }

    public void runTestInEarlyFailureMode() {
        this.testWithValidator(Validator.builder().failEarly().build(), this.schema);
    }

    private void testWithValidator(Validator validator, Schema schema) {
        try {
            validator.performValidation(schema, this.inputData);
            if (!this.expectedToBeValid) {
                throw new AssertionError((Object)("false success for " + this.inputDescription));
            }
        }
        catch (ValidationException e) {
            if (this.expectedToBeValid) {
                throw new AssertionError("false failure for " + this.inputDescription, e);
            }
            TestCase.verifyStacktraces(e);
        }
    }

    private static void verifyStacktraces(ValidationException e) {
        Assertions.assertNotEquals((int)0, (int)e.getStackTrace().length);
        TestCase.assertEmptyCauseStackTraces(e).ifPresent(nonempty -> {
            throw new AssertionError((Object)("non-empty stacktrace: " + (Object)nonempty));
        });
    }

    private static Optional<ValidationException> assertEmptyCauseStackTraces(ValidationException e) {
        return e.getCausingExceptions().stream().filter(exc -> exc.getStackTrace().length > 0).findFirst().map(Optional::of).orElseGet(() -> e.getCausingExceptions().stream().map(TestCase::assertEmptyCauseStackTraces).filter(Optional::isPresent).findFirst().orElse(Optional.empty()));
    }

    public void loadSchema(SchemaLoader.SchemaLoaderBuilder loaderBuilder) {
        try {
            SchemaLoader loader = loaderBuilder.schemaJson(this.schemaJson).build();
            this.schema = loader.load().build();
        }
        catch (SchemaException e) {
            throw new AssertionError("schema loading failure for " + this.schemaDescription, e);
        }
        catch (JSONException e) {
            throw new AssertionError("schema loading error for " + this.schemaDescription, e);
        }
    }

    public void runTestInCollectingMode() {
        this.testWithValidator(Validator.builder().build(), this.schema);
    }

    public String toString() {
        return this.schemaDescription + "/" + this.inputDescription;
    }
}

