/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.JettyWrapper;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.PrimitiveValidationStrategy;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Validator;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.regexp.RE2JRegexpFactory;
import org.everit.json.schema.regexp.RegexpFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class IssueTest {
    private String issueDir;
    private JettyWrapper servletSupport;
    private SchemaLoader.SchemaLoaderBuilder loaderBuilder;
    private final Validator.ValidatorBuilder validatorBuilder = Validator.builder();

    public static List<Arguments> params() {
        ArrayList<Arguments> rval = new ArrayList<Arguments>();
        Reflections refs = new Reflections("org.everit.json.schema.issues", new Scanner[]{new ResourcesScanner()});
        Set paths = refs.getResources(Pattern.compile("schema.json")).stream().map(path -> path.substring(0, path.lastIndexOf(47))).collect(Collectors.toSet());
        for (String path2 : paths) {
            rval.add(Arguments.of((Object[])new Object[]{path2, path2.substring(path2.lastIndexOf(47) + 1)}));
        }
        return rval;
    }

    private Optional<InputStream> fileByName(String fileName) {
        return Optional.ofNullable(this.getClass().getResourceAsStream(this.issueDir + "/" + fileName));
    }

    private void initJetty() {
        try {
            this.servletSupport = new JettyWrapper(this.issueDir + "/remotes");
            this.servletSupport.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject streamAsJson(InputStream file) {
        try {
            return new JSONObject(new JSONTokener(IOUtils.toString((InputStream)file)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Schema loadSchema() {
        Optional<InputStream> schemaFile = this.fileByName("schema.json");
        if (schemaFile.isPresent()) {
            JSONObject schemaObj = IssueTest.streamAsJson(schemaFile.get());
            this.loaderBuilder = SchemaLoader.builder().schemaJson(schemaObj);
            this.consumeValidatorConfig();
            return this.loaderBuilder.build().load().build();
        }
        throw new RuntimeException(this.issueDir + "/schema.json is not found");
    }

    private void consumeValidatorConfig() {
        HashMap<String, Consumer<Object>> configKeyHandlers = new HashMap<String, Consumer<Object>>();
        configKeyHandlers.put("failEarly", value -> {
            if (Boolean.TRUE.equals(value)) {
                this.validatorBuilder.failEarly();
            }
        });
        configKeyHandlers.put("resolutionScope", value -> this.loaderBuilder.resolutionScope((String)value));
        configKeyHandlers.put("regexpImplementation", value -> {
            if (Objects.equals("RE2J", value)) {
                this.loaderBuilder.regexpFactory((RegexpFactory)new RE2JRegexpFactory());
            }
        });
        configKeyHandlers.put("customFormats", value -> {
            JSONObject json = (JSONObject)value;
            OrgJsonUtil.toMap((JSONObject)json).entrySet().forEach(entry -> this.loaderBuilder.addFormatValidator((String)entry.getKey(), this.createFormatValidator((Map.Entry<String, Object>)entry)));
        });
        configKeyHandlers.put("metaSchemaVersion", value -> {
            int versionNo = (Integer)value;
            if (!Arrays.asList(4, 6, 7).contains(versionNo)) {
                throw new IllegalArgumentException("invalid metaSchemaVersion in validator-config.json: should be one of 4, 6, or 7, found: " + versionNo);
            }
            if (versionNo == 6) {
                this.loaderBuilder.draftV6Support();
            } else if (versionNo == 7) {
                this.loaderBuilder.draftV7Support();
            }
        });
        configKeyHandlers.put("schemaClient", value -> {
            if ("classPathAware".equals(value)) {
                this.loaderBuilder.schemaClient(SchemaClient.classPathAwareClient());
            }
        });
        configKeyHandlers.put("enableOverrideOfBuiltInFormatValidators", value -> {
            if (((Boolean)value).booleanValue()) {
                this.loaderBuilder.enableOverrideOfBuiltInFormatValidators();
            }
        });
        configKeyHandlers.put("primitiveParsing", value -> this.validatorBuilder.primitiveValidationStrategy(PrimitiveValidationStrategy.valueOf((String)((String)value))));
        this.fileByName("validator-config.json").map(file -> IssueTest.streamAsJson(file)).ifPresent(configJson -> configKeyHandlers.entrySet().stream().filter(entry -> configJson.has((String)entry.getKey())).forEach(entry -> ((Consumer)entry.getValue()).accept(configJson.get((String)entry.getKey()))));
    }

    private FormatValidator createFormatValidator(Map.Entry<String, Object> entry) {
        String formatClassName = (String)entry.getValue();
        try {
            Class<?> formatClass = Class.forName(formatClassName);
            Constructor<?> ctor = formatClass.getConstructor(new Class[0]);
            return (FormatValidator)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void stopJetty() {
        if (this.servletSupport != null) {
            this.servletSupport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    public void test(String issueDir, String testCaseName) {
        this.issueDir = "/" + Objects.requireNonNull(issueDir, "issueDir cannot be null");
        Assumptions.assumeFalse((boolean)testCaseName.startsWith("x"), (String)"issue dir starts with 'x' - ignoring");
        this.fileByName("remotes").ifPresent(unused -> this.initJetty());
        try {
            Schema schema = this.loadSchema();
            this.fileByName("subject-valid.json").ifPresent(file -> this.validate((InputStream)file, schema, true));
            this.fileByName("subject-invalid.json").ifPresent(file -> this.validate((InputStream)file, schema, false));
        }
        finally {
            this.stopJetty();
        }
    }

    private void validate(InputStream file, Schema schema, boolean shouldBeValid) {
        Optional<InputStream> expectedFile;
        ValidationException thrown = null;
        Object subject = this.loadJsonFile(file);
        try {
            Validator validator = this.validatorBuilder.build();
            validator.performValidation(schema, subject);
        }
        catch (ValidationException e) {
            thrown = e;
        }
        if (shouldBeValid && thrown != null) {
            thrown.getAllMessages().forEach(System.out::println);
            StringBuilder failureBuilder = new StringBuilder("validation failed with: " + (Object)((Object)thrown));
            for (ValidationException e : thrown.getCausingExceptions()) {
                failureBuilder.append("\n\t").append(e.getMessage());
            }
            Assertions.fail((String)failureBuilder.toString());
        }
        if (!shouldBeValid && thrown != null && (expectedFile = this.fileByName("expected-exception.json")).isPresent()) {
            this.checkExpectedValues(expectedFile.get(), thrown);
        }
        if (!shouldBeValid && thrown == null) {
            Assertions.fail((String)"did not throw ValidationException for invalid subject");
        }
    }

    private Object loadJsonFile(InputStream file) {
        Object subject = null;
        try {
            JSONTokener jsonTok = new JSONTokener(IOUtils.toString((InputStream)file));
            Object jsonTest = jsonTok.nextValue();
            if (jsonTest instanceof JSONObject) {
                subject = jsonTest;
            } else if (jsonTest instanceof JSONArray) {
                subject = jsonTest;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("failed to parse subject json file", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return subject;
    }

    private void sortCauses(JSONObject exc) {
        JSONArray causes = exc.optJSONArray("causingExceptions");
        if (causes != null) {
            ArrayList<JSONObject> causesList = new ArrayList<JSONObject>(causes.length());
            for (int i = 0; i < causes.length(); ++i) {
                JSONObject item = causes.getJSONObject(i);
                this.sortCauses(item);
                causesList.add(item);
            }
            causesList.sort(Comparator.comparing(Object::toString));
            exc.put("causingExceptions", (Object)new JSONArray(causesList));
        }
    }

    private void checkExpectedValues(InputStream expectedExceptionsFile, ValidationException ve) {
        JSONObject expected = (JSONObject)this.loadJsonFile(expectedExceptionsFile);
        this.sortCauses(expected);
        JSONObject actual = ve.toJSON();
        this.sortCauses(actual);
        if (!ObjectComparator.deepEquals((Object)actual, (Object)expected)) {
            Assertions.fail((String)("Expected: " + expected.toString(2) + "but was: " + actual.toString(2)));
        }
    }
}

