/*
 * Decompiled with CFR 0.152.
 */
package com.github.euzee.permission;

import com.github.euzee.permission.PermissionCallback;
import com.github.euzee.permission.PermissionDenied;
import com.github.euzee.permission.PermissionGranted;

public class CallbackBuilder {
    private PermissionGranted granted;
    private PermissionDenied denied;
    private int titleId;
    private int messageId;

    public CallbackBuilder onGranted(PermissionGranted call) {
        this.granted = call;
        return this;
    }

    public CallbackBuilder onDenied(PermissionDenied call) {
        this.denied = call;
        return this;
    }

    public CallbackBuilder withRationale(int titleResId, int messageResId) {
        this.titleId = titleResId;
        this.messageId = messageResId;
        return this;
    }

    public PermissionCallback build() {
        return new PermissionCallback(){

            @Override
            public void onPermissionGranted() {
                if (CallbackBuilder.this.granted != null) {
                    CallbackBuilder.this.granted.onPermissionGranted();
                }
            }

            @Override
            public void onPermissionDenied() {
                if (CallbackBuilder.this.denied != null) {
                    CallbackBuilder.this.denied.onPermissionDenied();
                }
            }

            @Override
            public int getRationaleTitleId() {
                return CallbackBuilder.this.titleId;
            }

            @Override
            public int getRationaleMessageId() {
                return CallbackBuilder.this.messageId;
            }
        };
    }
}

