/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.model;

import android.content.ContentUris;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/esafirm/imagepicker/model/Image;", "Landroid/os/Parcelable;", "id", "", "name", "", "path", "(JLjava/lang/String;Ljava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "getPath", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "uriHolder", "getUriHolder$annotations", "()V", "describeContents", "", "equals", "", "other", "", "hashCode", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "imagepicker_release"})
@Parcelize
public final class Image
implements Parcelable {
    private final long id;
    @NotNull
    private final String name;
    @NotNull
    private final String path;
    @Nullable
    private Uri uriHolder;
    @NotNull
    public static final Parcelable.Creator<Image> CREATOR;

    public Image(long id2, @NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.id = id2;
        this.name = name;
        this.path = path;
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    private static /* synthetic */ void getUriHolder$annotations() {
    }

    @NotNull
    public final Uri getUri() {
        Uri uri = this.uriHolder;
        if (uri == null) {
            Uri uri2;
            Image it = this;
            boolean bl = false;
            Uri contentUri = ImagePickerUtils.INSTANCE.isVideoFormat(this) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            Uri it2 = uri2 = ContentUris.withAppendedId((Uri)contentUri, (long)this.id);
            boolean bl2 = false;
            this.uriHolder = it2;
            Uri uri3 = uri2;
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"withAppendedId(contentUr\u2026er = it\n                }");
        }
        return uri;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else {
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            Image image = (Image)other;
            bl = StringsKt.equals((String)image.path, (String)this.path, (boolean)true);
        }
        return bl;
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.path.hashCode();
        Uri uri = this.uriHolder;
        result = 31 * result + (uri != null ? uri.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.id);
        out.writeString(this.name);
        out.writeString(this.path);
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<Image> {
            @NotNull
            public final Image[] newArray(int size) {
                return new Image[size];
            }

            @NotNull
            public final Image createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Image(parcel.readLong(), parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
    }
}

