/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.helper;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/esafirm/imagepicker/helper/LocaleManager;", "", "()V", "language", "", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "normalizeLocale", "Ljava/util/Locale;", "localeLanguage", "updateResources", "Landroid/content/Context;", "context", "imagepicker_release"})
public final class LocaleManager {
    @NotNull
    public static final LocaleManager INSTANCE = new LocaleManager();
    @NotNull
    private static String language;

    private LocaleManager() {
    }

    @NotNull
    public final String getLanguage() {
        return language;
    }

    public final void setLanguage(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        language = string2;
    }

    @NotNull
    public final Context updateResources(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context resultContext = context;
        Locale locale = this.normalizeLocale(new Locale(language));
        Locale.setDefault(locale);
        Resources res = resultContext.getResources();
        Configuration config2 = new Configuration(res.getConfiguration());
        config2.setLocale(locale);
        Context context2 = resultContext.createConfigurationContext(config2);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"resultContext.createConfigurationContext(config)");
        resultContext = context2;
        return resultContext;
    }

    private final Locale normalizeLocale(Locale localeLanguage) {
        Locale locale;
        String ZH = "zh";
        String TW = "TW";
        String CN = "CN";
        Locale locale2 = null;
        String string2 = localeLanguage.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"localeLanguage.toString()");
        String newLocaleLanguage = string2;
        if (newLocaleLanguage.length() == 5) {
            String string3 = newLocaleLanguage.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = newLocaleLanguage.substring(3, 5);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            Locale locale3 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault()");
            String string6 = string5.toUpperCase(locale3);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase(locale)");
            locale = locale2 = new Locale(string3, string6);
        } else {
            locale = Intrinsics.areEqual((Object)newLocaleLanguage, (Object)ZH) ? (locale2 = Intrinsics.areEqual((Object)Locale.getDefault().getCountry(), (Object)TW) ? new Locale(ZH, TW) : new Locale(ZH, CN)) : localeLanguage;
        }
        return locale;
    }

    static {
        String string2 = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
        language = string2;
    }
}

