/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.helper;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.esafirm.imagepicker.features.ImagePickerSavePath;
import com.esafirm.imagepicker.helper.IpLogger;
import com.esafirm.imagepicker.model.Image;
import java.io.File;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0014\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/esafirm/imagepicker/helper/ImagePickerUtils;", "", "()V", "DEFAULT_DURATION_LABEL", "", "createFileInDirectory", "Ljava/io/File;", "savePath", "Lcom/esafirm/imagepicker/features/ImagePickerSavePath;", "context", "Landroid/content/Context;", "createImageFile", "createResultIntent", "Landroid/content/Intent;", "images", "", "Lcom/esafirm/imagepicker/model/Image;", "getExtension", "path", "getNameFromFilePath", "getVideoDurationLabel", "uri", "Landroid/net/Uri;", "grantAppPermission", "", "intent", "fileUri", "isGifFormat", "", "image", "isVideoFormat", "revokeAppPermission", "imagepicker_release"})
public final class ImagePickerUtils {
    @NotNull
    public static final ImagePickerUtils INSTANCE = new ImagePickerUtils();
    @NotNull
    private static final String DEFAULT_DURATION_LABEL = "00:00";

    private ImagePickerUtils() {
    }

    private final File createFileInDirectory(ImagePickerSavePath savePath, Context context) {
        File mediaStorageDir;
        File file;
        String path = savePath.getPath();
        if (savePath.isRelative()) {
            File parent = Build.VERSION.SDK_INT >= 29 ? context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            file = new File(parent, path);
        } else {
            file = mediaStorageDir = new File(path);
        }
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            IpLogger.INSTANCE.d("Oops! Failed create " + path);
            return null;
        }
        return mediaStorageDir;
    }

    @Nullable
    public final File createImageFile(@NotNull ImagePickerSavePath savePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = this.createFileInDirectory(savePath, context);
        if (file == null) {
            return null;
        }
        File mediaStorageDir = file;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS", Locale.getDefault()).format(new Date());
        File result = new File(mediaStorageDir, "IMG_" + timeStamp + ".jpg");
        int counter = 0;
        while (result.exists()) {
            result = new File(mediaStorageDir, "IMG_" + timeStamp + '(' + ++counter + ").jpg");
        }
        return result;
    }

    @NotNull
    public final String getNameFromFilePath(@NotNull String path) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = path;
        String string3 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) {
            String string4 = path;
            CharSequence charSequence2 = path;
            String string5 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
            int n = StringsKt.lastIndexOf$default((CharSequence)charSequence2, (String)string5, (int)0, (boolean)false, (int)6, null) + 1;
            String string6 = string4.substring(n);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string2 = path;
        }
        return string2;
    }

    public final void grantAppPermission(@NotNull Context context, @NotNull Intent intent, @Nullable Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.packageManager\n \u2026nager.MATCH_DEFAULT_ONLY)");
        List resolvedIntentActivities = list;
        for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
            String packageName = resolvedIntentInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, fileUri, 3);
        }
    }

    public final void revokeAppPermission(@NotNull Context context, @Nullable Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.revokeUriPermission(fileUri, 3);
    }

    public final boolean isGifFormat(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.isGifFormat(image.getPath());
    }

    public final boolean isGifFormat(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String extension = this.getExtension(path);
        return StringsKt.equals((String)extension, (String)"gif", (boolean)true);
    }

    public final boolean isVideoFormat(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String extension = this.getExtension(image.getPath());
        String mimeType = TextUtils.isEmpty((CharSequence)extension) ? URLConnection.guessContentTypeFromName(image.getPath()) : MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"video", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getVideoDurationLabel(@Nullable Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            String string2;
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(context, uri);
            String durationData = retriever.extractMetadata(9);
            retriever.release();
            Object object = durationData;
            if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
                return DEFAULT_DURATION_LABEL;
            }
            long duration = (Long)object;
            long second = duration / (long)1000 % (long)60;
            long minute = duration / (long)60000 % (long)60;
            long hour = duration / (long)3600000 % (long)24;
            if (hour > 0L) {
                String string3 = "%02d:%02d:%02d";
                Object[] objectArray = new Object[]{hour, minute, second};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            } else {
                String string5 = "%02d:%02d";
                Object[] objectArray = new Object[]{minute, second};
                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
            }
            return string2;
        }
        catch (Exception e) {
            return DEFAULT_DURATION_LABEL;
        }
    }

    private final String getExtension(String path) {
        String string2;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)path);
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"extension");
            return extension;
        }
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".", (boolean)false, (int)2, null)) {
            String string3 = path.substring(StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null) + 1, path.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final Intent createResultIntent(@Nullable List<Image> images) {
        Intent data = new Intent();
        List<Image> list = images;
        ArrayList imageArrayList = new ArrayList(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        data.putParcelableArrayListExtra("selectedImages", imageArrayList);
        return data;
    }
}

