/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.helper;

import android.content.Context;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.ImagePickerMode;
import com.esafirm.imagepicker.features.ReturnMode;
import com.esafirm.imagepicker.features.cameraonly.CameraOnlyConfig;
import com.esafirm.imagepicker.features.common.BaseConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/esafirm/imagepicker/helper/ConfigUtils;", "", "()V", "checkConfig", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "config", "getDoneButtonText", "", "context", "Landroid/content/Context;", "getFolderTitle", "getImageTitle", "shouldReturn", "", "Lcom/esafirm/imagepicker/features/common/BaseConfig;", "isCamera", "imagepicker_release"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE = new ConfigUtils();

    private ConfigUtils() {
    }

    @NotNull
    public final ImagePickerConfig checkConfig(@NotNull ImagePickerConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (!(config2.getMode() == ImagePickerMode.SINGLE || config2.getReturnMode() != ReturnMode.GALLERY_ONLY && config2.getReturnMode() != ReturnMode.ALL)) {
            boolean bl = false;
            String string2 = "ReturnMode.GALLERY_ONLY and ReturnMode.ALL is only applicable in Single Mode!";
            throw new IllegalStateException(string2.toString());
        }
        return config2;
    }

    public final boolean shouldReturn(@NotNull BaseConfig config2, boolean isCamera) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (config2 instanceof CameraOnlyConfig) {
            return true;
        }
        ReturnMode mode = config2.getReturnMode();
        return isCamera ? mode == ReturnMode.ALL || mode == ReturnMode.CAMERA_ONLY : mode == ReturnMode.ALL || mode == ReturnMode.GALLERY_ONLY;
    }

    @NotNull
    public final String getFolderTitle(@NotNull Context context, @NotNull ImagePickerConfig config2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String folderTitle = config2.getFolderTitle();
        CharSequence charSequence = folderTitle;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string3 = context.getString(R.string.ef_title_folder);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.ef_title_folder)");
        } else {
            string2 = folderTitle;
        }
        return string2;
    }

    @NotNull
    public final String getImageTitle(@NotNull Context context, @NotNull ImagePickerConfig config2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String configImageTitle = config2.getImageTitle();
        CharSequence charSequence = configImageTitle;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string3 = context.getString(R.string.ef_title_select_image);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.ef_title_select_image)");
        } else {
            string2 = configImageTitle;
        }
        return string2;
    }

    @NotNull
    public final String getDoneButtonText(@NotNull Context context, @NotNull ImagePickerConfig config2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String doneButtonText = config2.getDoneButtonText();
        CharSequence charSequence = doneButtonText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string3 = context.getString(R.string.ef_done);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.ef_done)");
        } else {
            string2 = doneButtonText;
        }
        return string2;
    }
}

