/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features.recyclers;

import android.content.Context;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.adapter.FolderPickerAdapter;
import com.esafirm.imagepicker.adapter.ImagePickerAdapter;
import com.esafirm.imagepicker.features.ImagePickerComponentsHolder;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.ImagePickerMode;
import com.esafirm.imagepicker.features.ReturnMode;
import com.esafirm.imagepicker.features.imageloader.ImageLoader;
import com.esafirm.imagepicker.helper.ConfigUtils;
import com.esafirm.imagepicker.model.Folder;
import com.esafirm.imagepicker.model.Image;
import com.esafirm.imagepicker.view.GridSpacingItemDecoration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010+\u001a\u00020*H\u0002J\u0006\u0010,\u001a\u00020\u0016J\u0010\u0010-\u001a\u00020*2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011J\u000e\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0016J\u0016\u00100\u001a\u00020*2\u000e\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010!J\u0016\u00103\u001a\u00020*2\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u00020\"0!J$\u00105\u001a\u00020*2\u001c\u00106\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0012\u0004\u0012\u00020*07j\u0002`8J\u0010\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020\u0007H\u0002JF\u0010;\u001a\u00020*2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001607j\u0002`>2\u0016\u0010?\u001a\u0012\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020*07j\u0002`@R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006A"}, d2={"Lcom/esafirm/imagepicker/features/recyclers/RecyclerViewManager;", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "config", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "orientation", "", "(Landroidx/recyclerview/widget/RecyclerView;Lcom/esafirm/imagepicker/features/ImagePickerConfig;I)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "folderAdapter", "Lcom/esafirm/imagepicker/adapter/FolderPickerAdapter;", "folderColumns", "foldersState", "Landroid/os/Parcelable;", "imageAdapter", "Lcom/esafirm/imagepicker/adapter/ImagePickerAdapter;", "imageColumns", "isDisplayingFolderView", "", "()Z", "isShowDoneButton", "itemOffsetDecoration", "Lcom/esafirm/imagepicker/view/GridSpacingItemDecoration;", "layoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "recyclerState", "getRecyclerState", "()Landroid/os/Parcelable;", "selectedImages", "", "Lcom/esafirm/imagepicker/model/Image;", "getSelectedImages", "()Ljava/util/List;", "title", "", "getTitle", "()Ljava/lang/String;", "changeOrientation", "", "checkAdapterIsInitialized", "handleBack", "onRestoreState", "selectImage", "isSelected", "setFolderAdapter", "folders", "Lcom/esafirm/imagepicker/model/Folder;", "setImageAdapter", "images", "setImageSelectedListener", "listener", "Lkotlin/Function1;", "Lcom/esafirm/imagepicker/listeners/OnImageSelectedListener;", "setItemDecoration", "columns", "setupAdapters", "passedSelectedImage", "onImageClick", "Lcom/esafirm/imagepicker/listeners/OnImageClickListener;", "onFolderClick", "Lcom/esafirm/imagepicker/listeners/OnFolderClickListener;", "imagepicker_release"})
public final class RecyclerViewManager {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final ImagePickerConfig config;
    @Nullable
    private GridLayoutManager layoutManager;
    @Nullable
    private GridSpacingItemDecoration itemOffsetDecoration;
    private ImagePickerAdapter imageAdapter;
    private FolderPickerAdapter folderAdapter;
    @Nullable
    private Parcelable foldersState;
    private int imageColumns;
    private int folderColumns;

    public RecyclerViewManager(@NotNull RecyclerView recyclerView, @NotNull ImagePickerConfig config2, int orientation) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.recyclerView = recyclerView;
        this.config = config2;
        this.changeOrientation(orientation);
    }

    private final Context getContext() {
        Context context = this.recyclerView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"recyclerView.context");
        return context;
    }

    public final void onRestoreState(@Nullable Parcelable recyclerState) {
        GridLayoutManager gridLayoutManager = this.layoutManager;
        Intrinsics.checkNotNull((Object)gridLayoutManager);
        gridLayoutManager.onRestoreInstanceState(recyclerState);
    }

    @Nullable
    public final Parcelable getRecyclerState() {
        GridLayoutManager gridLayoutManager = this.layoutManager;
        Intrinsics.checkNotNull((Object)gridLayoutManager);
        return gridLayoutManager.onSaveInstanceState();
    }

    public final void changeOrientation(int orientation) {
        this.imageColumns = orientation == 1 ? 3 : 5;
        this.folderColumns = orientation == 1 ? 2 : 4;
        boolean shouldShowFolder = this.config.isFolderMode() && this.isDisplayingFolderView();
        int columns = shouldShowFolder ? this.folderColumns : this.imageColumns;
        this.layoutManager = new GridLayoutManager(this.getContext(), columns);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setHasFixedSize(true);
        this.setItemDecoration(columns);
    }

    public final void setupAdapters(@Nullable List<Image> passedSelectedImage, @NotNull Function1<? super Boolean, Boolean> onImageClick, @NotNull Function1<? super Folder, Unit> onFolderClick) {
        Intrinsics.checkNotNullParameter(onImageClick, (String)"onImageClick");
        Intrinsics.checkNotNullParameter(onFolderClick, (String)"onFolderClick");
        boolean isSingleMode = this.config.getMode() == ImagePickerMode.SINGLE;
        boolean isSelectedNotEmpty = passedSelectedImage != null && passedSelectedImage.size() > 1;
        List selectedImages = isSingleMode && isSelectedNotEmpty ? CollectionsKt.emptyList() : passedSelectedImage;
        ImageLoader imageLoader2 = ImagePickerComponentsHolder.INSTANCE.getImageLoader();
        Context context = this.getContext();
        List list = selectedImages;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.imageAdapter = new ImagePickerAdapter(context, imageLoader2, list, onImageClick);
        this.folderAdapter = new FolderPickerAdapter(this.getContext(), imageLoader2, (Function1<? super Folder, Unit>)((Function1)new Function1<Folder, Unit>(this, onFolderClick){
            final /* synthetic */ RecyclerViewManager this$0;
            final /* synthetic */ Function1<Folder, Unit> $onFolderClick;
            {
                this.this$0 = $receiver;
                this.$onFolderClick = $onFolderClick;
                super(1);
            }

            public final void invoke(@NotNull Folder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RecyclerView.LayoutManager layoutManager = RecyclerViewManager.access$getRecyclerView$p(this.this$0).getLayoutManager();
                RecyclerViewManager.access$setFoldersState$p(this.this$0, (Parcelable)(layoutManager != null ? layoutManager.onSaveInstanceState() : null));
                this.$onFolderClick.invoke((Object)it);
            }
        }));
    }

    private final void setItemDecoration(int columns) {
        GridSpacingItemDecoration newItemDecoration;
        GridSpacingItemDecoration currentDecoration = this.itemOffsetDecoration;
        if (currentDecoration != null) {
            this.recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)currentDecoration);
        }
        this.itemOffsetDecoration = newItemDecoration = new GridSpacingItemDecoration(columns, this.getContext().getResources().getDimensionPixelSize(R.dimen.ef_item_padding), false);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)newItemDecoration);
        GridLayoutManager gridLayoutManager = this.layoutManager;
        if (gridLayoutManager != null) {
            gridLayoutManager.setSpanCount(columns);
        }
    }

    public final boolean handleBack() {
        if (this.config.isFolderMode() && !this.isDisplayingFolderView()) {
            this.setFolderAdapter(null);
            ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
            if (imagePickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                imagePickerAdapter = null;
            }
            imagePickerAdapter.setData(CollectionsKt.emptyList());
            return true;
        }
        return false;
    }

    private final boolean isDisplayingFolderView() {
        return this.recyclerView.getAdapter() == null || this.recyclerView.getAdapter() instanceof FolderPickerAdapter;
    }

    @NotNull
    public final String getTitle() {
        String string2;
        boolean useDefaultTitle;
        if (this.isDisplayingFolderView()) {
            return ConfigUtils.INSTANCE.getFolderTitle(this.getContext(), this.config);
        }
        if (this.config.getMode() == ImagePickerMode.SINGLE) {
            return ConfigUtils.INSTANCE.getImageTitle(this.getContext(), this.config);
        }
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        int imageSize = imagePickerAdapter.getSelectedImages().size();
        CharSequence charSequence = this.config.getImageTitle();
        boolean bl = useDefaultTitle = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && imageSize == 0;
        if (useDefaultTitle) {
            return ConfigUtils.INSTANCE.getImageTitle(this.getContext(), this.config);
        }
        if (this.config.getLimit() == 999) {
            String string3 = this.getContext().getString(R.string.ef_selected);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.ef_selected)");
            String string4 = string3;
            Object[] objectArray = new Object[]{imageSize};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        } else {
            String string6 = this.getContext().getString(R.string.ef_selected_with_limit);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.string.ef_selected_with_limit)");
            String string7 = string6;
            Object[] objectArray = new Object[]{imageSize, this.config.getLimit()};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(format, *args)");
        }
        return string2;
    }

    public final void setImageAdapter(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        imagePickerAdapter.setData(images);
        this.setItemDecoration(this.imageColumns);
        ImagePickerAdapter imagePickerAdapter2 = this.imageAdapter;
        if (imagePickerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter2 = null;
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)imagePickerAdapter2);
    }

    public static /* synthetic */ void setImageAdapter$default(RecyclerViewManager recyclerViewManager, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        recyclerViewManager.setImageAdapter(list);
    }

    public final void setFolderAdapter(@Nullable List<Folder> folders) {
        FolderPickerAdapter folderPickerAdapter = this.folderAdapter;
        if (folderPickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderAdapter");
            folderPickerAdapter = null;
        }
        folderPickerAdapter.setData(folders);
        this.setItemDecoration(this.folderColumns);
        FolderPickerAdapter folderPickerAdapter2 = this.folderAdapter;
        if (folderPickerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderAdapter");
            folderPickerAdapter2 = null;
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)folderPickerAdapter2);
        if (this.foldersState != null) {
            GridLayoutManager gridLayoutManager = this.layoutManager;
            Intrinsics.checkNotNull((Object)gridLayoutManager);
            gridLayoutManager.setSpanCount(this.folderColumns);
            RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
            Intrinsics.checkNotNull((Object)layoutManager);
            layoutManager.onRestoreInstanceState(this.foldersState);
        }
    }

    private final void checkAdapterIsInitialized() {
        if (this.imageAdapter == null) {
            throw new IllegalStateException("Must call setupAdapters first!".toString());
        }
    }

    @NotNull
    public final List<Image> getSelectedImages() {
        this.checkAdapterIsInitialized();
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        return imagePickerAdapter.getSelectedImages();
    }

    public final void setImageSelectedListener(@NotNull Function1<? super List<Image>, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.checkAdapterIsInitialized();
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        imagePickerAdapter.setImageSelectedListener(listener);
    }

    public final boolean selectImage(boolean isSelected) {
        if (this.config.getMode() == ImagePickerMode.MULTIPLE) {
            ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
            if (imagePickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                imagePickerAdapter = null;
            }
            if (imagePickerAdapter.getSelectedImages().size() >= this.config.getLimit() && !isSelected) {
                Toast.makeText((Context)this.getContext(), (int)R.string.ef_msg_limit_images, (int)0).show();
                return false;
            }
        } else if (this.config.getMode() == ImagePickerMode.SINGLE) {
            ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
            if (imagePickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                imagePickerAdapter = null;
            }
            if (imagePickerAdapter.getSelectedImages().size() > 0) {
                ImagePickerAdapter imagePickerAdapter2 = this.imageAdapter;
                if (imagePickerAdapter2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                    imagePickerAdapter2 = null;
                }
                imagePickerAdapter2.removeAllSelectedSingleClick();
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isShowDoneButton() {
        if (this.isDisplayingFolderView()) return false;
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        if (!(!((Collection)imagePickerAdapter.getSelectedImages()).isEmpty())) {
            if (!this.config.getShowDoneButtonAlways()) return false;
        }
        if (this.config.getReturnMode() == ReturnMode.ALL) return false;
        if (this.config.getReturnMode() == ReturnMode.GALLERY_ONLY) return false;
        return true;
    }

    public static final /* synthetic */ void access$setFoldersState$p(RecyclerViewManager $this, Parcelable parcelable) {
        $this.foldersState = parcelable;
    }

    public static final /* synthetic */ RecyclerView access$getRecyclerView$p(RecyclerViewManager $this) {
        return $this.recyclerView;
    }
}

