/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.features.ImagePickerAction;
import com.esafirm.imagepicker.features.ImagePickerComponentsHolder;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.ImagePickerPresenter;
import com.esafirm.imagepicker.features.ImagePickerState;
import com.esafirm.imagepicker.features.camera.CameraModule;
import com.esafirm.imagepicker.features.common.BaseConfig;
import com.esafirm.imagepicker.features.common.ImageLoaderListener;
import com.esafirm.imagepicker.features.fileloader.DefaultImageFileLoader;
import com.esafirm.imagepicker.helper.ConfigUtils;
import com.esafirm.imagepicker.helper.state.LiveDataObservableState;
import com.esafirm.imagepicker.helper.state.ObservableState;
import com.esafirm.imagepicker.helper.state.SingleEvent;
import com.esafirm.imagepicker.helper.state.SingleEventKt;
import com.esafirm.imagepicker.model.Folder;
import com.esafirm.imagepicker.model.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\u00020\u000b2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u001cJ!\u0010!\u001a\u00020\u000b2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0#\u00a2\u0006\u0002\b$H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/esafirm/imagepicker/features/ImagePickerPresenter;", "Lcom/esafirm/imagepicker/features/ImagePickerAction;", "imageLoader", "Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader;", "(Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader;)V", "cameraModule", "Lcom/esafirm/imagepicker/features/camera/CameraModule;", "stateObs", "Lcom/esafirm/imagepicker/helper/state/LiveDataObservableState;", "Lcom/esafirm/imagepicker/features/ImagePickerState;", "abortCaptureImage", "", "context", "Landroid/content/Context;", "abortLoad", "captureImage", "fragment", "Landroidx/fragment/app/Fragment;", "config", "Lcom/esafirm/imagepicker/features/common/BaseConfig;", "requestCode", "", "finishCaptureImage", "data", "Landroid/content/Intent;", "getUiState", "Lcom/esafirm/imagepicker/helper/state/ObservableState;", "loadData", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "onDoneSelectImages", "selectedImages", "", "Lcom/esafirm/imagepicker/model/Image;", "setState", "newState", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "imagepicker_release"})
public final class ImagePickerPresenter
implements ImagePickerAction {
    @NotNull
    private final DefaultImageFileLoader imageLoader;
    @NotNull
    private final CameraModule cameraModule;
    @NotNull
    private final LiveDataObservableState<ImagePickerState> stateObs;

    public ImagePickerPresenter(@NotNull DefaultImageFileLoader imageLoader2) {
        Intrinsics.checkNotNullParameter((Object)imageLoader2, (String)"imageLoader");
        this.imageLoader = imageLoader2;
        this.cameraModule = ImagePickerComponentsHolder.INSTANCE.getCameraModule();
        this.stateObs = new LiveDataObservableState<ImagePickerState>(new ImagePickerState(null, null, null, true, null, null, null, 119, null), true);
    }

    private final void setState(Function1<? super ImagePickerState, ImagePickerState> newState) {
        this.stateObs.set((ImagePickerState)newState.invoke((Object)this.stateObs.get()));
    }

    public final void abortLoad() {
        this.imageLoader.abortLoadImages();
    }

    @Override
    @NotNull
    public ObservableState<ImagePickerState> getUiState() {
        return this.stateObs;
    }

    @Override
    public void loadData(@NotNull ImagePickerConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.imageLoader.abortLoadImages();
        this.imageLoader.loadDeviceImages(config2, new ImageLoaderListener(this, config2){
            final /* synthetic */ ImagePickerPresenter this$0;
            final /* synthetic */ ImagePickerConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
            }

            public void onImageLoaded(@NotNull List<Image> images, @NotNull List<Folder> folders) {
                Intrinsics.checkNotNullParameter(images, (String)"images");
                Intrinsics.checkNotNullParameter(folders, (String)"folders");
                ImagePickerPresenter.access$setState(this.this$0, (Function1)new Function1<ImagePickerState, ImagePickerState>(this.$config, images, folders){
                    final /* synthetic */ ImagePickerConfig $config;
                    final /* synthetic */ List<Image> $images;
                    final /* synthetic */ List<Folder> $folders;
                    {
                        this.$config = $config;
                        this.$images = $images;
                        this.$folders = $folders;
                        super(1);
                    }

                    @NotNull
                    public final ImagePickerState invoke(@NotNull ImagePickerState $this$setState) {
                        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                        SingleEvent<Boolean> singleEvent = SingleEventKt.asSingleEvent(this.$config.isFolderMode());
                        return new ImagePickerState(this.$images, this.$folders, singleEvent, false, null, null, null, 112, null);
                    }
                });
            }

            public void onFailed(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                ImagePickerPresenter.access$setState(this.this$0, (Function1)new Function1<ImagePickerState, ImagePickerState>(throwable){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = $throwable;
                        super(1);
                    }

                    @NotNull
                    public final ImagePickerState invoke(@NotNull ImagePickerState $this$setState) {
                        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                        return new ImagePickerState(null, null, null, false, SingleEventKt.asSingleEvent(this.$throwable), null, null, 111, null);
                    }
                });
            }
        });
    }

    public final void onDoneSelectImages(@Nullable List<Image> selectedImages, @NotNull ImagePickerConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (config2.getShowDoneButtonAlways()) {
            List<Image> list = selectedImages;
            boolean bl = list != null ? list.size() == 0 : false;
            if (bl) {
                this.setState((Function1<? super ImagePickerState, ImagePickerState>)((Function1)onDoneSelectImages.1.INSTANCE));
            }
        }
        if (selectedImages == null || selectedImages.isEmpty()) {
            return;
        }
        this.setState((Function1<? super ImagePickerState, ImagePickerState>)((Function1)new Function1<ImagePickerState, ImagePickerState>(selectedImages){
            final /* synthetic */ List<Image> $selectedImages;
            {
                this.$selectedImages = $selectedImages;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ImagePickerState invoke(@NotNull ImagePickerState $this$setState) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                Iterable iterable = this.$selectedImages;
                SingleEvent singleEvent = null;
                boolean bl = false;
                SingleEvent singleEvent2 = null;
                List list = null;
                List list2 = null;
                ImagePickerState imagePickerState = $this$setState;
                boolean $i$f$filter = false;
                void var4_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Image it = (Image)element$iv$iv;
                    boolean bl2 = false;
                    File file = new File(it.getPath());
                    if (!file.exists()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                return ImagePickerState.copy$default(imagePickerState, list2, list, singleEvent2, bl, singleEvent, SingleEventKt.asSingleEvent(list3), null, 95, null);
            }
        }));
    }

    public final void captureImage(@NotNull Fragment fragment, @NotNull BaseConfig config2, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Context context = fragment.requireContext().getApplicationContext();
        Context context2 = fragment.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"fragment.requireContext()");
        Intent intent = this.cameraModule.getCameraIntent(context2, config2);
        if (intent == null) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.ef_error_create_image_file), (int)1).show();
            return;
        }
        fragment.startActivityForResult(intent, requestCode);
    }

    public final void finishCaptureImage(@NotNull Context context, @Nullable Intent data, @Nullable BaseConfig config2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.cameraModule.getImage(context, data, (Function1<? super List<Image>, Unit>)((Function1)new Function1<List<? extends Image>, Unit>(config2, this){
            final /* synthetic */ BaseConfig $config;
            final /* synthetic */ ImagePickerPresenter this$0;
            {
                this.$config = $config;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable List<Image> images) {
                BaseConfig baseConfig = this.$config;
                Intrinsics.checkNotNull((Object)baseConfig);
                if (ConfigUtils.INSTANCE.shouldReturn(baseConfig, true)) {
                    ImagePickerPresenter.access$setState(this.this$0, (Function1)new Function1<ImagePickerState, ImagePickerState>(images){
                        final /* synthetic */ List<Image> $images;
                        {
                            this.$images = $images;
                            super(1);
                        }

                        @NotNull
                        public final ImagePickerState invoke(@NotNull ImagePickerState $this$setState) {
                            Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                            List list = this.$images;
                            if (list == null) {
                                list = CollectionsKt.emptyList();
                            }
                            return ImagePickerState.copy$default($this$setState, null, null, null, false, null, SingleEventKt.asSingleEvent(list), null, 95, null);
                        }
                    });
                } else {
                    ImagePickerPresenter.access$setState(this.this$0, finishCaptureImage.2.INSTANCE);
                }
            }
        }));
    }

    public final void abortCaptureImage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.cameraModule.removeImage(context);
    }

    public static final /* synthetic */ void access$setState(ImagePickerPresenter $this, Function1 newState) {
        $this.setState((Function1<? super ImagePickerState, ImagePickerState>)newState);
    }
}

