/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.features.ImagePickerComponentsHolder;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.ImagePickerFragment;
import com.esafirm.imagepicker.features.ImagePickerInteractionListener;
import com.esafirm.imagepicker.features.camera.CameraModule;
import com.esafirm.imagepicker.features.cameraonly.CameraOnlyConfig;
import com.esafirm.imagepicker.helper.ConfigUtils;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import com.esafirm.imagepicker.helper.IpCrasher;
import com.esafirm.imagepicker.helper.LocaleManager;
import com.esafirm.imagepicker.helper.ViewUtils;
import com.esafirm.imagepicker.model.Image;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001eH\u0016J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u0012\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010/\u001a\u00020\u001e2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u000101H\u0016J\u0012\u00103\u001a\u00020\u001e2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0015\u0010\u0017R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/esafirm/imagepicker/features/ImagePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/esafirm/imagepicker/features/ImagePickerInteractionListener;", "()V", "actionBar", "Landroidx/appcompat/app/ActionBar;", "cameraModule", "Lcom/esafirm/imagepicker/features/camera/CameraModule;", "cameraOnlyConfig", "Lcom/esafirm/imagepicker/features/cameraonly/CameraOnlyConfig;", "getCameraOnlyConfig", "()Lcom/esafirm/imagepicker/features/cameraonly/CameraOnlyConfig;", "cameraOnlyConfig$delegate", "Lkotlin/Lazy;", "config", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "getConfig", "()Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "config$delegate", "imagePickerFragment", "Lcom/esafirm/imagepicker/features/ImagePickerFragment;", "isCameraOnly", "", "()Z", "isCameraOnly$delegate", "startForCameraResult", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "cancel", "finishPickImages", "result", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPrepareOptionsMenu", "selectionChanged", "imageList", "", "Lcom/esafirm/imagepicker/model/Image;", "setTitle", "title", "", "setupView", "imagepicker_release"})
public final class ImagePickerActivity
extends AppCompatActivity
implements ImagePickerInteractionListener {
    @NotNull
    private final CameraModule cameraModule;
    @Nullable
    private ActionBar actionBar;
    private ImagePickerFragment imagePickerFragment;
    @NotNull
    private final Lazy config$delegate;
    @NotNull
    private final Lazy cameraOnlyConfig$delegate;
    @NotNull
    private final Lazy isCameraOnly$delegate;
    @NotNull
    private final ActivityResultLauncher<Intent> startForCameraResult;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();

    public ImagePickerActivity() {
        this.cameraModule = ImagePickerComponentsHolder.INSTANCE.getCameraModule();
        this.config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImagePickerConfig>(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ImagePickerConfig invoke() {
                Bundle bundle = this.this$0.getIntent().getExtras();
                Intrinsics.checkNotNull((Object)bundle);
                return (ImagePickerConfig)bundle.getParcelable(ImagePickerConfig.class.getSimpleName());
            }
        }));
        this.cameraOnlyConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CameraOnlyConfig>(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CameraOnlyConfig invoke() {
                Bundle bundle = this.this$0.getIntent().getExtras();
                return bundle != null ? (CameraOnlyConfig)bundle.getParcelable(CameraOnlyConfig.class.getSimpleName()) : null;
            }
        }));
        this.isCameraOnly$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ImagePickerActivity.access$getCameraOnlyConfig(this.this$0) != null;
            }
        }));
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> ImagePickerActivity.startForCameraResult$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026        }\n        }\n    }");
        this.startForCameraResult = activityResultLauncher;
    }

    private final ImagePickerConfig getConfig() {
        Lazy lazy = this.config$delegate;
        return (ImagePickerConfig)lazy.getValue();
    }

    private final CameraOnlyConfig getCameraOnlyConfig() {
        Lazy lazy = this.cameraOnlyConfig$delegate;
        return (CameraOnlyConfig)lazy.getValue();
    }

    private final boolean isCameraOnly() {
        Lazy lazy = this.isCameraOnly$delegate;
        return (Boolean)lazy.getValue();
    }

    protected void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        super.attachBaseContext(LocaleManager.INSTANCE.updateResources(newBase));
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setResult(0);
        Intent intent = this.getIntent();
        if (intent == null || intent.getExtras() == null) {
            IpCrasher.openIssue();
            throw new KotlinNothingValueException();
        }
        if (this.isCameraOnly()) {
            Context context = (Context)this;
            CameraOnlyConfig cameraOnlyConfig2 = this.getCameraOnlyConfig();
            Intrinsics.checkNotNull((Object)cameraOnlyConfig2);
            Intent cameraIntent = this.cameraModule.getCameraIntent(context, cameraOnlyConfig2);
            this.startForCameraResult.launch((Object)cameraIntent);
            return;
        }
        ImagePickerConfig imagePickerConfig = this.getConfig();
        Intrinsics.checkNotNull((Object)imagePickerConfig);
        ImagePickerConfig currentConfig = imagePickerConfig;
        this.setTheme(currentConfig.getTheme());
        this.setContentView(R.layout.ef_activity_image_picker);
        this.setupView(currentConfig);
        if (savedInstanceState != null) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.ef_imagepicker_fragment_placeholder);
            if (fragment == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.esafirm.imagepicker.features.ImagePickerFragment");
            }
            this.imagePickerFragment = (ImagePickerFragment)fragment;
        } else {
            this.imagePickerFragment = ImagePickerFragment.Companion.newInstance(currentConfig);
            FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
            FragmentTransaction ft = fragmentTransaction;
            ImagePickerFragment imagePickerFragment = this.imagePickerFragment;
            if (imagePickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imagePickerFragment");
                imagePickerFragment = null;
            }
            ft.replace(R.id.ef_imagepicker_fragment_placeholder, (Fragment)imagePickerFragment);
            ft.commit();
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.ef_image_picker_menu_main, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        if (!this.isCameraOnly()) {
            MenuItem menuItem;
            ImagePickerConfig imagePickerConfig = this.getConfig();
            menu2.findItem(R.id.menu_camera).setVisible(imagePickerConfig != null ? imagePickerConfig.isShowCamera() : true);
            MenuItem $this$onPrepareOptionsMenu_u24lambda_u2d1 = menuItem = menu2.findItem(R.id.menu_done);
            boolean bl = false;
            Context context = (Context)this;
            ImagePickerConfig imagePickerConfig2 = this.getConfig();
            Intrinsics.checkNotNull((Object)imagePickerConfig2);
            $this$onPrepareOptionsMenu_u24lambda_u2d1.setTitle((CharSequence)ConfigUtils.INSTANCE.getDoneButtonText(context, imagePickerConfig2));
            ImagePickerFragment imagePickerFragment = this.imagePickerFragment;
            if (imagePickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imagePickerFragment");
                imagePickerFragment = null;
            }
            $this$onPrepareOptionsMenu_u24lambda_u2d1.setVisible(imagePickerFragment.isShowDoneButton());
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menu_done) {
            ImagePickerFragment imagePickerFragment = this.imagePickerFragment;
            if (imagePickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imagePickerFragment");
                imagePickerFragment = null;
            }
            imagePickerFragment.onDone();
            return true;
        }
        if (id2 == R.id.menu_camera) {
            ImagePickerFragment imagePickerFragment = this.imagePickerFragment;
            if (imagePickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imagePickerFragment");
                imagePickerFragment = null;
            }
            imagePickerFragment.captureImage();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (this.imagePickerFragment != null) {
            ImagePickerFragment imagePickerFragment = this.imagePickerFragment;
            if (imagePickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imagePickerFragment");
                imagePickerFragment = null;
            }
            if (!imagePickerFragment.handleBack()) {
                super.onBackPressed();
            }
        } else {
            super.onBackPressed();
        }
    }

    private final void setupView(ImagePickerConfig config2) {
        block1: {
            Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
            this.setSupportActionBar(toolbar);
            ActionBar actionBar = this.actionBar = this.getSupportActionBar();
            if (actionBar == null) break block1;
            ActionBar $this$setupView_u24lambda_u2d2 = actionBar;
            boolean bl = false;
            Drawable arrowDrawable = ViewUtils.INSTANCE.getArrowIcon((Context)this);
            int arrowColor = config2.getArrowColor();
            if (arrowColor != -1 && arrowDrawable != null) {
                arrowDrawable.setColorFilter(arrowColor, PorterDuff.Mode.SRC_ATOP);
            }
            $this$setupView_u24lambda_u2d2.setDisplayHomeAsUpEnabled(true);
            $this$setupView_u24lambda_u2d2.setHomeAsUpIndicator(arrowDrawable);
            $this$setupView_u24lambda_u2d2.setDisplayShowTitleEnabled(true);
        }
    }

    @Override
    public void setTitle(@Nullable String title) {
        ActionBar actionBar = this.actionBar;
        if (actionBar != null) {
            actionBar.setTitle((CharSequence)title);
        }
        this.invalidateOptionsMenu();
    }

    @Override
    public void cancel() {
        this.finish();
    }

    @Override
    public void selectionChanged(@Nullable List<Image> imageList) {
    }

    @Override
    public void finishPickImages(@Nullable Intent result) {
        this.setResult(-1, result);
        this.finish();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void startForCameraResult$lambda-0(ImagePickerActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int resultCode = result.getResultCode();
        if (resultCode == 0) {
            this$0.cameraModule.removeImage((Context)this$0);
            this$0.setResult(0);
            this$0.finish();
            return;
        }
        if (resultCode == -1) {
            this$0.cameraModule.getImage((Context)this$0, result.getData(), (Function1<? super List<Image>, Unit>)((Function1)new Function1<List<? extends Image>, Unit>(this$0){
                final /* synthetic */ ImagePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable List<Image> images) {
                    Intent resultIntent = ImagePickerUtils.INSTANCE.createResultIntent(images);
                    this.this$0.finishPickImages(resultIntent);
                }
            }));
        }
    }

    public static final /* synthetic */ CameraOnlyConfig access$getCameraOnlyConfig(ImagePickerActivity $this) {
        return $this.getCameraOnlyConfig();
    }
}

