/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.adapter.BaseListAdapter;
import com.esafirm.imagepicker.features.imageloader.ImageLoader;
import com.esafirm.imagepicker.features.imageloader.ImageType;
import com.esafirm.imagepicker.model.Folder;
import com.esafirm.imagepicker.model.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0016\u0010\u0018\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0019R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/esafirm/imagepicker/adapter/FolderPickerAdapter;", "Lcom/esafirm/imagepicker/adapter/BaseListAdapter;", "Lcom/esafirm/imagepicker/adapter/FolderPickerAdapter$FolderViewHolder;", "context", "Landroid/content/Context;", "imageLoader", "Lcom/esafirm/imagepicker/features/imageloader/ImageLoader;", "folderClickListener", "Lkotlin/Function1;", "Lcom/esafirm/imagepicker/model/Folder;", "", "Lcom/esafirm/imagepicker/listeners/OnFolderClickListener;", "(Landroid/content/Context;Lcom/esafirm/imagepicker/features/imageloader/ImageLoader;Lkotlin/jvm/functions/Function1;)V", "folders", "", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "", "FolderViewHolder", "imagepicker_release"})
public final class FolderPickerAdapter
extends BaseListAdapter<FolderViewHolder> {
    @NotNull
    private final Function1<Folder, Unit> folderClickListener;
    @NotNull
    private final List<Folder> folders;

    public FolderPickerAdapter(@NotNull Context context, @NotNull ImageLoader imageLoader2, @NotNull Function1<? super Folder, Unit> folderClickListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageLoader2, (String)"imageLoader");
        Intrinsics.checkNotNullParameter(folderClickListener, (String)"folderClickListener");
        super(context, imageLoader2);
        this.folderClickListener = folderClickListener;
        this.folders = new ArrayList();
    }

    @NotNull
    public FolderViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View layout2 = this.getInflater().inflate(R.layout.ef_imagepicker_item_folder, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)layout2, (String)"layout");
        return new FolderViewHolder(layout2);
    }

    public void onBindViewHolder(@NotNull FolderViewHolder holder, int position) {
        FolderViewHolder folderViewHolder;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Folder folder = (Folder)CollectionsKt.getOrNull(this.folders, (int)position);
        if (folder == null) {
            return;
        }
        Folder folder2 = folder;
        this.getImageLoader().loadImage((Image)CollectionsKt.first(folder2.getImages()), holder.getImage(), ImageType.FOLDER);
        FolderViewHolder $this$onBindViewHolder_u24lambda_u2d1 = folderViewHolder = holder;
        boolean bl = false;
        $this$onBindViewHolder_u24lambda_u2d1.getName().setText((CharSequence)folder2.getFolderName());
        $this$onBindViewHolder_u24lambda_u2d1.getNumber().setText((CharSequence)String.valueOf(folder2.getImages().size()));
        $this$onBindViewHolder_u24lambda_u2d1.itemView.setOnClickListener(arg_0 -> FolderPickerAdapter.onBindViewHolder$lambda-1$lambda-0(this, folder2, arg_0));
    }

    public final void setData(@Nullable List<Folder> folders) {
        List<Folder> list = folders;
        if (list != null) {
            List<Folder> it = list;
            boolean bl = false;
            this.folders.clear();
            this.folders.addAll((Collection<Folder>)folders);
        }
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.folders.size();
    }

    private static final void onBindViewHolder$lambda-1$lambda-0(FolderPickerAdapter this$0, Folder $folder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$folder, (String)"$folder");
        this$0.folderClickListener.invoke((Object)$folder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/esafirm/imagepicker/adapter/FolderPickerAdapter$FolderViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "image", "Landroid/widget/ImageView;", "getImage", "()Landroid/widget/ImageView;", "name", "Landroid/widget/TextView;", "getName", "()Landroid/widget/TextView;", "number", "getNumber", "imagepicker_release"})
    public static final class FolderViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView image;
        @NotNull
        private final TextView name;
        @NotNull
        private final TextView number;

        public FolderViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            ImageView imageView = (ImageView)itemView.findViewById(R.id.image);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"itemView.image");
            this.image = imageView;
            TextView textView = (TextView)itemView.findViewById(R.id.tv_name);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"itemView.tv_name");
            this.name = textView;
            TextView textView2 = (TextView)itemView.findViewById(R.id.tv_number);
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"itemView.tv_number");
            this.number = textView2;
        }

        @NotNull
        public final ImageView getImage() {
            return this.image;
        }

        @NotNull
        public final TextView getName() {
            return this.name;
        }

        @NotNull
        public final TextView getNumber() {
            return this.number;
        }
    }
}

