/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java8.util.Objects;
import java8.util.Optional;
import java8.util.function.Consumer;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$1;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$10;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$11;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$12;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$13;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$14;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$15;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$16;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$17;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$18;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$19;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$2;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$20;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$21;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$22;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$23;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$24;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$25;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$3;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$4;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$5;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$6;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$7;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$8;
import org.everit.json.schema.loader.ObjectSchemaLoader$$Lambda$9;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.regexp.Regexp;

class ObjectSchemaLoader {
    private final LoadingState ls;
    private final LoaderConfig config;
    private final SchemaLoader defaultLoader;

    public ObjectSchemaLoader(LoadingState ls, LoaderConfig config, SchemaLoader defaultLoader) {
        this.ls = (LoadingState)Objects.requireNonNull((Object)ls, (String)"ls cannot be null");
        this.config = (LoaderConfig)Objects.requireNonNull((Object)config, (String)"config cannot be null");
        this.defaultLoader = (SchemaLoader)Objects.requireNonNull((Object)defaultLoader, (String)"defaultLoader cannot be null");
    }

    ObjectSchema.Builder load() {
        ObjectSchema.Builder builder = ObjectSchema.builder();
        Optional optional = this.ls.schemaJson().maybe("minProperties").map(ObjectSchemaLoader$$Lambda$1.lambdaFactory$());
        ObjectSchema.Builder builder2 = builder;
        builder2.getClass();
        optional.ifPresent(ObjectSchemaLoader$$Lambda$2.lambdaFactory$(builder2));
        Optional optional2 = this.ls.schemaJson().maybe("maxProperties").map(ObjectSchemaLoader$$Lambda$3.lambdaFactory$());
        ObjectSchema.Builder builder3 = builder;
        builder3.getClass();
        optional2.ifPresent(ObjectSchemaLoader$$Lambda$4.lambdaFactory$(builder3));
        this.ls.schemaJson().maybe("properties").map(ObjectSchemaLoader$$Lambda$5.lambdaFactory$()).ifPresent(ObjectSchemaLoader$$Lambda$6.lambdaFactory$(this, builder));
        this.ls.schemaJson().maybe("additionalProperties").ifPresent(ObjectSchemaLoader$$Lambda$7.lambdaFactory$(this, builder));
        this.ls.schemaJson().maybe("required").map(ObjectSchemaLoader$$Lambda$8.lambdaFactory$()).ifPresent(ObjectSchemaLoader$$Lambda$9.lambdaFactory$(builder));
        this.ls.schemaJson().maybe("patternProperties").map(ObjectSchemaLoader$$Lambda$10.lambdaFactory$()).ifPresent(ObjectSchemaLoader$$Lambda$11.lambdaFactory$(this, builder));
        this.ls.schemaJson().maybe("dependencies").map(ObjectSchemaLoader$$Lambda$12.lambdaFactory$()).ifPresent(ObjectSchemaLoader$$Lambda$13.lambdaFactory$(this, builder));
        if (this.ls.specVersion().isAtLeast(SpecificationVersion.DRAFT_6)) {
            Optional<JsonValue> optional3 = this.ls.schemaJson().maybe("propertyNames");
            SchemaLoader schemaLoader = this.defaultLoader;
            schemaLoader.getClass();
            Optional optional4 = optional3.map(ObjectSchemaLoader$$Lambda$14.lambdaFactory$(schemaLoader)).map(ObjectSchemaLoader$$Lambda$15.lambdaFactory$());
            ObjectSchema.Builder builder4 = builder;
            builder4.getClass();
            optional4.ifPresent(ObjectSchemaLoader$$Lambda$16.lambdaFactory$(builder4));
        }
        return builder;
    }

    private void populatePropertySchemas(JsonObject propertyDefs, ObjectSchema.Builder builder) {
        propertyDefs.forEach(ObjectSchemaLoader$$Lambda$17.lambdaFactory$(this, builder));
    }

    private void addPropertySchemaDefinition(String keyOfObj, JsonValue definition, ObjectSchema.Builder builder) {
        builder.addPropertySchema(keyOfObj, (Schema)this.defaultLoader.loadChild(definition).build());
    }

    private void addDependencies(ObjectSchema.Builder builder, JsonObject deps) {
        deps.forEach(ObjectSchemaLoader$$Lambda$18.lambdaFactory$(this, builder));
    }

    private void addDependency(ObjectSchema.Builder builder, String ifPresent, JsonValue deps) {
        deps.canBeSchema((Consumer<JsonValue>)ObjectSchemaLoader$$Lambda$19.lambdaFactory$(this, builder, ifPresent)).or(JsonArray.class, ObjectSchemaLoader$$Lambda$20.lambdaFactory$(builder, ifPresent)).requireAny();
    }

    static /* synthetic */ void lambda$addDependency$13(ObjectSchema.Builder builder, String ifPresent, JsonArray arr) {
        arr.forEach(ObjectSchemaLoader$$Lambda$21.lambdaFactory$(builder, ifPresent));
    }

    static /* synthetic */ void lambda$null$12(ObjectSchema.Builder builder, String ifPresent, int i, JsonValue entry) {
        builder.propertyDependency(ifPresent, entry.requireString());
    }

    static /* synthetic */ void lambda$addDependency$11(ObjectSchemaLoader this_, ObjectSchema.Builder builder, String ifPresent, JsonValue obj) {
        builder.schemaDependency(ifPresent, (Schema)this_.defaultLoader.loadChild(obj).build());
    }

    static /* synthetic */ void lambda$addDependencies$10(ObjectSchemaLoader this_, ObjectSchema.Builder builder, String ifPresent, JsonValue mustBePresent) {
        this_.addDependency(builder, ifPresent, mustBePresent);
    }

    static /* synthetic */ void lambda$populatePropertySchemas$9(ObjectSchemaLoader this_, ObjectSchema.Builder builder, String key, JsonValue value) {
        if (!key.equals(this_.ls.specVersion().idKeyword()) || value instanceof JsonObject) {
            this_.addPropertySchemaDefinition(key, value, builder);
        }
    }

    static /* synthetic */ void lambda$load$8(ObjectSchemaLoader this_, ObjectSchema.Builder builder, JsonObject deps) {
        this_.addDependencies(builder, deps);
    }

    static /* synthetic */ void lambda$load$7(ObjectSchemaLoader this_, ObjectSchema.Builder builder, JsonObject patternProps) {
        patternProps.keySet().forEach(ObjectSchemaLoader$$Lambda$22.lambdaFactory$(this_, patternProps, builder));
    }

    static /* synthetic */ void lambda$null$6(ObjectSchemaLoader this_, JsonObject patternProps, ObjectSchema.Builder builder, String pattern) {
        Object patternSchema = this_.defaultLoader.loadChild(patternProps.require(pattern)).build();
        Regexp regexp = this_.ls.config.regexpFactory.createHandler(pattern);
        builder.patternProperty(regexp, (Schema)patternSchema);
    }

    static /* synthetic */ void lambda$load$5(ObjectSchema.Builder builder, JsonArray arr) {
        arr.forEach(ObjectSchemaLoader$$Lambda$23.lambdaFactory$(builder));
    }

    static /* synthetic */ void lambda$null$4(ObjectSchema.Builder builder, int i, JsonValue val) {
        builder.addRequiredProperty(val.requireString());
    }

    static /* synthetic */ void lambda$load$3(ObjectSchemaLoader this_, ObjectSchema.Builder builder, JsonValue rawAddProps) {
        rawAddProps.canBe(Boolean.class, ObjectSchemaLoader$$Lambda$24.lambdaFactory$(builder)).or(JsonObject.class, ObjectSchemaLoader$$Lambda$25.lambdaFactory$(this_, builder)).requireAny();
    }

    static /* synthetic */ void lambda$null$2(ObjectSchemaLoader this_, ObjectSchema.Builder builder, JsonObject def) {
        builder.schemaOfAdditionalProperties((Schema)this_.defaultLoader.loadChild(def).build());
    }

    static /* synthetic */ void lambda$null$1(ObjectSchema.Builder builder, Boolean p) {
        builder.additionalProperties(p);
    }

    static /* synthetic */ void lambda$load$0(ObjectSchemaLoader this_, ObjectSchema.Builder builder, JsonObject propertyDefs) {
        this_.populatePropertySchemas(propertyDefs, builder);
    }
}

