/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Supplier;
import java8.util.Objects;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.combatibility.UncheckedIOException;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonPointerEvaluator$$Lambda$1;
import org.everit.json.schema.loader.JsonPointerEvaluator$$Lambda$2;
import org.everit.json.schema.loader.JsonPointerEvaluator$$Lambda$3;
import org.everit.json.schema.loader.JsonPointerEvaluator$$Lambda$4;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONPointerException;
import org.json.JSONTokener;

class JsonPointerEvaluator {
    private final Supplier<JsonObject> documentProvider;
    private final String fragment;

    private static JsonObject executeWith(SchemaClient client, String url) {
        String resp = null;
        BufferedReader buffReader = null;
        InputStreamReader reader = null;
        try {
            String line;
            InputStream responseStream = client.get(url);
            reader = new InputStreamReader(responseStream, Charset.defaultCharset());
            buffReader = new BufferedReader(reader);
            StringBuilder strBuilder = new StringBuilder();
            while ((line = buffReader.readLine()) != null) {
                strBuilder.append(line);
            }
            resp = strBuilder.toString();
            JsonObject jsonObject = new JsonObject(new JSONObject(new JSONTokener(resp)).toMap());
            return jsonObject;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (JSONException e) {
            throw new SchemaException("failed to parse " + resp, e);
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static final JsonPointerEvaluator forDocument(JsonObject document, String fragment) {
        return new JsonPointerEvaluator(JsonPointerEvaluator$$Lambda$1.lambdaFactory$(document), fragment);
    }

    private static JsonObject configureBasedOnState(JsonObject obj, LoadingState callingState) {
        obj.ls = new LoadingState(callingState.config, callingState.pointerSchemas, obj, obj, null, Collections.<String>emptyList());
        return obj;
    }

    static final JsonPointerEvaluator forURL(SchemaClient schemaClient, String url, LoadingState callingState) {
        String fragment;
        String toBeQueried;
        int poundIdx = url.indexOf(35);
        if (poundIdx == -1) {
            toBeQueried = url;
            fragment = "";
        } else {
            fragment = url.substring(poundIdx);
            toBeQueried = url.substring(0, poundIdx);
        }
        return new JsonPointerEvaluator(JsonPointerEvaluator$$Lambda$2.lambdaFactory$(schemaClient, toBeQueried, callingState), fragment);
    }

    JsonPointerEvaluator(Supplier<JsonObject> documentProvider, String fragment) {
        this.documentProvider = documentProvider;
        this.fragment = fragment;
    }

    public QueryResult query() {
        JsonObject document = this.documentProvider.get();
        if (this.fragment.isEmpty()) {
            return new QueryResult(document, document);
        }
        String[] path = this.fragment.split("/");
        if (path[0] == null || !path[0].startsWith("#")) {
            throw new IllegalArgumentException("JSON pointers must start with a '#'");
        }
        try {
            LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(path));
            tokens.poll();
            JsonValue result = tokens.isEmpty() ? document : this.queryFrom(document, tokens);
            return new QueryResult(document, result);
        }
        catch (JSONPointerException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    private String unescape(String token) {
        try {
            return URLDecoder.decode(token, "utf-8").replace("~1", "/").replace("~0", "~").replace("\\\"", "\"").replace("\\\\", "\\");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonValue queryFrom(JsonValue document, LinkedList<String> tokens) {
        String key = this.unescape(tokens.poll());
        JsonValue next = (JsonValue)document.canBeMappedTo(JsonObject.class, JsonPointerEvaluator$$Lambda$3.lambdaFactory$(key)).orMappedTo(JsonArray.class, JsonPointerEvaluator$$Lambda$4.lambdaFactory$(key)).requireAny();
        if (tokens.isEmpty()) {
            return next;
        }
        return this.queryFrom(next, tokens);
    }

    static /* synthetic */ JsonValue lambda$queryFrom$3(String key, JsonArray arr) {
        return arr.at(Integer.parseInt(key));
    }

    static /* synthetic */ JsonValue lambda$queryFrom$2(String key, JsonObject obj) {
        return obj.childFor(key);
    }

    static /* synthetic */ JsonObject lambda$forURL$1(SchemaClient schemaClient, String toBeQueried, LoadingState callingState) {
        return JsonPointerEvaluator.configureBasedOnState(JsonPointerEvaluator.executeWith(schemaClient, toBeQueried), callingState);
    }

    static /* synthetic */ JsonObject lambda$forDocument$0(JsonObject document) {
        return document;
    }

    static class QueryResult {
        private final JsonObject containingDocument;
        private final JsonValue queryResult;

        QueryResult(JsonObject containingDocument, JsonValue queryResult) {
            this.containingDocument = (JsonObject)Objects.requireNonNull((Object)containingDocument, (String)"containingDocument cannot be null");
            this.queryResult = (JsonValue)Objects.requireNonNull((Object)queryResult, (String)"queryResult cannot be null");
        }

        public JsonObject getContainingDocument() {
            return this.containingDocument;
        }

        public JsonValue getQueryResult() {
            return this.queryResult;
        }
    }
}

