/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.io.StringWriter;
import java8.util.Objects;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.ValidatorBuilder;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;

public abstract class Schema {
    private final String title;
    private final String description;
    private final String id;
    protected final String schemaLocation;
    private final Object defaultValue;
    private final Boolean nullable;
    private final Boolean readOnly;
    private final Boolean writeOnly;

    protected Schema(Builder<?> builder) {
        this.title = ((Builder)builder).title;
        this.description = ((Builder)builder).description;
        this.id = ((Builder)builder).id;
        this.schemaLocation = ((Builder)builder).schemaLocation;
        this.defaultValue = ((Builder)builder).defaultValue;
        this.nullable = ((Builder)builder).nullable;
        this.readOnly = ((Builder)builder).readOnly;
        this.writeOnly = ((Builder)builder).writeOnly;
    }

    public void validate(Object subject) {
        ValidatorBuilder.builder().build().performValidation(this, subject);
    }

    public boolean definesProperty(String field) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Schema) {
            Schema schema = (Schema)o;
            return schema.canEqual(this) && Objects.equals((Object)this.title, (Object)schema.title) && Objects.equals((Object)this.defaultValue, (Object)schema.defaultValue) && Objects.equals((Object)this.description, (Object)schema.description) && Objects.equals((Object)this.id, (Object)schema.id) && Objects.equals((Object)this.nullable, (Object)schema.nullable) && Objects.equals((Object)this.readOnly, (Object)schema.readOnly) && Objects.equals((Object)this.writeOnly, (Object)schema.writeOnly);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.title, this.description, this.id, this.defaultValue, this.nullable, this.readOnly, this.writeOnly});
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public Boolean isWriteOnly() {
        return this.writeOnly;
    }

    public void describeTo(JSONPrinter writer) {
        writer.object();
        writer.ifPresent("title", this.title);
        writer.ifPresent("description", this.description);
        writer.ifPresent("id", this.id);
        writer.ifPresent("default", this.defaultValue);
        writer.ifPresent("nullable", this.nullable);
        writer.ifPresent("readOnly", this.readOnly);
        writer.ifPresent("writeOnly", this.writeOnly);
        this.describePropertiesTo(writer);
        writer.endObject();
    }

    void describePropertiesTo(JSONPrinter writer) {
    }

    abstract void accept(Visitor var1);

    public String toString() {
        StringWriter w = new StringWriter();
        this.describeTo(new JSONPrinter(w));
        return w.getBuffer().toString();
    }

    @Deprecated
    protected ValidationException failure(String message, String keyword) {
        return new ValidationException(this, message, keyword, this.schemaLocation);
    }

    @Deprecated
    protected ValidationException failure(Class<?> expectedType, Object actualValue) {
        return new ValidationException(this, expectedType, actualValue, "type", this.schemaLocation);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public static abstract class Builder<S extends Schema> {
        private String title;
        private String description;
        private String id;
        private String schemaLocation;
        private Object defaultValue;
        private Boolean nullable = null;
        private Boolean readOnly = null;
        private Boolean writeOnly = null;

        public Builder<S> title(String title) {
            this.title = title;
            return this;
        }

        public Builder<S> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<S> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<S> schemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public Builder<S> defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<S> nullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder<S> readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder<S> writeOnly(Boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this;
        }

        public abstract S build();
    }
}

