/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render.internal;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.jiangdg.ausbc.R;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.render.internal.AbstractFboRender;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0007H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0006\u0010\u001a\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jiangdg/ausbc/render/internal/CameraRender;", "Lcom/jiangdg/ausbc/render/internal/AbstractFboRender;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mStMatrixHandle", "", "mMVPMatrixHandle", "mStMatrix", "", "mMVPMatrix", "mOESTextureId", "init", "", "beforeDraw", "getBindTextureType", "getVertexSourceId", "getFragmentSourceId", "setRotateAngle", "type", "Lcom/jiangdg/ausbc/render/env/RotateType;", "setTransformMatrix", "matrix", "setMVPMatrix", "angle", "getCameraTextureId", "Companion", "libausbc_release"})
public final class CameraRender
extends AbstractFboRender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mStMatrixHandle;
    private int mMVPMatrixHandle;
    @NotNull
    private float[] mStMatrix;
    @NotNull
    private float[] mMVPMatrix;
    private int mOESTextureId;
    @NotNull
    private static final String TAG = "CameraRender";

    public CameraRender(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mStMatrixHandle = -1;
        this.mMVPMatrixHandle = -1;
        this.mStMatrix = new float[16];
        this.mMVPMatrix = new float[16];
        this.mOESTextureId = -1;
    }

    @Override
    protected void init() {
        this.mOESTextureId = this.createOESTexture();
        this.setMVPMatrix(0);
        Matrix.setIdentityM((float[])this.mStMatrix, (int)0);
        this.mStMatrixHandle = GLES20.glGetUniformLocation((int)this.getMProgram(), (String)"uStMatrix");
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.getMProgram(), (String)"uMVPMatrix");
    }

    @Override
    protected void beforeDraw() {
        GLES20.glUniformMatrix4fv((int)this.mMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mStMatrixHandle, (int)1, (boolean)false, (float[])this.mStMatrix, (int)0);
    }

    @Override
    protected int getBindTextureType() {
        return 36197;
    }

    @Override
    protected int getVertexSourceId() {
        return R.raw.camera_vertex;
    }

    @Override
    protected int getFragmentSourceId() {
        return R.raw.camera_fragment;
    }

    public final void setRotateAngle(@NotNull RotateType type) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            case 4: {
                n = -90;
                break;
            }
            case 5: {
                n = -180;
                break;
            }
            default: {
                n = 0;
            }
        }
        int angle = n;
        this.setMVPMatrix(angle);
    }

    public final void setTransformMatrix(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.mStMatrix = matrix;
    }

    private final float[] setMVPMatrix(int angle) {
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        switch (angle) {
            case -90: {
                float radius = (float)Math.PI;
                float[] fArray = this.mMVPMatrix;
                fArray[5] = fArray[5] * (float)Math.cos(radius);
                fArray = this.mMVPMatrix;
                fArray[6] = fArray[6] + (float)(-Math.sin(radius));
                fArray = this.mMVPMatrix;
                fArray[9] = fArray[9] + (float)Math.sin(radius);
                fArray = this.mMVPMatrix;
                fArray[10] = fArray[10] * (float)Math.cos(radius);
                break;
            }
            case -180: {
                float radius = (float)Math.PI;
                float[] fArray = this.mMVPMatrix;
                fArray[0] = fArray[0] * (float)Math.cos(radius);
                fArray = this.mMVPMatrix;
                fArray[2] = fArray[2] + (float)Math.sin(radius);
                fArray = this.mMVPMatrix;
                fArray[8] = fArray[8] + (float)(-Math.sin(radius));
                fArray = this.mMVPMatrix;
                fArray[10] = fArray[10] * (float)Math.cos(radius);
                break;
            }
            default: {
                float radius = (float)((double)angle * Math.PI / 180.0);
                float[] fArray = this.mMVPMatrix;
                fArray[0] = fArray[0] * (float)Math.cos(radius);
                fArray = this.mMVPMatrix;
                fArray[1] = fArray[1] + (float)(-Math.sin(radius));
                fArray = this.mMVPMatrix;
                fArray[4] = fArray[4] + (float)Math.sin(radius);
                fArray = this.mMVPMatrix;
                fArray[5] = fArray[5] * (float)Math.cos(radius);
            }
        }
        return this.mMVPMatrix;
    }

    public final int getCameraTextureId() {
        return this.mOESTextureId;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/render/internal/CameraRender$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RotateType.values().length];
            try {
                nArray[RotateType.ANGLE_90.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RotateType.ANGLE_180.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RotateType.ANGLE_270.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RotateType.FLIP_UP_DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RotateType.FLIP_LEFT_RIGHT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

