/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.provider.MediaStore;
import android.view.Surface;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.render.internal.CameraRender;
import com.jiangdg.ausbc.render.internal.CaptureRender;
import com.jiangdg.ausbc.render.internal.EncodeRender;
import com.jiangdg.ausbc.render.internal.ScreenRender;
import com.jiangdg.ausbc.utils.GLBitmapUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.utils.bus.EventBus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 v2\u00020\u00012\u00020\u0002:\u0002uvB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u0006H\u0002J,\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u00062\b\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010XJ\u0006\u0010Y\u001a\u00020PJ\u001e\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020V2\u0006\u0010\\\u001a\u00020\u00062\u0006\u0010]\u001a\u00020\u0006J\u0006\u0010^\u001a\u00020PJ\u0016\u0010_\u001a\u00020P2\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u0006J\u0010\u0010`\u001a\u00020P2\b\u0010a\u001a\u0004\u0018\u00010)J\u0010\u0010b\u001a\u00020P2\b\u0010a\u001a\u0004\u0018\u00010)J\u0010\u0010c\u001a\u00020P2\b\u0010d\u001a\u0004\u0018\u00010eJ\u0016\u0010f\u001a\u0012\u0012\u0004\u0012\u00020)0(j\b\u0012\u0004\u0012\u00020)`*J\u001a\u0010g\u001a\u00020P2\b\u0010h\u001a\u0004\u0018\u00010-2\b\u0010i\u001a\u0004\u0018\u00010GJ\u0012\u0010j\u001a\u00020P2\b\u0010k\u001a\u0004\u0018\u00010 H\u0016J \u0010l\u001a\u00020P2\u0006\u0010m\u001a\u00020V2\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u0006H\u0002J\u0018\u0010n\u001a\u00020P2\u0006\u0010o\u001a\u00020\u00062\u0006\u0010p\u001a\u000200H\u0002J\b\u0010q\u001a\u00020PH\u0002J\u0012\u0010r\u001a\u00020P2\b\u0010s\u001a\u0004\u0018\u00010GH\u0002J\b\u0010t\u001a\u00020PH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00020)0(j\b\u0012\u0004\u0012\u00020)`*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u0004\u0012\u00020)0(j\b\u0012\u0004\u0012\u00020)`*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u00102\u001a\b\u0012\u0004\u0012\u00020 038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b4\u00105R\u001b\u00108\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u00107\u001a\u0004\b9\u0010:R\u001b\u0010<\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u00107\u001a\u0004\b>\u0010?R\u001b\u0010A\u001a\u00020B8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u00107\u001a\u0004\bC\u0010DR\u001b\u0010F\u001a\u00020G8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u00107\u001a\u0004\bH\u0010I\u00a8\u0006w"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Landroid/os/Handler$Callback;", "context", "Landroid/content/Context;", "surfaceWidth", "", "surfaceHeight", "mPreviewDataCbList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "<init>", "(Landroid/content/Context;IILjava/util/concurrent/CopyOnWriteArrayList;)V", "mPreviewByteBuffer", "Ljava/nio/ByteBuffer;", "mEOSTextureId", "Ljava/lang/Integer;", "mRenderThread", "Landroid/os/HandlerThread;", "mRenderHandler", "Landroid/os/Handler;", "mRenderCodecThread", "mRenderCodecHandler", "mCameraRender", "Lcom/jiangdg/ausbc/render/internal/CameraRender;", "mScreenRender", "Lcom/jiangdg/ausbc/render/internal/ScreenRender;", "mEncodeRender", "Lcom/jiangdg/ausbc/render/internal/EncodeRender;", "mCaptureRender", "Lcom/jiangdg/ausbc/render/internal/CaptureRender;", "mCameraSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mTransformMatrix", "", "mWidth", "mHeight", "mFBOBufferId", "mContext", "mEffectList", "Ljava/util/ArrayList;", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "Lkotlin/collections/ArrayList;", "mCacheEffectList", "mCaptureDataCb", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "mFrameRate", "mEndTime", "", "mStartTime", "mStFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "getMStFuture", "()Lcom/jiangdg/ausbc/utils/SettableFuture;", "mStFuture$delegate", "Lkotlin/Lazy;", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "mCaptureState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMCaptureState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mCaptureState$delegate", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "handleMessage", "", "msg", "Landroid/os/Message;", "drawFrame2Capture", "", "fboId", "startRenderScreen", "w", "h", "outSurface", "Landroid/view/Surface;", "listener", "Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "stopRenderScreen", "startRenderCodec", "inputSurface", "width", "height", "stopRenderCodec", "setRenderSize", "addRenderEffect", "effect", "removeRenderEffect", "setRotateType", "type", "Lcom/jiangdg/ausbc/render/env/RotateType;", "getCacheEffectList", "saveImage", "callBack", "path", "onFrameAvailable", "surfaceTexture", "startRenderCodecInternal", "surface", "drawFrame2Codec", "textureId", "timeStamps", "stopRenderCodecInternal", "saveImageInternal", "savePath", "emitFrameRate", "CameraSurfaceTextureListener", "Companion", "libausbc_release"})
@SourceDebugExtension(value={"SMAP\nRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderManager.kt\ncom/jiangdg/ausbc/render/RenderManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,534:1\n1#2:535\n1863#3,2:536\n1863#3,2:538\n1863#3,2:540\n*S KotlinDebug\n*F\n+ 1 RenderManager.kt\ncom/jiangdg/ausbc/render/RenderManager\n*L\n168#1:536,2\n204#1:538,2\n227#1:540,2\n*E\n"})
public final class RenderManager
implements SurfaceTexture.OnFrameAvailableListener,
Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int surfaceWidth;
    private final int surfaceHeight;
    @Nullable
    private final CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList;
    @Nullable
    private ByteBuffer mPreviewByteBuffer;
    @Nullable
    private Integer mEOSTextureId;
    @Nullable
    private HandlerThread mRenderThread;
    @Nullable
    private Handler mRenderHandler;
    @Nullable
    private HandlerThread mRenderCodecThread;
    @Nullable
    private Handler mRenderCodecHandler;
    @Nullable
    private CameraRender mCameraRender;
    @Nullable
    private ScreenRender mScreenRender;
    @Nullable
    private EncodeRender mEncodeRender;
    @Nullable
    private CaptureRender mCaptureRender;
    @Nullable
    private SurfaceTexture mCameraSurfaceTexture;
    @NotNull
    private float[] mTransformMatrix;
    private int mWidth;
    private int mHeight;
    private int mFBOBufferId;
    @NotNull
    private Context mContext;
    @NotNull
    private ArrayList<AbstractEffect> mEffectList;
    @NotNull
    private ArrayList<AbstractEffect> mCacheEffectList;
    @Nullable
    private ICaptureCallBack mCaptureDataCb;
    private int mFrameRate;
    private long mEndTime;
    private long mStartTime;
    @NotNull
    private final Lazy mStFuture$delegate;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private final Lazy mCaptureState$delegate;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private static final String TAG = "RenderManager";
    @NotNull
    private static final String RENDER_THREAD = "gl_render";
    @NotNull
    private static final String RENDER_CODEC_THREAD = "gl_render_codec";
    private static final int MSG_GL_INIT = 0;
    private static final int MSG_GL_DRAW = 1;
    private static final int MSG_GL_RELEASE = 2;
    private static final int MSG_GL_START_RENDER_CODEC = 3;
    private static final int MSG_GL_STOP_RENDER_CODEC = 4;
    private static final int MSG_GL_CHANGED_SIZE = 5;
    private static final int MSG_GL_ADD_EFFECT = 6;
    private static final int MSG_GL_REMOVE_EFFECT = 7;
    private static final int MSG_GL_SAVE_IMAGE = 8;
    private static final int MSG_GL_ROUTE_ANGLE = 9;
    private static final int MSG_GL_RENDER_CODEC_INIT = 17;
    private static final int MSG_GL_RENDER_CODEC_CHANGED_SIZE = 18;
    private static final int MSG_GL_RENDER_CODEC_DRAW = 19;
    private static final int MSG_GL_RENDER_CODEC_RELEASE = 20;

    public RenderManager(@NotNull Context context, int surfaceWidth, int surfaceHeight, @Nullable CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.surfaceWidth = surfaceWidth;
        this.surfaceHeight = surfaceHeight;
        this.mPreviewDataCbList = mPreviewDataCbList;
        this.mTransformMatrix = new float[16];
        this.mContext = context;
        this.mEffectList = new ArrayList();
        this.mCacheEffectList = new ArrayList();
        this.mStartTime = System.currentTimeMillis();
        this.mStFuture$delegate = LazyKt.lazy(RenderManager::mStFuture_delegate$lambda$0);
        this.mMainHandler$delegate = LazyKt.lazy(RenderManager::mMainHandler_delegate$lambda$1);
        this.mCaptureState$delegate = LazyKt.lazy(RenderManager::mCaptureState_delegate$lambda$2);
        this.mDateFormat$delegate = LazyKt.lazy(RenderManager::mDateFormat_delegate$lambda$3);
        this.mCameraDir$delegate = LazyKt.lazy(RenderManager::mCameraDir_delegate$lambda$4);
        this.mCameraRender = new CameraRender(context);
        this.mScreenRender = new ScreenRender(context);
        this.mCaptureRender = new CaptureRender(context);
        Logger.INSTANCE.i(TAG, "create RenderManager, Open ES version is " + Utils.INSTANCE.getGLESVersion(context));
    }

    public /* synthetic */ RenderManager(Context context, int n, int n2, CopyOnWriteArrayList copyOnWriteArrayList, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            copyOnWriteArrayList = null;
        }
        this(context, n, n2, copyOnWriteArrayList);
    }

    private final SettableFuture<SurfaceTexture> getMStFuture() {
        Lazy lazy = this.mStFuture$delegate;
        return (SettableFuture)lazy.getValue();
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    private final AtomicBoolean getMCaptureState() {
        Lazy lazy = this.mCaptureState$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    private final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 0: {
                Integer n;
                Triple triple;
                Object object = msg.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                Triple $this$handleMessage_u24lambda_u246 = triple = (Triple)object;
                boolean bl = false;
                Object object2 = $this$handleMessage_u24lambda_u246.getFirst();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int w = (Integer)object2;
                Object object3 = $this$handleMessage_u24lambda_u246.getSecond();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                int h = (Integer)object3;
                Object object4 = $this$handleMessage_u24lambda_u246.getThird();
                Surface surface = object4 instanceof Surface ? (Surface)object4 : null;
                ScreenRender screenRender = this.mScreenRender;
                if (screenRender != null) {
                    screenRender.initEGLEvn();
                }
                ScreenRender screenRender2 = this.mScreenRender;
                if (screenRender2 != null) {
                    screenRender2.setupSurface(surface, w, h);
                }
                ScreenRender screenRender3 = this.mScreenRender;
                if (screenRender3 != null) {
                    screenRender3.initGLES();
                }
                CameraRender cameraRender = this.mCameraRender;
                if (cameraRender != null) {
                    cameraRender.initGLES();
                }
                CaptureRender captureRender = this.mCaptureRender;
                if (captureRender != null) {
                    captureRender.initGLES();
                }
                RenderManager renderManager = this;
                CameraRender cameraRender2 = this.mCameraRender;
                if (cameraRender2 != null) {
                    void $this$handleMessage_u24lambda_u246_u24lambda_u245;
                    Integer n2 = cameraRender2.getCameraTextureId();
                    int n3 = ((Number)n2).intValue();
                    RenderManager renderManager2 = renderManager;
                    boolean bl2 = false;
                    this.getMStFuture().set(new SurfaceTexture((int)$this$handleMessage_u24lambda_u246_u24lambda_u245));
                    renderManager = renderManager2;
                    n = n2;
                } else {
                    n = null;
                }
                renderManager.mEOSTextureId = n;
                EventBus.INSTANCE.with("render-ready").postMessage(true);
                break;
            }
            case 5: {
                Pair pair;
                Object object = msg.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
                Pair $this$handleMessage_u24lambda_u247 = pair = (Pair)object;
                boolean bl = false;
                Object object5 = $this$handleMessage_u24lambda_u247.getFirst();
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Int");
                this.mWidth = (Integer)object5;
                Object object6 = $this$handleMessage_u24lambda_u247.getSecond();
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.Int");
                this.mHeight = (Integer)object6;
                CameraRender cameraRender = this.mCameraRender;
                if (cameraRender != null) {
                    cameraRender.setSize(this.mWidth, this.mHeight);
                }
                ScreenRender screenRender = this.mScreenRender;
                if (screenRender != null) {
                    screenRender.setSize(this.mWidth, this.mHeight);
                }
                CaptureRender captureRender = this.mCaptureRender;
                if (captureRender != null) {
                    captureRender.setSize(this.mWidth, this.mHeight);
                }
                SurfaceTexture surfaceTexture = this.mCameraSurfaceTexture;
                if (surfaceTexture != null) {
                    surfaceTexture.setDefaultBufferSize(this.mWidth, this.mHeight);
                }
                break;
            }
            case 8: {
                Object object = msg.obj;
                this.saveImageInternal(object instanceof String ? (String)object : null);
                break;
            }
            case 3: {
                Triple triple;
                Object object = msg.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                Triple $this$handleMessage_u24lambda_u248 = triple = (Triple)object;
                boolean bl = false;
                Object object7 = $this$handleMessage_u24lambda_u248.getFirst();
                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type android.view.Surface");
                Surface surface = (Surface)object7;
                Object object8 = $this$handleMessage_u24lambda_u248.getSecond();
                Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.Int");
                int width = (Integer)object8;
                Object object9 = $this$handleMessage_u24lambda_u248.getThird();
                Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.Int");
                int height = (Integer)object9;
                this.startRenderCodecInternal(surface, width, height);
                break;
            }
            case 4: {
                this.stopRenderCodecInternal();
                break;
            }
            case 9: {
                Object $this$handleMessage_u24lambda_u248 = msg.obj;
                RotateType rotateType = $this$handleMessage_u24lambda_u248 instanceof RotateType ? (RotateType)((Object)$this$handleMessage_u24lambda_u248) : null;
                if (rotateType != null) {
                    Object $this$handleMessage_u24lambda_u249 = $this$handleMessage_u24lambda_u248 = rotateType;
                    boolean bl = false;
                    CameraRender cameraRender = this.mCameraRender;
                    if (cameraRender != null) {
                        cameraRender.setRotateAngle((RotateType)((Object)$this$handleMessage_u24lambda_u249));
                    }
                }
                break;
            }
            case 1: {
                Integer textureId;
                Integer n;
                SurfaceTexture surfaceTexture = this.mCameraSurfaceTexture;
                if (surfaceTexture != null) {
                    surfaceTexture.updateTexImage();
                }
                SurfaceTexture surfaceTexture2 = this.mCameraSurfaceTexture;
                if (surfaceTexture2 != null) {
                    surfaceTexture2.getTransformMatrix(this.mTransformMatrix);
                }
                CameraRender cameraRender = this.mCameraRender;
                if (cameraRender != null) {
                    cameraRender.setTransformMatrix(this.mTransformMatrix);
                }
                Integer n4 = this.mEOSTextureId;
                if (n4 != null) {
                    int it = ((Number)n4).intValue();
                    boolean bl = false;
                    CameraRender cameraRender3 = this.mCameraRender;
                    n = cameraRender3 != null ? Integer.valueOf(cameraRender3.drawFrame(it)) : null;
                } else {
                    n = null;
                }
                Integer n5 = textureId = n;
                if (n5 != null) {
                    int fboId = ((Number)n5).intValue();
                    boolean bl = false;
                    int effectId = 0;
                    effectId = fboId;
                    Iterable $this$forEach$iv = this.mEffectList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractEffect effectRender = (AbstractEffect)element$iv;
                        boolean bl3 = false;
                        effectId = effectRender.drawFrame(effectId);
                    }
                    Integer $this$handleMessage_u24lambda_u249 = effectId;
                    int id2 = ((Number)$this$handleMessage_u24lambda_u249).intValue();
                    boolean bl4 = false;
                    ScreenRender screenRender = this.mScreenRender;
                    if (screenRender != null) {
                        screenRender.drawFrame(id2);
                    }
                    this.drawFrame2Capture(id2);
                    SurfaceTexture surfaceTexture3 = this.mCameraSurfaceTexture;
                    this.drawFrame2Codec(id2, surfaceTexture3 != null ? surfaceTexture3.getTimestamp() : 0L);
                }
                ScreenRender screenRender = this.mScreenRender;
                if (screenRender != null) {
                    SurfaceTexture surfaceTexture4 = this.mCameraSurfaceTexture;
                    screenRender.swapBuffers(surfaceTexture4 != null ? surfaceTexture4.getTimestamp() : 0L);
                }
                break;
            }
            case 6: {
                Object $this$handleMessage_u24lambda_u248 = msg.obj;
                AbstractEffect abstractEffect = $this$handleMessage_u24lambda_u248 instanceof AbstractEffect ? (AbstractEffect)$this$handleMessage_u24lambda_u248 : null;
                if (abstractEffect != null) {
                    AbstractEffect effect = abstractEffect;
                    boolean bl = false;
                    if (this.mEffectList.contains(effect)) break;
                    effect.initGLES();
                    effect.setSize(this.mWidth, this.mHeight);
                    this.mEffectList.add(effect);
                    this.mCacheEffectList.add(effect);
                    Logger.INSTANCE.i(TAG, "add effect, name = " + effect.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                }
                break;
            }
            case 7: {
                Object $this$handleMessage_u24lambda_u248 = msg.obj;
                AbstractEffect abstractEffect = $this$handleMessage_u24lambda_u248 instanceof AbstractEffect ? (AbstractEffect)$this$handleMessage_u24lambda_u248 : null;
                if (abstractEffect != null) {
                    AbstractEffect it = abstractEffect;
                    boolean bl = false;
                    if (!this.mEffectList.contains(it)) break;
                    it.releaseGLES();
                    this.mEffectList.remove(it);
                    this.mCacheEffectList.remove(it);
                    Logger.INSTANCE.i(TAG, "remove effect, name = " + it.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                }
                break;
            }
            case 2: {
                EventBus.INSTANCE.with("render-ready").postMessage(false);
                Iterable $this$forEach$iv = this.mEffectList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractEffect effect = (AbstractEffect)element$iv;
                    boolean bl = false;
                    effect.releaseGLES();
                }
                this.mEffectList.clear();
                CameraRender cameraRender = this.mCameraRender;
                if (cameraRender != null) {
                    cameraRender.releaseGLES();
                }
                ScreenRender screenRender = this.mScreenRender;
                if (screenRender != null) {
                    screenRender.releaseGLES();
                }
                CaptureRender captureRender = this.mCaptureRender;
                if (captureRender != null) {
                    captureRender.releaseGLES();
                }
                SurfaceTexture surfaceTexture = this.mCameraSurfaceTexture;
                if (surfaceTexture != null) {
                    surfaceTexture.setOnFrameAvailableListener(null);
                }
                this.mCameraSurfaceTexture = null;
            }
        }
        return true;
    }

    private final void drawFrame2Capture(int fboId) {
        block6: {
            CaptureRender captureRender = this.mCaptureRender;
            if (captureRender == null) break block6;
            int it = captureRender.drawFrame(fboId);
            boolean bl = false;
            CaptureRender captureRender2 = this.mCaptureRender;
            Intrinsics.checkNotNull((Object)captureRender2);
            Integer n = captureRender2.getFrameBufferId();
            int id2 = ((Number)n).intValue();
            boolean bl2 = false;
            this.mFBOBufferId = id2;
            CaptureRender captureRender3 = this.mCaptureRender;
            int renderWidth = captureRender3 != null ? captureRender3.getRenderWidth() : this.mWidth;
            CaptureRender captureRender4 = this.mCaptureRender;
            int renderHeight = captureRender4 != null ? captureRender4.getRenderHeight() : this.mHeight;
            int rgbaLen = renderWidth * renderHeight * 4;
            CopyOnWriteArrayList<IPreviewDataCallBack> copyOnWriteArrayList = this.mPreviewDataCbList;
            if (copyOnWriteArrayList == null) break block6;
            Iterable $this$forEach$iv = copyOnWriteArrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ByteBuffer it2;
                IPreviewDataCallBack callback;
                block8: {
                    block7: {
                        callback = (IPreviewDataCallBack)element$iv;
                        boolean bl3 = false;
                        if (this.mPreviewByteBuffer == null) break block7;
                        ByteBuffer byteBuffer = this.mPreviewByteBuffer;
                        if (byteBuffer != null ? byteBuffer.remaining() == rgbaLen : false) break block8;
                    }
                    ByteBuffer byteBuffer = this.mPreviewByteBuffer = ByteBuffer.allocateDirect(rgbaLen);
                    if (byteBuffer != null) {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                }
                if (this.mPreviewByteBuffer == null) continue;
                boolean bl4 = false;
                it2.clear();
                GLBitmapUtils.INSTANCE.readPixelToByteBuffer(id2, renderWidth, renderHeight, this.mPreviewByteBuffer);
                callback.onPreviewData(it2.array(), renderWidth, renderHeight, IPreviewDataCallBack.DataFormat.RGBA);
            }
        }
    }

    public final void startRenderScreen(int w, int h, @Nullable Surface outSurface, @Nullable CameraSurfaceTextureListener listener2) {
        Triple triple;
        Triple triple2;
        HandlerThread handlerThread = this.mRenderThread = new HandlerThread(RENDER_THREAD);
        if (handlerThread != null) {
            handlerThread.start();
        }
        HandlerThread handlerThread2 = this.mRenderThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.mRenderHandler = new Handler(handlerThread2.getLooper(), (Handler.Callback)this);
        Triple $this$startRenderScreen_u24lambda_u2421 = triple2 = new Triple((Object)w, (Object)h, (Object)outSurface);
        boolean bl = false;
        Handler handler = this.mRenderHandler;
        if (handler != null && (handler = handler.obtainMessage(0, (Object)$this$startRenderScreen_u24lambda_u2421)) != null) {
            handler.sendToTarget();
        }
        try {
            $this$startRenderScreen_u24lambda_u2421 = this.getMStFuture().get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "wait for creating camera SurfaceTexture failed");
            $this$startRenderScreen_u24lambda_u2421 = null;
        }
        triple2 = $this$startRenderScreen_u24lambda_u2421;
        if (triple2 != null) {
            Triple $this$startRenderScreen_u24lambda_u2422 = $this$startRenderScreen_u24lambda_u2421 = triple2;
            boolean bl2 = false;
            $this$startRenderScreen_u24lambda_u2422.setDefaultBufferSize(w, h);
            $this$startRenderScreen_u24lambda_u2422.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.mCameraSurfaceTexture = $this$startRenderScreen_u24lambda_u2422;
            triple = $this$startRenderScreen_u24lambda_u2421;
        } else {
            triple = null;
        }
        Triple it = triple2 = triple;
        boolean bl3 = false;
        CameraSurfaceTextureListener cameraSurfaceTextureListener = listener2;
        if (cameraSurfaceTextureListener != null) {
            cameraSurfaceTextureListener.onSurfaceTextureAvailable((SurfaceTexture)it);
        }
        Logger.INSTANCE.i(TAG, "create camera SurfaceTexture: " + it);
        this.setRenderSize(w, h);
    }

    public static /* synthetic */ void startRenderScreen$default(RenderManager renderManager, int n, int n2, Surface surface, CameraSurfaceTextureListener cameraSurfaceTextureListener, int n3, Object object) {
        if ((n3 & 8) != 0) {
            cameraSurfaceTextureListener = null;
        }
        renderManager.startRenderScreen(n, n2, surface, cameraSurfaceTextureListener);
    }

    public final void stopRenderScreen() {
        Handler handler = this.mRenderHandler;
        if (handler != null && (handler = handler.obtainMessage(2)) != null) {
            handler.sendToTarget();
        }
        HandlerThread handlerThread = this.mRenderThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        this.mRenderThread = null;
        this.mRenderHandler = null;
    }

    public final void startRenderCodec(@NotNull Surface inputSurface, int width, int height) {
        block0: {
            Triple triple;
            Intrinsics.checkNotNullParameter((Object)inputSurface, (String)"inputSurface");
            Triple $this$startRenderCodec_u24lambda_u2424 = triple = new Triple((Object)inputSurface, (Object)width, (Object)height);
            boolean bl = false;
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(3, (Object)$this$startRenderCodec_u24lambda_u2424)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void stopRenderCodec() {
        block0: {
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(4)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void setRenderSize(int w, int h) {
        block0: {
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(5, (Object)new Pair((Object)w, (Object)h))) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void addRenderEffect(@Nullable AbstractEffect effect) {
        block0: {
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(6, (Object)effect)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void removeRenderEffect(@Nullable AbstractEffect effect) {
        block0: {
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(7, (Object)effect)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void setRotateType(@Nullable RotateType type) {
        block0: {
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(9, (Object)type)) == null) break block0;
            handler.sendToTarget();
        }
    }

    @NotNull
    public final ArrayList<AbstractEffect> getCacheEffectList() {
        return this.mCacheEffectList;
    }

    public final void saveImage(@Nullable ICaptureCallBack callBack, @Nullable String path) {
        block0: {
            this.mCaptureDataCb = callBack;
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(8, (Object)path)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        block0: {
            this.emitFrameRate();
            Handler handler = this.mRenderHandler;
            if (handler == null || (handler = handler.obtainMessage(1)) == null) break block0;
            handler.sendToTarget();
        }
    }

    private final void startRenderCodecInternal(Surface surface, int w, int h) {
        block3: {
            Handler handler;
            this.stopRenderCodecInternal();
            HandlerThread handlerThread = this.mRenderCodecThread = new HandlerThread(RENDER_CODEC_THREAD);
            if (handlerThread != null) {
                handlerThread.start();
            }
            HandlerThread handlerThread2 = this.mRenderCodecThread;
            Intrinsics.checkNotNull((Object)handlerThread2);
            this.mRenderCodecHandler = new Handler(handlerThread2.getLooper(), arg_0 -> RenderManager.startRenderCodecInternal$lambda$28(this, arg_0));
            ScreenRender screenRender = this.mScreenRender;
            EGLContext it = screenRender != null ? screenRender.getCurrentContext() : null;
            boolean bl = false;
            if (it == null) {
                throw new NullPointerException("Current EGLContext can't be null.");
            }
            Handler handler2 = this.mRenderCodecHandler;
            if (handler2 != null && (handler2 = handler2.obtainMessage(17, (Object)new Pair((Object)it, (Object)surface))) != null) {
                handler2.sendToTarget();
            }
            if ((handler = this.mRenderCodecHandler) == null || (handler = handler.obtainMessage(18, (Object)new Pair((Object)w, (Object)h))) == null) break block3;
            handler.sendToTarget();
        }
    }

    private final void drawFrame2Codec(int textureId, long timeStamps) {
        block0: {
            Pair pair;
            Pair $this$drawFrame2Codec_u24lambda_u2430 = pair = new Pair((Object)textureId, (Object)timeStamps);
            boolean bl = false;
            Handler handler = this.mRenderCodecHandler;
            if (handler == null || (handler = handler.obtainMessage(19, (Object)$this$drawFrame2Codec_u24lambda_u2430)) == null) break block0;
            handler.sendToTarget();
        }
    }

    private final void stopRenderCodecInternal() {
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (handler = handler.obtainMessage(20)) != null) {
            handler.sendToTarget();
        }
        HandlerThread handlerThread = this.mRenderCodecThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        this.mRenderCodecThread = null;
        this.mRenderCodecHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveImageInternal(String savePath) {
        String string;
        String displayName;
        String string2;
        String title;
        if (this.getMCaptureState().get()) {
            return;
        }
        this.getMCaptureState().set(true);
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda$31(this));
        String date = this.getMDateFormat().format(System.currentTimeMillis());
        String string3 = savePath;
        if (string3 == null) {
            string3 = title = "IMG_AUSBC_" + date;
        }
        if ((string2 = savePath) == null) {
            string2 = displayName = title + ".jpg";
        }
        if ((string = savePath) == null) {
            string = this.getMCameraDir() + '/' + displayName;
        }
        String path = string;
        int width = this.mWidth;
        int height = this.mHeight;
        FileOutputStream fos = null;
        try {
            Bitmap bitmap;
            fos = new FileOutputStream(path);
            Bitmap $this$saveImageInternal_u24lambda_u2432 = bitmap = GLBitmapUtils.INSTANCE.transFrameBufferToBitmap(this.mFBOBufferId, width, height);
            boolean bl = false;
            $this$saveImageInternal_u24lambda_u2432.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            $this$saveImageInternal_u24lambda_u2432.recycle();
            try {
                fos.close();
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, "Failed to write file, err = " + e.getLocalizedMessage(), e);
            }
        }
        catch (IOException e) {
            this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda$33(this, e));
            Logger.INSTANCE.e(TAG, "Failed to write file, err = " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                FileOutputStream fileOutputStream = fos;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, "Failed to write file, err = " + e.getLocalizedMessage(), e);
            }
        }
        File file = new File(path);
        if (file.length() == 0L) {
            Logger.INSTANCE.e(TAG, "Failed to save file " + path);
            file.delete();
            this.getMCaptureState().set(false);
            return;
        }
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("width", Integer.valueOf(width));
        values.put("height", Integer.valueOf(height));
        ContentResolver contentResolver = this.mContext.getContentResolver();
        if (contentResolver != null) {
            contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda$34(this, path));
        this.getMCaptureState().set(false);
        if (!Utils.INSTANCE.getDebugCamera()) return;
        Logger.INSTANCE.i(TAG, "captureImageInternal save path = " + path);
    }

    private final void emitFrameRate() {
        int n = this.mFrameRate;
        this.mFrameRate = n + 1;
        this.mEndTime = System.currentTimeMillis();
        if (this.mEndTime - this.mStartTime >= 1000L) {
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "camera render frame rate is " + this.mFrameRate + " fps-->" + Thread.currentThread().getName());
            }
            EventBus.INSTANCE.with("frame-rate").postMessage(this.mFrameRate);
            this.mStartTime = this.mEndTime;
            this.mFrameRate = 0;
        }
    }

    private static final SettableFuture mStFuture_delegate$lambda$0() {
        return new SettableFuture();
    }

    private static final Handler mMainHandler_delegate$lambda$1() {
        return new Handler(Looper.getMainLooper());
    }

    private static final AtomicBoolean mCaptureState_delegate$lambda$2() {
        return new AtomicBoolean(false);
    }

    private static final SimpleDateFormat mDateFormat_delegate$lambda$3() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault());
    }

    private static final String mCameraDir_delegate$lambda$4() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/Camera";
    }

    private static final boolean startRenderCodecInternal$lambda$28(RenderManager this$0, Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (message.what) {
            case 17: {
                Pair pair;
                Object object = message.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
                Pair $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2425 = pair = (Pair)object;
                boolean bl = false;
                Object object2 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2425.getFirst();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.opengl.EGLContext");
                EGLContext shareContext = (EGLContext)object2;
                Object object3 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2425.getSecond();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.view.Surface");
                Surface inputSurface = (Surface)object3;
                EncodeRender encodeRender = this$0.mEncodeRender = new EncodeRender(this$0.mContext);
                if (encodeRender != null) {
                    encodeRender.initEGLEvn(shareContext);
                }
                EncodeRender encodeRender2 = this$0.mEncodeRender;
                if (encodeRender2 != null) {
                    encodeRender2.setupSurface(inputSurface);
                }
                EncodeRender encodeRender3 = this$0.mEncodeRender;
                if (encodeRender3 != null) {
                    encodeRender3.initGLES();
                }
                break;
            }
            case 18: {
                Pair pair;
                Object object = message.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
                Pair $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2426 = pair = (Pair)object;
                boolean bl = false;
                Object object4 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2426.getFirst();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
                int width = (Integer)object4;
                Object object5 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2426.getSecond();
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Int");
                int height = (Integer)object5;
                EncodeRender encodeRender = this$0.mEncodeRender;
                if (encodeRender != null) {
                    encodeRender.setSize(width, height);
                }
                break;
            }
            case 19: {
                Pair pair;
                Object object = message.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
                Pair $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2427 = pair = (Pair)object;
                boolean bl = false;
                Object object6 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2427.getFirst();
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.Int");
                int textureId = (Integer)object6;
                Object object7 = $this$startRenderCodecInternal_u24lambda_u2428_u24lambda_u2427.getSecond();
                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Long");
                long timeStamps = (Long)object7;
                EncodeRender encodeRender = this$0.mEncodeRender;
                if (encodeRender != null) {
                    encodeRender.drawFrame(textureId);
                }
                EncodeRender encodeRender4 = this$0.mEncodeRender;
                if (encodeRender4 != null) {
                    encodeRender4.swapBuffers(timeStamps);
                }
                break;
            }
            case 20: {
                EncodeRender encodeRender = this$0.mEncodeRender;
                if (encodeRender != null) {
                    encodeRender.releaseGLES();
                }
                this$0.mEncodeRender = null;
            }
        }
        return true;
    }

    private static final void saveImageInternal$lambda$31(RenderManager this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onBegin();
        }
    }

    private static final void saveImageInternal$lambda$33(RenderManager this$0, IOException $e) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void saveImageInternal$lambda$34(RenderManager this$0, String $path) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onComplete($path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "", "onSurfaceTextureAvailable", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "libausbc_release"})
    public static interface CameraSurfaceTextureListener {
        public void onSurfaceTextureAvailable(@Nullable SurfaceTexture var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$Companion;", "", "<init>", "()V", "TAG", "", "RENDER_THREAD", "RENDER_CODEC_THREAD", "MSG_GL_INIT", "", "MSG_GL_DRAW", "MSG_GL_RELEASE", "MSG_GL_START_RENDER_CODEC", "MSG_GL_STOP_RENDER_CODEC", "MSG_GL_CHANGED_SIZE", "MSG_GL_ADD_EFFECT", "MSG_GL_REMOVE_EFFECT", "MSG_GL_SAVE_IMAGE", "MSG_GL_ROUTE_ANGLE", "MSG_GL_RENDER_CODEC_INIT", "MSG_GL_RENDER_CODEC_CHANGED_SIZE", "MSG_GL_RENDER_CODEC_DRAW", "MSG_GL_RENDER_CODEC_RELEASE", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

