/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode.audio;

import android.media.AudioRecord;
import android.os.Process;
import com.jiangdg.ausbc.encode.audio.IAudioStrategy;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategySystem;", "Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;", "<init>", "()V", "mBufferSize", "", "getMBufferSize", "()I", "mBufferSize$delegate", "Lkotlin/Lazy;", "mAudioRecord", "Landroid/media/AudioRecord;", "initAudioRecord", "", "startRecording", "stopRecording", "releaseAudioRecord", "read", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "isRecording", "", "getSampleRate", "getAudioFormat", "getChannelCount", "getChannelConfig", "Companion", "libausbc_release"})
public final class AudioStrategySystem
implements IAudioStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mBufferSize$delegate = LazyKt.lazy(AudioStrategySystem::mBufferSize_delegate$lambda$0);
    @Nullable
    private AudioRecord mAudioRecord;
    @NotNull
    private static final String TAG = "AudioSystem";
    private static final int SAMPLE_RATE = 8000;
    private static final int CHANNEL_COUNT = 1;
    private static final int CHANNEL_IN_CONFIG = 16;
    private static final int AUDIO_FORMAT_16BIT = 2;
    private static final int AUDIO_RECORD_SOURCE = 1;

    private final int getMBufferSize() {
        Lazy lazy = this.mBufferSize$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public void initAudioRecord() {
        try {
            Process.setThreadPriority((int)-16);
            this.mAudioRecord = new AudioRecord(1, 8000, 16, 2, this.getMBufferSize());
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "initAudioRecord success");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "initAudioRecord failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void startRecording() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.startRecording();
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                AudioRecord audioRecord2 = this.mAudioRecord;
                Logger.INSTANCE.i(TAG, "startRecording success-->" + (audioRecord2 != null ? Integer.valueOf(audioRecord2.getRecordingState()) : null));
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "startRecording failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void stopRecording() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.stop();
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "stopRecording success");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "startRecording failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void releaseAudioRecord() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.release();
            }
            this.mAudioRecord = null;
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "releaseAudioRecord success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "releaseAudioRecord failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    @Nullable
    public RawData read() {
        RawData rawData;
        if (!this.isRecording()) {
            rawData = null;
        } else {
            byte[] data = new byte[this.getMBufferSize()];
            AudioRecord audioRecord = this.mAudioRecord;
            int readBytes = audioRecord != null ? audioRecord.read(data, 0, this.getMBufferSize()) : 0;
            rawData = new RawData(data, readBytes);
        }
        return rawData;
    }

    @Override
    public boolean isRecording() {
        AudioRecord audioRecord = this.mAudioRecord;
        return audioRecord != null ? audioRecord.getRecordingState() == 3 : false;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }

    @Override
    public int getAudioFormat() {
        return 2;
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public int getChannelConfig() {
        return 16;
    }

    private static final int mBufferSize_delegate$lambda$0() {
        return AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategySystem$Companion;", "", "<init>", "()V", "TAG", "", "SAMPLE_RATE", "", "CHANNEL_COUNT", "CHANNEL_IN_CONFIG", "AUDIO_FORMAT_16BIT", "AUDIO_RECORD_SOURCE", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

