/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.utils.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b&\u0018\u0000 O2\u00020\u0001:\u0001OB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u000e\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\u001cJ\u0010\u00107\u001a\u0002032\b\u00108\u001a\u0004\u0018\u00010\u0015J\u000e\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\u0013J\u000e\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u0018J\u0006\u0010=\u001a\u00020\u0003J\b\u0010>\u001a\u00020?H$J\b\u0010@\u001a\u000203H$J\b\u0010A\u001a\u000203H$J\u0010\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u001cH$J\b\u0010D\u001a\u00020\u0003H\u0002J\b\u0010E\u001a\u000203H\u0004J\b\u0010F\u001a\u000203H\u0002J&\u0010G\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020J\u0018\u00010H2\u0006\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020.H$J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010<\u001a\u00020NH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\u001b\u0010(\u001a\u00020)8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010'\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010'\u001a\u0004\b/\u00100\u00a8\u0006P"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "", "isVideo", "", "<init>", "(Z)V", "mEncodeThread", "Landroid/os/HandlerThread;", "mEncodeHandler", "Landroid/os/Handler;", "mStartTimeStamps", "", "mMediaCodec", "Landroid/media/MediaCodec;", "getMMediaCodec", "()Landroid/media/MediaCodec;", "setMMediaCodec", "(Landroid/media/MediaCodec;)V", "mMp4Muxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mEncodeDataCb", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "mRawDataQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "getMRawDataQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "mBitRate", "", "getMBitRate", "()Ljava/lang/Integer;", "setMBitRate", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "isExit", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "Lkotlin/Lazy;", "mEncodeState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMEncodeState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mEncodeState$delegate", "mBufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "getMBufferInfo", "()Landroid/media/MediaCodec$BufferInfo;", "mBufferInfo$delegate", "startEncode", "", "stopEncode", "updateBitRate", "bitRate", "setEncodeDataCallBack", "callBack", "setMp4Muxer", "muxer", "putRawData", "data", "isEncoding", "getThreadName", "", "handleStartEncode", "handleStopEncode", "getPTSUs", "bufferSize", "isLowerLollipop", "doEncodeData", "queueFrameIfNeed", "processOutputData", "Lkotlin/Pair;", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack$DataType;", "Ljava/nio/ByteBuffer;", "encodeData", "bufferInfo", "processInputData", "", "Companion", "libausbc_release"})
public abstract class AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVideo;
    @Nullable
    private HandlerThread mEncodeThread;
    @Nullable
    private Handler mEncodeHandler;
    private long mStartTimeStamps;
    @Nullable
    private MediaCodec mMediaCodec;
    @Nullable
    private Mp4Muxer mMp4Muxer;
    @Nullable
    private IEncodeDataCallBack mEncodeDataCb;
    @NotNull
    private final ConcurrentLinkedQueue<RawData> mRawDataQueue;
    @Nullable
    private Integer mBitRate;
    private boolean isExit;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private final Lazy mEncodeState$delegate;
    @NotNull
    private final Lazy mBufferInfo$delegate;
    @NotNull
    private static final String TAG = "AbstractProcessor";
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final long TIMES_OUT_US = 10000L;
    public static final int MAX_QUEUE_SIZE = 5;

    public AbstractProcessor(boolean isVideo) {
        this.isVideo = isVideo;
        this.mRawDataQueue = new ConcurrentLinkedQueue();
        this.isExit = true;
        this.mMainHandler$delegate = LazyKt.lazy(AbstractProcessor::mMainHandler_delegate$lambda$0);
        this.mEncodeState$delegate = LazyKt.lazy(AbstractProcessor::mEncodeState_delegate$lambda$1);
        this.mBufferInfo$delegate = LazyKt.lazy(AbstractProcessor::mBufferInfo_delegate$lambda$2);
    }

    @Nullable
    protected final MediaCodec getMMediaCodec() {
        return this.mMediaCodec;
    }

    protected final void setMMediaCodec(@Nullable MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
    }

    @NotNull
    protected final ConcurrentLinkedQueue<RawData> getMRawDataQueue() {
        return this.mRawDataQueue;
    }

    @Nullable
    protected final Integer getMBitRate() {
        return this.mBitRate;
    }

    protected final void setMBitRate(@Nullable Integer n) {
        this.mBitRate = n;
    }

    @NotNull
    protected final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @NotNull
    protected final AtomicBoolean getMEncodeState() {
        Lazy lazy = this.mEncodeState$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    private final MediaCodec.BufferInfo getMBufferInfo() {
        Lazy lazy = this.mBufferInfo$delegate;
        return (MediaCodec.BufferInfo)lazy.getValue();
    }

    public final void startEncode() {
        HandlerThread handlerThread = this.mEncodeThread = new HandlerThread(this.getThreadName());
        if (handlerThread != null) {
            handlerThread.start();
        }
        HandlerThread handlerThread2 = this.mEncodeThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.mEncodeHandler = new Handler(handlerThread2.getLooper(), arg_0 -> AbstractProcessor.startEncode$lambda$3(this, arg_0));
        Handler handler = this.mEncodeHandler;
        if (handler != null && (handler = handler.obtainMessage(1)) != null) {
            handler.sendToTarget();
        }
        this.isExit = false;
    }

    public final void stopEncode() {
        this.isExit = true;
        Handler handler = this.mEncodeHandler;
        if (handler != null && (handler = handler.obtainMessage(2)) != null) {
            handler.sendToTarget();
        }
        HandlerThread handlerThread = this.mEncodeThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        this.mEncodeThread = null;
        this.mEncodeHandler = null;
    }

    public final void updateBitRate(int bitRate) {
        block1: {
            Handler handler;
            this.mBitRate = bitRate;
            Handler handler2 = this.mEncodeHandler;
            if (handler2 != null && (handler2 = handler2.obtainMessage(2)) != null) {
                handler2.sendToTarget();
            }
            if ((handler = this.mEncodeHandler) == null || (handler = handler.obtainMessage(1)) == null) break block1;
            handler.sendToTarget();
        }
    }

    public final void setEncodeDataCallBack(@Nullable IEncodeDataCallBack callBack) {
        this.mEncodeDataCb = callBack;
    }

    public final synchronized void setMp4Muxer(@NotNull Mp4Muxer muxer) {
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        this.mMp4Muxer = muxer;
        if (!this.isEncoding()) {
            return;
        }
        try {
            Mp4Muxer mp4Muxer = this.mMp4Muxer;
            if (mp4Muxer != null) {
                MediaCodec mediaCodec = this.mMediaCodec;
                mp4Muxer.addTracker((MediaFormat)(mediaCodec != null ? mediaCodec.getOutputFormat() : null), this.isVideo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void putRawData(@NotNull RawData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.getMEncodeState().get()) {
            return;
        }
        if (this.mRawDataQueue.size() >= 5) {
            this.mRawDataQueue.poll();
        }
        this.mRawDataQueue.offer(data);
    }

    public final boolean isEncoding() {
        return this.getMEncodeState().get() && !this.isExit;
    }

    @NotNull
    protected abstract String getThreadName();

    protected abstract void handleStartEncode();

    protected abstract void handleStopEncode();

    protected abstract long getPTSUs(int var1);

    private final boolean isLowerLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doEncodeData() {
        while (this.isEncoding()) {
            try {
                this.queueFrameIfNeed();
                int outputIndex = 0;
                do {
                    Unit unit;
                    MediaCodec codec;
                    if (this.mMediaCodec == null) continue;
                    boolean bl = false;
                    outputIndex = codec.dequeueOutputBuffer(this.getMBufferInfo(), 10000L);
                    if (outputIndex == -2) {
                        Logger.INSTANCE.i(TAG, "addTracker is video = " + this.isVideo);
                        Mp4Muxer mp4Muxer = this.mMp4Muxer;
                        if (mp4Muxer == null) continue;
                        MediaCodec mediaCodec = this.mMediaCodec;
                        mp4Muxer.addTracker((MediaFormat)(mediaCodec != null ? mediaCodec.getOutputFormat() : null), this.isVideo);
                        continue;
                    }
                    if (outputIndex < 0) continue;
                    if (this.mStartTimeStamps == 0L) {
                        this.mStartTimeStamps = this.getMBufferInfo().presentationTimeUs / 1000L;
                    }
                    try {
                        Unit unit2;
                        ByteBuffer outputBuffer = this.isLowerLollipop() ? codec.getOutputBuffers()[outputIndex] : codec.getOutputBuffer(outputIndex);
                        if (outputBuffer == null) continue;
                        if (this.processOutputData(outputBuffer, this.getMBufferInfo()) != null) {
                            Pair<IEncodeDataCallBack.DataType, ByteBuffer> pair;
                            Pair<IEncodeDataCallBack.DataType, ByteBuffer> $this$doEncodeData_u24lambda_u245_u24lambda_u244 = pair;
                            boolean bl2 = false;
                            IEncodeDataCallBack iEncodeDataCallBack = this.mEncodeDataCb;
                            if (iEncodeDataCallBack != null) {
                                iEncodeDataCallBack.onEncodeData((IEncodeDataCallBack.DataType)((Object)$this$doEncodeData_u24lambda_u245_u24lambda_u244.getFirst()), outputBuffer, this.getMBufferInfo().offset, this.getMBufferInfo().size, this.getMBufferInfo().presentationTimeUs / 1000L - this.mStartTimeStamps);
                            }
                        }
                        Mp4Muxer mp4Muxer = this.mMp4Muxer;
                        if (mp4Muxer != null) {
                            mp4Muxer.pumpStream(outputBuffer, this.getMBufferInfo(), this.isVideo);
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        unit = unit2;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        codec.releaseOutputBuffer(outputIndex, false);
                    }
                } while (outputIndex >= 0);
            }
            catch (Exception e) {
                Logger.INSTANCE.e(TAG, "doEncodeData failed, video = " + this.isVideo + "\uff0c err = " + e.getLocalizedMessage(), e);
                continue;
            }
            break;
        }
        return;
    }

    private final void queueFrameIfNeed() {
        block4: {
            MediaCodec mediaCodec = this.mMediaCodec;
            if (mediaCodec == null) break block4;
            MediaCodec codec = mediaCodec;
            boolean bl = false;
            if (!this.mRawDataQueue.isEmpty()) {
                int inputIndex;
                RawData rawData;
                byte[] data;
                RawData rawData2 = this.mRawDataQueue.poll();
                if (rawData2 != null && this.processInputData(data = (rawData = rawData2).getData()) != null && (inputIndex = codec.dequeueInputBuffer(10000L)) >= 0) {
                    ByteBuffer inputBuffer;
                    ByteBuffer byteBuffer = inputBuffer = this.isLowerLollipop() ? codec.getInputBuffers()[inputIndex] : codec.getInputBuffer(inputIndex);
                    if (byteBuffer != null) {
                        byteBuffer.clear();
                    }
                    ByteBuffer byteBuffer2 = inputBuffer;
                    if (byteBuffer2 != null) {
                        byteBuffer2.put(data);
                    }
                    codec.queueInputBuffer(inputIndex, 0, data.length, this.getPTSUs(data.length), 0);
                }
            }
        }
    }

    @Nullable
    protected abstract Pair<IEncodeDataCallBack.DataType, ByteBuffer> processOutputData(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    @Nullable
    protected abstract byte[] processInputData(@NotNull byte[] var1);

    private static final Handler mMainHandler_delegate$lambda$0() {
        return new Handler(Looper.getMainLooper());
    }

    private static final AtomicBoolean mEncodeState_delegate$lambda$1() {
        return new AtomicBoolean(false);
    }

    private static final MediaCodec.BufferInfo mBufferInfo_delegate$lambda$2() {
        return new MediaCodec.BufferInfo();
    }

    private static final boolean startEncode$lambda$3(AbstractProcessor this$0, Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 1: {
                this$0.handleStartEncode();
                break;
            }
            case 2: {
                this$0.handleStopEncode();
            }
        }
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor$Companion;", "", "<init>", "()V", "TAG", "", "MSG_START", "", "MSG_STOP", "TIMES_OUT_US", "", "MAX_QUEUE_SIZE", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

